/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profgen;

import com.android.tools.profgen.ArchiveClassFileResourceProvider;
import com.android.tools.profgen.ClassFileResourceKt;
import com.android.tools.profgen.Diagnostics;
import com.android.tools.profgen.HumanReadableProfile;
import com.android.tools.profgen.HumanReadableProfileKt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\r"}, d2={"expandWildcards", "", "hrpPath", "", "outPath", "programPaths", "", "stdErrorDiagnostics", "Lcom/android/tools/profgen/Diagnostics;", "readHumanReadableProfileOrExit", "Lcom/android/tools/profgen/HumanReadableProfile;", "hrpFile", "Ljava/io/File;", "profgen"})
@SourceDebugExtension(value={"SMAP\nProfgenUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfgenUtils.kt\ncom/android/tools/profgen/ProfgenUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class ProfgenUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void expandWildcards(@NotNull String hrpPath, @NotNull String outPath, @NotNull Collection<String> programPaths, @NotNull Diagnostics stdErrorDiagnostics) {
        Object archiveClassFileResourceProvider;
        Intrinsics.checkNotNullParameter((Object)hrpPath, (String)"hrpPath");
        Intrinsics.checkNotNullParameter((Object)outPath, (String)"outPath");
        Intrinsics.checkNotNullParameter(programPaths, (String)"programPaths");
        Intrinsics.checkNotNullParameter((Object)stdErrorDiagnostics, (String)"stdErrorDiagnostics");
        Path path = Paths.get(hrpPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(path)");
        File hrpFile = path.toFile();
        if (!hrpFile.exists()) {
            boolean $i$a$-require-ProfgenUtilsKt$expandWildcards$72 = false;
            String $i$a$-require-ProfgenUtilsKt$expandWildcards$72 = "File not found: " + hrpPath;
            throw new IllegalArgumentException($i$a$-require-ProfgenUtilsKt$expandWildcards$72.toString());
        }
        Path path2 = Paths.get(outPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
        File outFile = path2.toFile();
        if (!outFile.getParentFile().exists()) {
            boolean $i$a$-require-ProfgenUtilsKt$expandWildcards$82 = false;
            String $i$a$-require-ProfgenUtilsKt$expandWildcards$82 = "Directory does not exist: " + outFile.getParent();
            throw new IllegalArgumentException($i$a$-require-ProfgenUtilsKt$expandWildcards$82.toString());
        }
        if (!(!programPaths.isEmpty())) {
            boolean $i$a$-require-ProfgenUtilsKt$expandWildcards$92 = false;
            String $i$a$-require-ProfgenUtilsKt$expandWildcards$92 = "Must pass at least one program source";
            throw new IllegalArgumentException($i$a$-require-ProfgenUtilsKt$expandWildcards$92.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)hrpFile, (String)"hrpFile");
        HumanReadableProfile hrp = ProfgenUtilsKt.readHumanReadableProfileOrExit(hrpFile, stdErrorDiagnostics);
        List archiveClassFileResourceProviders = new ArrayList();
        List classFileResources = new ArrayList();
        for (String programPath : programPaths) {
            if (StringsKt.endsWith$default((String)programPath, (String)".class", (boolean)false, (int)2, null)) {
                int separatorIndex = StringsKt.lastIndexOf$default((CharSequence)programPath, (char)':', (int)0, (boolean)false, (int)6, null);
                if (!(separatorIndex >= 0)) {
                    boolean $i$a$-require-ProfgenUtilsKt$expandWildcards$102 = false;
                    String $i$a$-require-ProfgenUtilsKt$expandWildcards$102 = "Missing ':' separator for class file: " + programPath;
                    throw new IllegalArgumentException($i$a$-require-ProfgenUtilsKt$expandWildcards$102.toString());
                }
                String string = programPath.substring(separatorIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                String classBinaryName = StringsKt.dropLast((String)string, (int)6);
                String classDescriptor = ClassFileResourceKt.getClassDescriptorFromBinaryName(classBinaryName);
                String string2 = programPath.substring(0, separatorIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Object object = string2;
                String[] stringArray = new String[]{classBinaryName + ".class"};
                Path path3 = Paths.get((String)object, Arrays.copyOf(stringArray, stringArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(base, *subpaths)");
                File programFile = path3.toFile();
                if (!programFile.exists()) {
                    boolean bl = false;
                    String string3 = "File not found: " + programFile;
                    throw new IllegalArgumentException(string3.toString());
                }
                object = classFileResources;
                Path path4 = programFile.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"programFile.toPath()");
                object.add(ClassFileResourceKt.ClassFileResource(classDescriptor, path4));
                continue;
            }
            if (StringsKt.endsWith$default((String)programPath, (String)".jar", (boolean)false, (int)2, null)) {
                Path path5 = Paths.get(programPath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"get(path)");
                File programFile = path5.toFile();
                if (!programFile.exists()) {
                    boolean $i$a$-require-ProfgenUtilsKt$expandWildcards$112 = false;
                    String $i$a$-require-ProfgenUtilsKt$expandWildcards$112 = "File not found: " + programPath;
                    throw new IllegalArgumentException($i$a$-require-ProfgenUtilsKt$expandWildcards$112.toString());
                }
                Path path6 = programFile.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"programFile.toPath()");
                archiveClassFileResourceProvider = new ArchiveClassFileResourceProvider(path6, null, 2, null);
                ((Collection)archiveClassFileResourceProviders).add(archiveClassFileResourceProvider);
                CollectionsKt.addAll((Collection)classFileResources, (Iterable)((ArchiveClassFileResourceProvider)archiveClassFileResourceProvider).getClassFileResources());
                continue;
            }
            throw new IllegalArgumentException("Unexpected program file: " + programPath);
        }
        HumanReadableProfile result2 = hrp.expandWildcards(classFileResources);
        Intrinsics.checkNotNullExpressionValue((Object)outFile, (String)"outFile");
        Iterator iterator2 = outFile;
        Object programFile = Charsets.UTF_8;
        archiveClassFileResourceProvider = iterator2;
        int $i$a$-require-ProfgenUtilsKt$expandWildcards$112 = 8192;
        Object object = archiveClassFileResourceProvider;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)programFile);
        iterator2 = new PrintWriter(object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, $i$a$-require-ProfgenUtilsKt$expandWildcards$112));
        programFile = null;
        try {
            PrintWriter it = (PrintWriter)((Object)iterator2);
            boolean bl = false;
            result2.printExact(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            programFile = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)((Object)iterator2), (Throwable)programFile);
        }
        for (ArchiveClassFileResourceProvider archiveClassFileResourceProvider2 : archiveClassFileResourceProviders) {
            try {
                archiveClassFileResourceProvider2.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @NotNull
    public static final HumanReadableProfile readHumanReadableProfileOrExit(@NotNull File hrpFile, @NotNull Diagnostics stdErrorDiagnostics) {
        Intrinsics.checkNotNullParameter((Object)hrpFile, (String)"hrpFile");
        Intrinsics.checkNotNullParameter((Object)stdErrorDiagnostics, (String)"stdErrorDiagnostics");
        HumanReadableProfile hrp = HumanReadableProfileKt.HumanReadableProfile(hrpFile, stdErrorDiagnostics);
        if (hrp == null) {
            System.err.println("Failed to parse " + hrpFile + ".");
            System.exit(-1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        return hrp;
    }
}

