/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.gradle.internal.NdkHandlerInput;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.SdkComponentsKt;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.dsl.NdkOptions;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataTask;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataWorkAction;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.NATIVE, secondaryTaskCategories={TaskCategory.METADATA})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0003%&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010#\u001a\u00020$H\u0014R \u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000f\u00a8\u0006("}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "<set-?>", "Lcom/android/build/gradle/internal/dsl/NdkOptions$DebugSymbolLevel;", "debugSymbolLevel", "getDebugSymbolLevel", "()Lcom/android/build/gradle/internal/dsl/NdkOptions$DebugSymbolLevel;", "execOperations", "Lorg/gradle/process/ExecOperations;", "getExecOperations", "()Lorg/gradle/process/ExecOperations;", "inputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getInputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "inputFiles", "Lorg/gradle/api/file/FileTree;", "getInputFiles", "()Lorg/gradle/api/file/FileTree;", "maxWorkerCount", "", "ndkHandlerInput", "Lcom/android/build/gradle/internal/NdkHandlerInput;", "getNdkHandlerInput", "()Lcom/android/build/gradle/internal/NdkHandlerInput;", "outputDir", "getOutputDir", "sdkBuildService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkBuildService", "()Lorg/gradle/api/provider/Property;", "strippedNativeLibs", "getStrippedNativeLibs", "doTaskAction", "", "CreationAction", "FullCreationAction", "SymbolTableCreationAction", "gradle-core"})
public abstract class ExtractNativeDebugMetadataTask
extends NonIncrementalTask {
    private NdkOptions.DebugSymbolLevel debugSymbolLevel;
    private final int maxWorkerCount = this.getProject().getGradle().getStartParameter().getMaxWorkerCount();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getInputDir();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getStrippedNativeLibs();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Inject
    @NotNull
    public abstract ExecOperations getExecOperations();

    @Nested
    @NotNull
    public abstract NdkHandlerInput getNdkHandlerInput();

    @Input
    @NotNull
    public final NdkOptions.DebugSymbolLevel getDebugSymbolLevel() {
        NdkOptions.DebugSymbolLevel debugSymbolLevel = this.debugSymbolLevel;
        if (debugSymbolLevel != null) {
            return debugSymbolLevel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"debugSymbolLevel");
        return null;
    }

    @Internal
    @NotNull
    public abstract Property<SdkComponentsBuildService> getSdkBuildService();

    @InputFiles
    @IgnoreEmptyDirectories
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileTree getInputFiles() {
        FileTree fileTree = this.getInputDir().getAsFileTree();
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"inputDir.asFileTree");
        return fileTree;
    }

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(ExtractNativeDebugMetadataWorkAction.class, new Action(this){
            final /* synthetic */ ExtractNativeDebugMetadataTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ExtractNativeDebugMetadataWorkAction.Parameters it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                it.getInputDir().set((Provider)this.this$0.getInputDir());
                it.getStrippedNativeLibs().set((Provider)this.this$0.getStrippedNativeLibs());
                it.getOutputDir().set((Provider)this.this$0.getOutputDir());
                it.getObjcopyExecutableMap().set(this.this$0.getSdkBuildService().flatMap(new Transformer(this.this$0){
                    final /* synthetic */ ExtractNativeDebugMetadataTask this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final Provider<? extends Map<String, File>> transform(SdkComponentsBuildService buildService) {
                        return buildService.versionedNdkHandler(this.this$0.getNdkHandlerInput()).getObjcopyExecutableMapProvider();
                    }
                }));
                it.getDebugSymbolLevel().set((Object)((Object)this.this$0.getDebugSymbolLevel()));
                it.getMaxWorkerCount().set((Object)ExtractNativeDebugMetadataTask.access$getMaxWorkerCount$p(this.this$0));
            }
        });
    }

    public static final /* synthetic */ int access$getMaxWorkerCount$p(ExtractNativeDebugMetadataTask $this) {
        return $this.maxWorkerCount;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nExtractNativeDebugMetadataTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractNativeDebugMetadataTask.kt\ncom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataTask$CreationAction\n+ 2 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,363:1\n67#2:364\n*S KotlinDebug\n*F\n+ 1 ExtractNativeDebugMetadataTask.kt\ncom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataTask$CreationAction\n*L\n144#1:364\n*E\n"})
    public static abstract class CreationAction
    extends VariantTaskCreationAction<ExtractNativeDebugMetadataTask, VariantCreationConfig> {
        public CreationAction(@NotNull VariantCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
        }

        @Override
        @NotNull
        public Class<ExtractNativeDebugMetadataTask> getType() {
            return ExtractNativeDebugMetadataTask.class;
        }

        @Override
        public void configure(@NotNull ExtractNativeDebugMetadataTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct((Artifact.Single)SingleArtifact.MERGED_NATIVE_LIBS.INSTANCE, (Property)task.getInputDir());
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.STRIPPED_NATIVE_LIBS.INSTANCE, (Property)task.getStrippedNativeLibs());
            BuildServiceRegistry buildServiceRegistry$iv = ((VariantCreationConfig)this.creationConfig).getServices().getBuildServiceRegistry();
            boolean $i$f$getBuildService = false;
            HasConfigurableValuesKt.setDisallowChanges(task.getSdkBuildService(), BuildServicesKt.getBuildService(buildServiceRegistry$iv, SdkComponentsBuildService.class));
            SdkComponentsKt.initialize(task.getNdkHandlerInput(), this.creationConfig);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataTask$FullCreationAction;", "Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataTask$CreationAction;", "creationConfig", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "configure", "", "task", "Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataTask;", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class FullCreationAction
    extends CreationAction {
        public FullCreationAction(@NotNull VariantCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("extract", "NativeDebugMetadata");
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ExtractNativeDebugMetadataTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("out").on(InternalArtifactType.NATIVE_DEBUG_METADATA.INSTANCE);
        }

        @Override
        public void configure(@NotNull ExtractNativeDebugMetadataTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure(task);
            task.debugSymbolLevel = NdkOptions.DebugSymbolLevel.FULL;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataTask$SymbolTableCreationAction;", "Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataTask$CreationAction;", "creationConfig", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "configure", "", "task", "Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataTask;", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class SymbolTableCreationAction
    extends CreationAction {
        public SymbolTableCreationAction(@NotNull VariantCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("extract", "NativeSymbolTables");
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ExtractNativeDebugMetadataTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("out").on(InternalArtifactType.NATIVE_SYMBOL_TABLES.INSTANCE);
        }

        @Override
        public void configure(@NotNull ExtractNativeDebugMetadataTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure(task);
            task.debugSymbolLevel = NdkOptions.DebugSymbolLevel.SYMBOL_TABLE;
        }
    }
}

