/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.dsl.DensitySplit;
import com.android.build.gradle.internal.dsl.SplitOptions;
import com.android.build.gradle.internal.dsl.decorator.annotation.WithLazyInitialization;
import com.android.resources.Density;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public abstract class DensitySplitOptions
extends SplitOptions
implements DensitySplit {
    @Inject
    @WithLazyInitialization(methodName="lazyInit")
    public DensitySplitOptions() {
    }

    protected void lazyInit() {
        this.setStrict(true);
        this.init();
    }

    @Override
    protected Set<String> getDefaultValues() {
        Set values = Density.getRecommendedValuesForDevice();
        HashSet fullList = Sets.newHashSetWithExpectedSize((int)values.size());
        for (Density value : values) {
            fullList.add(value.getResourceValue());
        }
        return fullList;
    }

    @Override
    protected ImmutableSet<String> getAllowedValues() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Density value : Density.values()) {
            if (value == Density.NODPI || value == Density.ANYDPI) continue;
            builder.add((Object)value.getResourceValue());
        }
        return builder.build();
    }

    public void setCompatibleScreens(List<String> sizes) {
        ArrayList<String> newValues = new ArrayList<String>(sizes);
        this.getCompatibleScreens().clear();
        this.getCompatibleScreens().addAll(newValues);
    }

    public void compatibleScreens(String ... sizes) {
        this.getCompatibleScreens().addAll(Arrays.asList(sizes));
    }

    @Deprecated
    public void setAuto(boolean auto) {
        throw new RuntimeException("DensitySplitOptions.auto is not supported anymore.");
    }
}

