/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.component.impl.AndroidTestImpl;
import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.component.impl.TestFixturesImpl;
import com.android.build.api.component.impl.UnitTestImpl;
import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.variant.ComponentIdentity;
import com.android.build.api.variant.impl.FilterConfigurationImpl;
import com.android.build.api.variant.impl.VariantBuilderImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.api.variant.impl.VariantOutputConfigurationImpl;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.BaseServices;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.services.VariantPropertiesApiServices;
import com.android.build.gradle.internal.services.VariantPropertiesApiServicesImpl;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestFixturesVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.errors.IssueReporter;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.gradle.api.Project;

public abstract class BaseVariantFactory<VariantBuilderT extends VariantBuilderImpl, VariantT extends VariantImpl>
implements VariantFactory<VariantBuilderT, VariantT> {
    private static final String ANDROID_APT_PLUGIN_NAME = "com.neenbedankt.android-apt";
    protected final ProjectServices projectServices;
    @Deprecated
    private final VariantPropertiesApiServices servicesForOldVariantObjectsOnly;

    public BaseVariantFactory(ProjectServices projectServices2) {
        this.projectServices = projectServices2;
        this.servicesForOldVariantObjectsOnly = new VariantPropertiesApiServicesImpl(projectServices2, false);
    }

    @Override
    public TestFixturesImpl createTestFixtures(ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, VariantDslInfo variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, ArtifactsImpl artifacts2, VariantScope variantScope, TestFixturesVariantData variantData, VariantImpl mainVariant, TransformManager transformManager, VariantPropertiesApiServices variantPropertiesApiServices, TaskCreationServices taskCreationServices, GlobalTaskCreationConfig globalConfig) {
        TestFixturesImpl testFixturesComponent = (TestFixturesImpl)this.projectServices.getObjectFactory().newInstance(TestFixturesImpl.class, new Object[]{componentIdentity, buildFeatures, variantDslInfo, variantDependencies, variantSources, paths, artifacts2, variantScope, variantData, mainVariant, transformManager, variantPropertiesApiServices, taskCreationServices, globalConfig});
        String name = testFixturesComponent.getServices().getProjectInfo().getProjectBaseName() + "-" + testFixturesComponent.getBaseName() + "-testFixtures." + "aar";
        testFixturesComponent.addVariantOutput(new VariantOutputConfigurationImpl(false, (Collection<FilterConfigurationImpl>)ImmutableList.of()), name);
        return testFixturesComponent;
    }

    @Override
    public UnitTestImpl createUnitTest(ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, VariantDslInfo variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, ArtifactsImpl artifacts2, VariantScope variantScope, TestVariantData variantData, VariantImpl testedVariant, TransformManager transformManager, VariantPropertiesApiServices variantPropertiesApiServices, TaskCreationServices taskCreationServices, GlobalTaskCreationConfig globalConfig) {
        UnitTestImpl unitTestProperties = (UnitTestImpl)this.projectServices.getObjectFactory().newInstance(UnitTestImpl.class, new Object[]{componentIdentity, buildFeatures, variantDslInfo, variantDependencies, variantSources, paths, artifacts2, variantScope, variantData, testedVariant, transformManager, variantPropertiesApiServices, taskCreationServices, globalConfig});
        unitTestProperties.addVariantOutput(new VariantOutputConfigurationImpl(false, (Collection<FilterConfigurationImpl>)ImmutableList.of()), null);
        return unitTestProperties;
    }

    @Override
    public AndroidTestImpl createAndroidTest(ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, VariantDslInfo variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, ArtifactsImpl artifacts2, VariantScope variantScope, TestVariantData variantData, VariantImpl testedVariant, TransformManager transformManager, VariantPropertiesApiServices variantPropertiesApiServices, TaskCreationServices taskCreationServices, GlobalTaskCreationConfig globalConfig) {
        AndroidTestImpl androidTestProperties = (AndroidTestImpl)this.projectServices.getObjectFactory().newInstance(AndroidTestImpl.class, new Object[]{componentIdentity, buildFeatures, variantDslInfo, variantDependencies, variantSources, paths, artifacts2, variantScope, variantData, testedVariant, transformManager, variantPropertiesApiServices, taskCreationServices, globalConfig});
        androidTestProperties.addVariantOutput(new VariantOutputConfigurationImpl(false, (Collection<FilterConfigurationImpl>)ImmutableList.of()), null);
        return androidTestProperties;
    }

    @Override
    public BaseVariantImpl createVariantApi(ComponentImpl component2, BaseVariantData variantData, ReadOnlyObjectProvider readOnlyObjectProvider) {
        Class<BaseVariantImpl> implementationClass = this.getVariantImplementationClass();
        return (BaseVariantImpl)this.projectServices.getObjectFactory().newInstance(implementationClass, new Object[]{variantData, component2, this.servicesForOldVariantObjectsOnly, readOnlyObjectProvider, this.projectServices.getProjectInfo().getProject().container(VariantOutput.class)});
    }

    @Override
    @Deprecated
    public BaseServices getServicesForOldVariantObjectsOnly() {
        return this.servicesForOldVariantObjectsOnly;
    }

    @Override
    public void preVariantCallback(Project project2, CommonExtension<?, ?, ?, ?> dslExtension, VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model) {
        if (project2.getPluginManager().hasPlugin(ANDROID_APT_PLUGIN_NAME)) {
            this.projectServices.getIssueReporter().reportError(IssueReporter.Type.INCOMPATIBLE_PLUGIN, "android-apt plugin is incompatible with the Android Gradle plugin.  Please use 'annotationProcessor' configuration instead.", "android-apt");
        }
        this.validateBuildConfig(model, dslExtension.getBuildFeatures().getBuildConfig());
        this.validateResValues(model, dslExtension.getBuildFeatures().getResValues());
    }

    void validateBuildConfig(VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model, Boolean buildConfig) {
        if (buildConfig == null) {
            buildConfig = this.projectServices.getProjectOptions().get(BooleanOption.BUILD_FEATURE_BUILDCONFIG);
        }
        if (!buildConfig.booleanValue()) {
            SyncIssueReporter issueReporter2 = this.projectServices.getIssueReporter();
            if (!model.getDefaultConfigData().getDefaultConfig().getBuildConfigFields().isEmpty()) {
                issueReporter2.reportError(IssueReporter.Type.GENERIC, "defaultConfig contains custom BuildConfig fields, but the feature is disabled.");
            }
            for (BuildTypeData<BuildType> buildTypeData : model.getBuildTypes().values()) {
                if (buildTypeData.getBuildType().getBuildConfigFields().isEmpty()) continue;
                issueReporter2.reportError(IssueReporter.Type.GENERIC, String.format("Build Type '%s' contains custom BuildConfig fields, but the feature is disabled.", buildTypeData.getBuildType().getName()));
            }
            for (ProductFlavorData productFlavorData : model.getProductFlavors().values()) {
                if (((ProductFlavor)productFlavorData.getProductFlavor()).getBuildConfigFields().isEmpty()) continue;
                issueReporter2.reportError(IssueReporter.Type.GENERIC, String.format("Product Flavor '%s' contains custom BuildConfig fields, but the feature is disabled.", ((ProductFlavor)productFlavorData.getProductFlavor()).getName()));
            }
        }
    }

    void validateResValues(VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model, Boolean resValues2) {
        if (resValues2 == null) {
            resValues2 = this.projectServices.getProjectOptions().get(BooleanOption.BUILD_FEATURE_RESVALUES);
        }
        if (!resValues2.booleanValue()) {
            SyncIssueReporter issueReporter2 = this.projectServices.getIssueReporter();
            if (!model.getDefaultConfigData().getDefaultConfig().getResValues().isEmpty()) {
                issueReporter2.reportError(IssueReporter.Type.GENERIC, "defaultConfig contains custom resource values, but the feature is disabled.");
            }
            for (BuildTypeData<BuildType> buildTypeData : model.getBuildTypes().values()) {
                if (buildTypeData.getBuildType().getResValues().isEmpty()) continue;
                issueReporter2.reportError(IssueReporter.Type.GENERIC, String.format("Build Type '%s' contains custom resource values, but the feature is disabled.", buildTypeData.getBuildType().getName()));
            }
            for (ProductFlavorData productFlavorData : model.getProductFlavors().values()) {
                if (((ProductFlavor)productFlavorData.getProductFlavor()).getResValues().isEmpty()) continue;
                issueReporter2.reportError(IssueReporter.Type.GENERIC, String.format("Product Flavor '%s' contains custom resource values, but the feature is disabled.", ((ProductFlavor)productFlavorData.getProductFlavor()).getName()));
            }
        }
    }
}

