/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.services;

import com.android.aaptcompiler.BlameLogger;
import com.android.aaptcompiler.ResourceCompiler;
import com.android.aaptcompiler.ResourceCompilerOptions;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.res.Aapt2ErrorUtils;
import com.android.builder.internal.aapt.AaptConvertConfig;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.v2.Aapt2;
import com.android.ide.common.resources.CompileResourceRequest;
import com.android.utils.ILogger;
import java.io.File;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/services/PartialInProcessResourceProcessor;", "Lcom/android/builder/internal/aapt/v2/Aapt2;", "delegate", "(Lcom/android/builder/internal/aapt/v2/Aapt2;)V", "getDelegate", "()Lcom/android/builder/internal/aapt/v2/Aapt2;", "compile", "", "request", "Lcom/android/ide/common/resources/CompileResourceRequest;", "logger", "Lcom/android/utils/ILogger;", "convert", "Lcom/android/builder/internal/aapt/AaptConvertConfig;", "link", "Lcom/android/builder/internal/aapt/AaptPackageConfig;", "gradle-core"})
@ThreadSafe
public final class PartialInProcessResourceProcessor
implements Aapt2 {
    @NotNull
    private final Aapt2 delegate;

    public PartialInProcessResourceProcessor(@NotNull Aapt2 delegate2) {
        Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
        this.delegate = delegate2;
    }

    @NotNull
    public final Aapt2 getDelegate() {
        return this.delegate;
    }

    public void compile(@NotNull CompileResourceRequest request2, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (ResourceCompiler.canCompileResourceInJvm((File)request2.getInputFile(), (boolean)request2.isPngCrunching())) {
            boolean bl = request2.isPseudoLocalize();
            Object object = request2.getSourcePath();
            File file = request2.getPartialRFile();
            ResourceCompilerOptions options = new ResourceCompilerOptions(null, null, false, bl, file, true, false, (String)object, 71, null);
            object = LoggerWrapper.getLogger(this.getClass());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLogger(this::class.java)");
            BlameLogger blameLogger = Aapt2ErrorUtils.blameLoggerFor(request2, (LoggerWrapper)object);
            ResourceCompiler.compileResource((File)request2.getInputFile(), (File)request2.getOutputDirectory(), (ResourceCompilerOptions)options, (BlameLogger)blameLogger);
        } else {
            this.delegate.compile(request2, logger);
        }
    }

    public void link(@NotNull AaptPackageConfig request2, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.delegate.link(request2, logger);
    }

    public void convert(@NotNull AaptConvertConfig request2, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.delegate.convert(request2, logger);
    }
}

