/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.dsl.Lint;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.lint.AndroidLintTask;
import com.android.build.gradle.internal.lint.AndroidLintTextOutputTask;
import com.android.build.gradle.internal.lint.AndroidLintWorkAction;
import com.android.build.gradle.internal.lint.LintTaskManager;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.AndroidLocationsBuildService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u0000 ,2\u00020\u0001:\u0005,-./0B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J/\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010\u000e\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b%J\b\u0010&\u001a\u00020\u001eH\u0014J-\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b*J\b\u0010+\u001a\u00020\u001eH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0014\u0010\u0013\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u00061"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "abortOnError", "Lorg/gradle/api/provider/Property;", "", "getAbortOnError", "()Lorg/gradle/api/provider/Property;", "android", "getAndroid", "deprecatedGlobalRuleJars", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getDeprecatedGlobalRuleJars", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "fatalOnly", "getFatalOnly", "outputStream", "Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$OutputStream;", "getOutputStream", "returnValueInputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getReturnValueInputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "textReportInputFile", "getTextReportInputFile", "abbreviateLintTextFile", "", "file", "Ljava/io/File;", "configureForStandalone", "", "taskCreationServices", "Lcom/android/build/gradle/internal/services/TaskCreationServices;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "lintOptions", "Lcom/android/build/api/dsl/Lint;", "configureForStandalone$gradle_core", "doTaskAction", "initializeCommonInputs", "project", "Lorg/gradle/api/Project;", "initializeCommonInputs$gradle_core", "maybeWarnAboutDeprecatedGlobalRuleJars", "Companion", "LintVitalCreationAction", "OutputStream", "SingleVariantCreationAction", "VariantCreationAction", "gradle-core"})
public abstract class AndroidLintTextOutputTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Integer> HANDLED_ERRORS;

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getTextReportInputFile();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getReturnValueInputFile();

    @Input
    @NotNull
    public abstract Property<OutputStream> getOutputStream();

    @Input
    @NotNull
    public abstract Property<Boolean> getFatalOnly();

    @Input
    @NotNull
    public abstract Property<Boolean> getAndroid();

    @Input
    @NotNull
    public abstract Property<Boolean> getAbortOnError();

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract ConfigurableFileCollection getDeprecatedGlobalRuleJars();

    @Override
    protected void doTaskAction() {
        boolean bl;
        boolean bl2;
        File file;
        this.maybeWarnAboutDeprecatedGlobalRuleJars();
        if (this.getOutputStream().get() != OutputStream.ABBREVIATED) {
            file = ((RegularFile)this.getTextReportInputFile().get()).getAsFile();
            bl2 = false;
            bl = false;
            File textReportFile = file;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)textReportFile, (String)"textReportFile");
            String text = FilesKt.readText$default((File)textReportFile, null, (int)1, null);
            if (!StringsKt.startsWith$default((String)text, (String)"No issues found", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)text, (CharSequence)"0 errors, 0 warnings", (boolean)false, (int)2, null)) {
                OutputStream outputStream = (OutputStream)((Object)this.getOutputStream().get());
                int n = outputStream == null ? -1 : WhenMappings.$EnumSwitchMapping$0[outputStream.ordinal()];
                switch (n) {
                    case 1: {
                        this.getLogger().lifecycle(text);
                        break;
                    }
                    case 2: {
                        this.getLogger().error(text);
                    }
                }
            }
        }
        file = ((RegularFile)this.getReturnValueInputFile().get()).getAsFile();
        bl2 = false;
        bl = false;
        File returnValueFile = file;
        boolean bl4 = false;
        if (!returnValueFile.isFile()) {
            throw new RuntimeException("Missing lint invocation return value file.");
        }
        Intrinsics.checkNotNullExpressionValue((Object)returnValueFile, (String)"returnValueFile");
        Object object = FilesKt.readText$default((File)returnValueFile, null, (int)1, null);
        boolean bl5 = false;
        int returnValue = Integer.parseInt((String)object);
        if (HANDLED_ERRORS.contains(returnValue)) {
            if (this.getOutputStream().get() == OutputStream.ABBREVIATED) {
                Logger logger = this.getLogger();
                object = ((RegularFile)this.getTextReportInputFile().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"textReportInputFile.get().asFile");
                logger.lifecycle(this.abbreviateLintTextFile((File)object));
            }
            if (returnValue == 1 && !((Boolean)this.getAbortOnError().get()).booleanValue()) {
                return;
            }
            object = this.getAndroid().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"android.get()");
            boolean bl6 = (Boolean)object;
            object = this.getFatalOnly().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fatalOnly.get()");
            AndroidLintWorkAction.Companion.maybeThrowException(returnValue, bl6, (Boolean)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String abbreviateLintTextFile(File file) {
        int n;
        StringBuilder $this$abbreviateLintTextFile_u24lambda_u2d4;
        StringBuilder stringBuilder;
        Object object;
        List lines;
        block6: {
            Object element$iv;
            StringBuilder stringBuilder2;
            block5: {
                void $this$last$iv;
                lines = FilesKt.readLines$default((File)file, null, (int)1, null);
                object = lines;
                boolean bl = false;
                if (object.size() < 25) {
                    return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                }
                stringBuilder = new StringBuilder();
                boolean bl2 = false;
                boolean bl3 = false;
                $this$abbreviateLintTextFile_u24lambda_u2d4 = stringBuilder;
                boolean bl4 = false;
                $this$abbreviateLintTextFile_u24lambda_u2d4.append("Lint found ");
                List list = lines;
                stringBuilder2 = $this$abbreviateLintTextFile_u24lambda_u2d4;
                boolean $i$f$last = false;
                ListIterator iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
                while (iterator$iv.hasPrevious()) {
                    element$iv = iterator$iv.previous();
                    String it = (String)element$iv;
                    boolean bl5 = false;
                    CharSequence charSequence = it;
                    boolean bl6 = false;
                    boolean bl7 = charSequence.length() > 0;
                    if (!bl7) continue;
                    break block5;
                }
                throw (Throwable)new NoSuchElementException("List contains no element matching the predicate.");
            }
            Object e = element$iv;
            stringBuilder2.append((String)e);
            $this$abbreviateLintTextFile_u24lambda_u2d4.append(". First failure:\n\n");
            List $this$indexOfFirst$iv = lines;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                String it = (String)item$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)" ", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)it, (CharSequence)"Error: ", (boolean)false, (int)2, null)) {
                    n = index$iv;
                    break block6;
                }
                ++index$iv;
            }
            n = -1;
        }
        int firstError = n;
        int n2 = 0;
        boolean bl = false;
        int line = Math.max(n2, firstError);
        while (true) {
            $this$abbreviateLintTextFile_u24lambda_u2d4.append((String)lines.get(line)).append("\n");
            if (StringsKt.startsWith$default((String)((String)lines.get(++line)), (String)" ", (boolean)false, (int)2, null)) continue;
            CharSequence charSequence = (CharSequence)lines.get(line);
            bl = false;
            if (charSequence.length() > 0) break;
        }
        $this$abbreviateLintTextFile_u24lambda_u2d4.append("\nThe full lint text report is located at:\n  ");
        $this$abbreviateLintTextFile_u24lambda_u2d4.append(file.getAbsolutePath());
        object = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"StringBuilder().apply {\n\u2026ath)\n        }.toString()");
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void maybeWarnAboutDeprecatedGlobalRuleJars() {
        void $this$filterTo$iv$iv;
        Set set = this.getDeprecatedGlobalRuleJars().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"deprecatedGlobalRuleJars.files");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter2 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.isFile()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List deprecatedJars = (List)destination$iv$iv;
        $this$filter$iv = deprecatedJars;
        $i$f$filter2 = false;
        if (!$this$filter$iv.isEmpty()) {
            String $i$f$filter2 = ((File)deprecatedJars.get(0)).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$filter2, (String)"deprecatedJars[0].parent");
            String parent = $i$f$filter2;
            String jarNames2 = CollectionsKt.joinToString$default((Iterable)deprecatedJars, null, null, null, (int)0, null, (Function1)maybeWarnAboutDeprecatedGlobalRuleJars.jarNames.1.INSTANCE, (int)31, null);
            this.getLogger().warn("Loaded lint jar file from " + parent + " (" + jarNames2 + "); this will stop working soon. If you need to push lint rules into a build, use the `ANDROID_LINT_JARS` environment variable or a `lint.xml` file setting `<lint lintJars=\"path\"...>`");
        }
    }

    public final void initializeCommonInputs$gradle_core(@NotNull Project project2, @NotNull ArtifactsImpl artifacts2, @NotNull Lint lintOptions2, boolean fatalOnly) {
        boolean bl;
        File file;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
        Intrinsics.checkNotNullParameter((Object)lintOptions2, (String)"lintOptions");
        HasConfigurableValuesKt.setDisallowChanges((Property)this.getTextReportInputFile(), artifacts2.get(fatalOnly ? (InternalArtifactType)InternalArtifactType.LINT_VITAL_INTERMEDIATE_TEXT_REPORT.INSTANCE : (InternalArtifactType)InternalArtifactType.LINT_INTERMEDIATE_TEXT_REPORT.INSTANCE));
        HasConfigurableValuesKt.setDisallowChanges((Property)this.getReturnValueInputFile(), artifacts2.get(fatalOnly ? (InternalArtifactType)InternalArtifactType.LINT_VITAL_RETURN_VALUE.INSTANCE : (InternalArtifactType)InternalArtifactType.LINT_RETURN_VALUE.INSTANCE));
        HasConfigurableValuesKt.setDisallowChanges(this.getFatalOnly(), fatalOnly);
        HasConfigurableValuesKt.setDisallowChanges(this.getAbortOnError(), lintOptions2.getAbortOnError());
        File textOutput = lintOptions2.getTextOutput();
        if (fatalOnly || lintOptions2.getTextReport() && ((file = textOutput) == null ? false : LintTaskManager.Companion.isLintStderr$gradle_core(file))) {
            HasConfigurableValuesKt.setDisallowChanges(this.getOutputStream(), OutputStream.STDERR);
        } else if (lintOptions2.getTextReport() && ((file = textOutput) == null ? true : (bl = LintTaskManager.Companion.isLintStdout$gradle_core(file)))) {
            HasConfigurableValuesKt.setDisallowChanges(this.getOutputStream(), OutputStream.STDOUT);
        } else {
            HasConfigurableValuesKt.setDisallowChanges(this.getOutputStream(), OutputStream.ABBREVIATED);
        }
        Object[] objectArray = project2.getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.gradle.sharedServices");
        Object[] buildServiceRegistry$iv = objectArray;
        boolean $i$f$getBuildService = false;
        Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AndroidLocationsBuildService.class));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
        }
        Provider provider2 = ((BuildServiceRegistration)object).getService();
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.reg\u2026erviceT, *>).getService()");
        Provider locationsBuildService = provider2;
        objectArray = new Object[]{AndroidLintTask.Companion.getGlobalLintJarsInPrefsDir(project2, (Provider<AndroidLocationsBuildService>)locationsBuildService)};
        HasConfigurableValuesKt.fromDisallowChanges(this.getDeprecatedGlobalRuleJars(), objectArray);
    }

    public final void configureForStandalone$gradle_core(@NotNull TaskCreationServices taskCreationServices, @NotNull ArtifactsImpl artifacts2, @NotNull Lint lintOptions2, boolean fatalOnly) {
        Intrinsics.checkNotNullParameter((Object)taskCreationServices, (String)"taskCreationServices");
        Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
        Intrinsics.checkNotNullParameter((Object)lintOptions2, (String)"lintOptions");
        Property<AnalyticsService> property = this.getAnalyticsService();
        BuildServiceRegistry buildServiceRegistry = this.getProject().getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
        BuildServiceRegistry buildServiceRegistry$iv = buildServiceRegistry;
        boolean $i$f$getBuildService = false;
        Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AnalyticsService.class));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
        }
        Provider provider2 = ((BuildServiceRegistration)object).getService();
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.reg\u2026erviceT, *>).getService()");
        HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        this.setGroup("verification");
        this.setDescription("Print text output from the corresponding lint report task");
        HasConfigurableValuesKt.setDisallowChanges(this.getAndroid(), false);
        this.setVariantName("");
        this.initializeCommonInputs$gradle_core(taskCreationServices.getProjectInfo().getProject(), artifacts2, lintOptions2, fatalOnly);
    }

    public static /* synthetic */ void configureForStandalone$gradle_core$default(AndroidLintTextOutputTask androidLintTextOutputTask, TaskCreationServices taskCreationServices, ArtifactsImpl artifactsImpl, Lint lint2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureForStandalone");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        androidLintTextOutputTask.configureForStandalone$gradle_core(taskCreationServices, artifactsImpl, lint2, bl);
    }

    static {
        Object[] objectArray = new Integer[]{1, 6};
        HANDLED_ERRORS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$SingleVariantCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$VariantCreationAction;", "variant", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "fatalOnly", "", "getFatalOnly", "()Z", "name", "", "getName", "()Ljava/lang/String;", "gradle-core"})
    public static final class SingleVariantCreationAction
    extends VariantCreationAction {
        @NotNull
        private final String name;
        private final boolean fatalOnly;

        public SingleVariantCreationAction(@NotNull VariantCreationConfig variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            super(variant2);
            this.name = VariantTaskCreationAction.computeTaskName$default(this, "lint", null, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getFatalOnly() {
            return this.fatalOnly;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$LintVitalCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$VariantCreationAction;", "variant", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "fatalOnly", "", "getFatalOnly", "()Z", "name", "", "getName", "()Ljava/lang/String;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask;", "gradle-core"})
    public static final class LintVitalCreationAction
    extends VariantCreationAction {
        @NotNull
        private final String name;
        private final boolean fatalOnly;

        public LintVitalCreationAction(@NotNull VariantCreationConfig variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            super(variant2);
            this.name = VariantTaskCreationAction.computeTaskName$default(this, "lintVital", null, 2, null);
            this.fatalOnly = true;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getFatalOnly() {
            return this.fatalOnly;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AndroidLintTextOutputTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            TaskProvider[] taskProviderArray = new TaskProvider[]{taskProvider};
            TaskFactoryUtils.dependsOn(((VariantCreationConfig)this.creationConfig).getTaskContainer().getAssembleTask(), taskProviderArray);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$VariantCreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "variant", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "fatalOnly", "", "getFatalOnly", "()Z", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static abstract class VariantCreationAction
    extends VariantTaskCreationAction<AndroidLintTextOutputTask, VariantCreationConfig> {
        public VariantCreationAction(@NotNull VariantCreationConfig variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            super((ComponentCreationConfig)variant2);
        }

        @Override
        @NotNull
        public Class<AndroidLintTextOutputTask> getType() {
            return AndroidLintTextOutputTask.class;
        }

        public abstract boolean getFatalOnly();

        @Override
        public void configure(@NotNull AndroidLintTextOutputTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.setGroup("verification");
            task.setDescription("Print text output from the corresponding lint report task");
            HasConfigurableValuesKt.setDisallowChanges(task.getAndroid(), true);
            task.initializeCommonInputs$gradle_core(((VariantCreationConfig)this.creationConfig).getServices().getProjectInfo().getProject(), ((VariantCreationConfig)this.creationConfig).getArtifacts(), ((VariantCreationConfig)this.creationConfig).getGlobal().getLintOptions(), this.getFatalOnly());
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$OutputStream;", "", "(Ljava/lang/String;I)V", "STDOUT", "STDERR", "ABBREVIATED", "gradle-core"})
    public static final class OutputStream
    extends Enum<OutputStream> {
        public static final /* enum */ OutputStream STDOUT = new OutputStream();
        public static final /* enum */ OutputStream STDERR = new OutputStream();
        public static final /* enum */ OutputStream ABBREVIATED = new OutputStream();
        private static final /* synthetic */ OutputStream[] $VALUES;

        public static OutputStream[] values() {
            return (OutputStream[])$VALUES.clone();
        }

        public static OutputStream valueOf(String value) {
            return Enum.valueOf(OutputStream.class, value);
        }

        static {
            $VALUES = outputStreamArray = new OutputStream[]{OutputStream.STDOUT, OutputStream.STDERR, OutputStream.ABBREVIATED};
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$Companion;", "", "()V", "HANDLED_ERRORS", "", "", "getHANDLED_ERRORS", "()Ljava/util/List;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Integer> getHANDLED_ERRORS() {
            return HANDLED_ERRORS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OutputStream.values().length];
            nArray[OutputStream.STDOUT.ordinal()] = 1;
            nArray[OutputStream.STDERR.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

