/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.dsl.SingleVariant;
import com.android.build.gradle.internal.services.DslServices;
import com.android.builder.errors.IssueReporter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001aB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0004\u00a2\u0006\u0002\u0010\u0012J7\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00140\u0016\u00a2\u0006\u0002\b\u0017H\u0004J\u001e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/dsl/AbstractPublishing;", "T", "Lcom/android/build/api/dsl/SingleVariant;", "", "dslService", "Lcom/android/build/gradle/internal/services/DslServices;", "(Lcom/android/build/gradle/internal/services/DslServices;)V", "getDslService", "()Lcom/android/build/gradle/internal/services/DslServices;", "singleVariants", "", "getSingleVariants", "()Ljava/util/List;", "addSingleVariant", "variantName", "", "implementationClass", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Lcom/android/build/api/dsl/SingleVariant;", "addSingleVariantAndConfigure", "", "action", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "checkSingleVariantUniqueness", "", "Type", "gradle-core"})
public abstract class AbstractPublishing<T extends SingleVariant> {
    @NotNull
    private final DslServices dslService;

    public AbstractPublishing(@NotNull DslServices dslService) {
        Intrinsics.checkNotNullParameter((Object)dslService, (String)"dslService");
        this.dslService = dslService;
    }

    @NotNull
    public final DslServices getDslService() {
        return this.dslService;
    }

    @NotNull
    public abstract List<T> getSingleVariants();

    @NotNull
    protected final T addSingleVariant(@NotNull String variantName, @NotNull Class<T> implementationClass) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter(implementationClass, (String)"implementationClass");
        this.checkSingleVariantUniqueness(variantName, this.getSingleVariants());
        Object[] objectArray = new Object[]{this.dslService, variantName};
        SingleVariant singleVariant2 = (SingleVariant)this.dslService.newDecoratedInstance(implementationClass, objectArray);
        this.getSingleVariants().add(singleVariant2);
        return (T)singleVariant2;
    }

    protected final void addSingleVariantAndConfigure(@NotNull String variantName, @NotNull Class<T> implementationClass, @NotNull Function1<? super T, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter(implementationClass, (String)"implementationClass");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        action.invoke(this.addSingleVariant(variantName, implementationClass));
    }

    private final void checkSingleVariantUniqueness(String variantName, List<? extends T> singleVariants) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = singleVariants;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SingleVariant it = (SingleVariant)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getVariantName(), (Object)variantName)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            IssueReporter.reportError$default((IssueReporter)this.dslService.getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)("Using singleVariant publishing DSL multiple times to publish variant \"" + variantName + "\" to component \"" + variantName + "\" is not allowed."), null, null, (int)12, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/dsl/AbstractPublishing$Type;", "", "(Ljava/lang/String;I)V", "AAR", "APK", "AAB", "gradle-core"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type AAR = new Type();
        public static final /* enum */ Type APK = new Type();
        public static final /* enum */ Type AAB = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.AAR, Type.APK, Type.AAB};
        }
    }
}

