/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.AarTransformUtil;
import com.android.build.gradle.internal.dependency.ExtractProGuardRulesTransform;
import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.utils.FileUtils;
import java.io.File;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
public abstract class AarTransform
implements TransformAction<Parameters> {
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @InputArtifact
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public static AndroidArtifacts.ArtifactType[] getTransformTargets() {
        return new AndroidArtifacts.ArtifactType[]{AndroidArtifacts.ArtifactType.SHARED_CLASSES, AndroidArtifacts.ArtifactType.JAVA_RES, AndroidArtifacts.ArtifactType.SHARED_JAVA_RES, AndroidArtifacts.ArtifactType.PROCESSED_JAR, AndroidArtifacts.ArtifactType.MANIFEST, AndroidArtifacts.ArtifactType.ANDROID_RES, AndroidArtifacts.ArtifactType.ASSETS, AndroidArtifacts.ArtifactType.SHARED_ASSETS, AndroidArtifacts.ArtifactType.JNI, AndroidArtifacts.ArtifactType.SHARED_JNI, AndroidArtifacts.ArtifactType.AIDL, AndroidArtifacts.ArtifactType.RENDERSCRIPT, AndroidArtifacts.ArtifactType.UNFILTERED_PROGUARD_RULES, AndroidArtifacts.ArtifactType.LINT, AndroidArtifacts.ArtifactType.ANNOTATIONS, AndroidArtifacts.ArtifactType.PUBLIC_RES, AndroidArtifacts.ArtifactType.COMPILE_SYMBOL_LIST, AndroidArtifacts.ArtifactType.DATA_BINDING_ARTIFACT, AndroidArtifacts.ArtifactType.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT, AndroidArtifacts.ArtifactType.RES_STATIC_LIBRARY, AndroidArtifacts.ArtifactType.RES_SHARED_STATIC_LIBRARY, AndroidArtifacts.ArtifactType.PREFAB_PACKAGE, AndroidArtifacts.ArtifactType.AAR_METADATA, AndroidArtifacts.ArtifactType.ART_PROFILE};
    }

    public void transform(TransformOutputs transformOutputs) {
        File input = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        AndroidArtifacts.ArtifactType targetType = (AndroidArtifacts.ArtifactType)((Object)((Parameters)this.getParameters()).getTargetType().get());
        switch (targetType) {
            case CLASSES_JAR: 
            case JAVA_RES: 
            case PROCESSED_JAR: {
                if (this.isShared(input)) break;
                AarTransformUtil.getJars(input).forEach(arg_0 -> ((TransformOutputs)transformOutputs).file(arg_0));
                break;
            }
            case SHARED_CLASSES: 
            case SHARED_JAVA_RES: {
                if (!this.isShared(input)) break;
                AarTransformUtil.getJars(input).forEach(arg_0 -> ((TransformOutputs)transformOutputs).file(arg_0));
                break;
            }
            case LINT: {
                AarTransform.outputIfExists(FileUtils.join((File)input, (String[])new String[]{"jars", "lint.jar"}), transformOutputs);
                break;
            }
            case MANIFEST: {
                AarTransform.outputIfExists(new File(input, "AndroidManifest.xml"), transformOutputs);
                if (!this.isShared(input)) break;
                AarTransform.outputIfExists(new File(input, "SharedLibraryAndroidManifest.xml"), transformOutputs);
                break;
            }
            case ANDROID_RES: {
                AarTransform.outputIfExists(new File(input, "res"), transformOutputs);
                break;
            }
            case ASSETS: {
                AarTransform.outputIfExists(new File(input, "assets"), transformOutputs);
                break;
            }
            case JNI: {
                AarTransform.outputIfExists(new File(input, "jni"), transformOutputs);
                break;
            }
            case AIDL: {
                AarTransform.outputIfExists(new File(input, "aidl"), transformOutputs);
                break;
            }
            case RENDERSCRIPT: {
                AarTransform.outputIfExists(new File(input, "rs"), transformOutputs);
                break;
            }
            case UNFILTERED_PROGUARD_RULES: {
                if (ExtractProGuardRulesTransform.performTransform(FileUtils.join((File)input, (String[])new String[]{"jars", "classes.jar"}), transformOutputs, false)) break;
                AarTransform.outputIfExists(new File(input, "proguard.txt"), transformOutputs);
                break;
            }
            case ANNOTATIONS: {
                AarTransform.outputIfExists(new File(input, "annotations.zip"), transformOutputs);
                break;
            }
            case PUBLIC_RES: {
                AarTransform.outputIfExists(new File(input, "public.txt"), transformOutputs);
                break;
            }
            case COMPILE_SYMBOL_LIST: {
                AarTransform.outputIfExists(new File(input, "R.txt"), transformOutputs);
                break;
            }
            case RES_STATIC_LIBRARY: {
                if (this.isShared(input)) break;
                AarTransform.outputIfExists(new File(input, "res.apk"), transformOutputs);
                break;
            }
            case RES_SHARED_STATIC_LIBRARY: {
                if (!this.isShared(input)) break;
                AarTransform.outputIfExists(new File(input, "shared.apk"), transformOutputs);
                break;
            }
            case DATA_BINDING_ARTIFACT: {
                AarTransform.outputIfExists(new File(input, "data-binding"), transformOutputs);
                break;
            }
            case DATA_BINDING_BASE_CLASS_LOG_ARTIFACT: {
                AarTransform.outputIfExists(new File(input, "data-binding-base-class-log"), transformOutputs);
                break;
            }
            case PREFAB_PACKAGE: {
                AarTransform.outputIfExists(new File(input, "prefab"), transformOutputs);
                break;
            }
            case AAR_METADATA: {
                AarTransform.outputIfExists(FileUtils.join((File)input, (String[])"META-INF/com/android/build/gradle/aar-metadata.properties".split("/")), transformOutputs);
                break;
            }
            case ART_PROFILE: {
                AarTransform.outputIfExists(FileUtils.join((File)input, (String[])new String[]{"baseline-prof.txt"}), transformOutputs);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported type in AarTransform: " + (Object)((Object)targetType));
            }
        }
    }

    private boolean isShared(File explodedAar) {
        return (Boolean)((Parameters)this.getParameters()).getSharedLibSupport().get() != false && new File(explodedAar, "SharedLibraryAndroidManifest.xml").exists();
    }

    private static void outputIfExists(File file, TransformOutputs outputs) {
        if (file.isDirectory()) {
            outputs.dir((Object)file);
        } else if (file.isFile()) {
            outputs.file((Object)file);
        }
    }

    public static interface Parameters
    extends GenericTransformParameters {
        @Input
        public Property<AndroidArtifacts.ArtifactType> getTargetType();

        @Input
        public Property<Boolean> getSharedLibSupport();
    }
}

