/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.profile.AnalyticsResourceManager;
import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.android.build.gradle.internal.profile.TaskProfilingRecord$sam$java_util_function_Predicate$0;
import com.android.build.gradle.internal.profile.WorkerProfilingRecord;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\b\u0016\u0018\u0000 62\u00020\u0001:\u000267B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0005J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0007H\u0016J\u0018\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(H\u0016J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020,J\u0012\u0010-\u001a\u0004\u0018\u00010!2\u0006\u0010&\u001a\u00020\u0007H\u0016J\u0006\u0010.\u001a\u00020,J\u000e\u0010/\u001a\u00020#2\u0006\u0010\u000b\u001a\u000200J\u000e\u00101\u001a\u00020#2\u0006\u0010\u0013\u001a\u000200J\u0006\u00102\u001a\u00020#J\u000e\u00103\u001a\u00020#2\u0006\u00104\u001a\u00020!J\u0006\u00105\u001a\u00020#R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00160\u00160\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000fR\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/build/gradle/internal/profile/TaskProfilingRecord;", "", "resourceManager", "Lcom/android/build/gradle/internal/profile/AnalyticsResourceManager;", "span", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$Builder;", "taskPath", "", "projectPath", "variant", "(Lcom/android/build/gradle/internal/profile/AnalyticsResourceManager;Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$Builder;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "endTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getProjectPath$gradle_core", "()Ljava/lang/String;", "spanBuilder", "getSpanBuilder", "()Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$Builder;", "startTime", "status", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/android/build/gradle/internal/profile/TaskProfilingRecord$Status;", "getStatus$gradle_core", "()Ljava/util/concurrent/atomic/AtomicReference;", "taskSpans", "", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan;", "getTaskSpans", "()Ljava/util/List;", "getVariant$gradle_core", "workerRecordList", "", "Lcom/android/build/gradle/internal/profile/WorkerProfilingRecord;", "addSpan", "", "builder", "addWorker", "key", "type", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$ExecutionType;", "allWorkersFinished", "", "duration", "Ljava/time/Duration;", "get", "minimumWaitTime", "setTaskEndTime", "", "setTaskStartTime", "setTaskWaiting", "workerFinished", "workerRecord", "writeTaskSpan", "Companion", "Status", "gradle-core"})
public class TaskProfilingRecord {
    @NotNull
    private final GradleBuildProfileSpan.Builder spanBuilder;
    private final Map<String, WorkerProfilingRecord> workerRecordList;
    private Instant startTime;
    private Instant endTime;
    @NotNull
    private final AtomicReference<Status> status;
    @NotNull
    private final List<GradleBuildProfileSpan> taskSpans;
    private final AnalyticsResourceManager resourceManager;
    private final String taskPath;
    @NotNull
    private final String projectPath;
    @Nullable
    private final String variant;
    @NotNull
    private static Clock clock;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final GradleBuildProfileSpan.Builder getSpanBuilder() {
        return this.spanBuilder;
    }

    @NotNull
    public final AtomicReference<Status> getStatus$gradle_core() {
        return this.status;
    }

    @GuardedBy(value="this")
    @NotNull
    public final List<GradleBuildProfileSpan> getTaskSpans() {
        return this.taskSpans;
    }

    public final void setTaskWaiting() {
        this.status.set(Status.AWAIT);
    }

    public void addWorker(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.addWorker(key, GradleBuildProfileSpan.ExecutionType.THREAD_EXECUTION);
    }

    public synchronized void addWorker(@NotNull String key, @NotNull GradleBuildProfileSpan.ExecutionType type) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Instant instant = clock.instant();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"clock.instant()");
        WorkerProfilingRecord workerRecord = new WorkerProfilingRecord(this.taskPath, type, instant);
        this.workerRecordList.put(key, workerRecord);
    }

    @Nullable
    public synchronized WorkerProfilingRecord get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.workerRecordList.get(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized boolean allWorkersFinished() {
        if (this.workerRecordList.isEmpty()) return true;
        Stream<WorkerProfilingRecord> stream2 = this.workerRecordList.values().stream();
        Object object = allWorkersFinished.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new TaskProfilingRecord$sam$java_util_function_Predicate$0(function1);
        }
        if (!stream2.allMatch((Predicate)object)) return false;
        return true;
    }

    public final synchronized void workerFinished(@NotNull WorkerProfilingRecord workerRecord) {
        GradleBuildProfileSpan.Builder workerSpan;
        Intrinsics.checkParameterIsNotNull((Object)workerRecord, (String)"workerRecord");
        GradleBuildProfileSpan.Builder builder = workerSpan = GradleBuildProfileSpan.newBuilder().setId(this.resourceManager.allocateRecordId()).setParentId(this.spanBuilder.getId());
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"workerSpan");
        workerRecord.fillSpanRecord(builder);
        boolean bl = false;
        this.resourceManager.writeRecord(this.projectPath, this.variant, workerSpan, CollectionsKt.emptyList());
    }

    public final synchronized void writeTaskSpan() {
        if (this.status.get() == Status.SPAN_CLOSED) {
            return;
        }
        this.status.set(Status.SPAN_CLOSED);
        this.spanBuilder.setStartTimeInMs(this.startTime.toEpochMilli());
        this.spanBuilder.setType(GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION);
        this.spanBuilder.setDurationInMs(this.duration().toMillis());
        this.resourceManager.writeRecord(this.projectPath, this.variant, this.spanBuilder, this.taskSpans);
    }

    @NotNull
    public final Duration minimumWaitTime() {
        Duration duration = (Duration)SequencesKt.min((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.workerRecordList.values()), (Function1)minimumWaitTime.1.INSTANCE));
        if (duration == null) {
            Duration duration2 = Duration.ZERO;
            duration = duration2;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ZERO");
        }
        return duration;
    }

    @NotNull
    public final Duration duration() {
        Duration duration = Duration.between(this.startTime, this.endTime);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.between(startTime, endTime)");
        return duration;
    }

    public final synchronized void addSpan(@NotNull GradleBuildProfileSpan.Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        builder.setParentId(this.spanBuilder.getId());
        GradleBuildProfileSpan gradleBuildProfileSpan = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleBuildProfileSpan, (String)"builder.build()");
        this.taskSpans.add(gradleBuildProfileSpan);
    }

    public final void setTaskStartTime(long startTime) {
        this.startTime = Instant.ofEpochMilli(startTime);
    }

    public final void setTaskEndTime(long endTime) {
        this.status.set(Status.FINISHED);
        this.endTime = Instant.ofEpochMilli(endTime);
    }

    @NotNull
    public final String getProjectPath$gradle_core() {
        return this.projectPath;
    }

    @Nullable
    public final String getVariant$gradle_core() {
        return this.variant;
    }

    public TaskProfilingRecord(@NotNull AnalyticsResourceManager resourceManager, @NotNull GradleBuildProfileSpan.Builder span, @NotNull String taskPath, @NotNull String projectPath, @Nullable String variant) {
        Intrinsics.checkParameterIsNotNull((Object)resourceManager, (String)"resourceManager");
        Intrinsics.checkParameterIsNotNull((Object)span, (String)"span");
        Intrinsics.checkParameterIsNotNull((Object)taskPath, (String)"taskPath");
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        this.resourceManager = resourceManager;
        this.taskPath = taskPath;
        this.projectPath = projectPath;
        this.variant = variant;
        this.spanBuilder = span;
        boolean bl = false;
        this.workerRecordList = new LinkedHashMap();
        this.startTime = Instant.MIN;
        this.endTime = Instant.MIN;
        this.status = new AtomicReference<Status>(Status.RUNNING);
        bl = false;
        this.taskSpans = new ArrayList();
    }

    static {
        Companion = new Companion(null);
        Clock clock = Clock.systemDefaultZone();
        Intrinsics.checkExpressionValueIsNotNull((Object)clock, (String)"Clock.systemDefaultZone()");
        TaskProfilingRecord.clock = clock;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/profile/TaskProfilingRecord$Status;", "", "(Ljava/lang/String;I)V", "RUNNING", "AWAIT", "FINISHED", "SPAN_CLOSED", "gradle-core"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status RUNNING;
        public static final /* enum */ Status AWAIT;
        public static final /* enum */ Status FINISHED;
        public static final /* enum */ Status SPAN_CLOSED;
        private static final /* synthetic */ Status[] $VALUES;

        static {
            Status[] statusArray = new Status[4];
            Status[] statusArray2 = statusArray;
            statusArray[0] = RUNNING = new Status();
            statusArray[1] = AWAIT = new Status();
            statusArray[2] = FINISHED = new Status();
            statusArray[3] = SPAN_CLOSED = new Status();
            $VALUES = statusArray;
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String string) {
            return Enum.valueOf(Status.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/profile/TaskProfilingRecord$Companion;", "", "()V", "clock", "Ljava/time/Clock;", "getClock$annotations", "getClock", "()Ljava/time/Clock;", "setClock", "(Ljava/time/Clock;)V", "gradle-core"})
    public static final class Companion {
        @VisibleForTesting
        public static /* synthetic */ void getClock$annotations() {
        }

        @NotNull
        public final Clock getClock() {
            return clock;
        }

        public final void setClock(@NotNull Clock clock) {
            Intrinsics.checkParameterIsNotNull((Object)clock, (String)"<set-?>");
            TaskProfilingRecord.clock = clock;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

