/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.component.TestComponent;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.UnitTestCreationConfig;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BootClasspathBuilder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.GenerateTestConfig;
import com.android.builder.core.LibraryRequest;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;

@CacheableTask
public abstract class AndroidUnitTest
extends Test
implements VariantAwareTask {
    private String variantName;
    private GenerateTestConfig.TestConfigInputs testConfigInputs;

    @Override
    @Internal
    public String getVariantName() {
        return this.variantName;
    }

    @Override
    public void setVariantName(String name2) {
        this.variantName = name2;
    }

    @Nested
    @Optional
    public GenerateTestConfig.TestConfigInputs getTestConfigInputs() {
        return this.testConfigInputs;
    }

    public static class CreationAction
    extends VariantTaskCreationAction<AndroidUnitTest, ComponentCreationConfig> {
        private final UnitTestCreationConfig unitTestCreationConfig;

        public CreationAction(UnitTestCreationConfig unitTestCreationConfig) {
            super(unitTestCreationConfig);
            this.unitTestCreationConfig = unitTestCreationConfig;
        }

        @Override
        public String getName() {
            return this.computeTaskName("test");
        }

        @Override
        public Class<AndroidUnitTest> getType() {
            return AndroidUnitTest.class;
        }

        @Override
        public void configure(AndroidUnitTest task) {
            super.configure(task);
            GlobalScope globalScope = this.creationConfig.getGlobalScope();
            BaseExtension extension = globalScope.getExtension();
            VariantImpl testedVariant = (VariantImpl)((TestComponent)this.creationConfig).getTestedVariant();
            boolean includeAndroidResources = extension.getTestOptions().getUnitTests().isIncludeAndroidResources();
            boolean useRelativePathInTestConfig = this.creationConfig.getServices().getProjectOptions().get(BooleanOption.USE_RELATIVE_PATH_IN_TEST_CONFIG);
            task.systemProperty("java.awt.headless", "true");
            task.setGroup("verification");
            task.setDescription("Run unit tests for the " + testedVariant.getName() + " build.");
            task.setTestClassesDirs(this.creationConfig.getArtifacts().getAllClasses());
            task.setClasspath((FileCollection)this.computeClasspath(this.creationConfig, includeAndroidResources));
            if (includeAndroidResources) {
                task.testConfigInputs = new GenerateTestConfig.TestConfigInputs(this.unitTestCreationConfig);
            }
            TestTaskReports testTaskReports = task.getReports();
            JUnitXmlReport xmlReport = testTaskReports.getJunitXml();
            xmlReport.setDestination(new File(globalScope.getTestResultsFolder(), task.getName()));
            DirectoryReport htmlReport = testTaskReports.getHtml();
            htmlReport.setDestination(new File(globalScope.getTestReportFolder(), task.getName()));
            extension.getTestOptions().getUnitTests().applyConfiguration(task);
            task.getOutputs().doNotCacheIf("AndroidUnitTest task is not yet cacheable when includeAndroidResources=true and android.testConfig.useRelativePath=false", (Spec & Serializable & Spec)thisTask -> includeAndroidResources && !useRelativePathInTestConfig);
        }

        private ConfigurableFileCollection computeClasspath(ComponentCreationConfig creationConfig, boolean includeAndroidResources) {
            GlobalScope globalScope = creationConfig.getGlobalScope();
            ArtifactsImpl artifacts2 = creationConfig.getArtifacts();
            ConfigurableFileCollection collection = creationConfig.getServices().fileCollection();
            if (includeAndroidResources) {
                collection.from(new Object[]{artifacts2.get(InternalArtifactType.UNIT_TEST_CONFIG_DIRECTORY.INSTANCE)});
            }
            collection.from(new Object[]{creationConfig.getAllProjectClassesPostAsmInstrumentation()});
            collection.from(new Object[]{artifacts2.get(InternalArtifactType.JAVA_RES.INSTANCE)});
            collection.from(new Object[]{creationConfig.getDependenciesClassesJarsPostAsmInstrumentation(AndroidArtifacts.ArtifactScope.ALL)});
            collection.from(new Object[]{creationConfig.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAVA_RES)});
            if (!globalScope.getExtension().getAaptOptions().getNamespaced()) {
                collection.from(new Object[]{creationConfig.getVariantScope().getRJarForUnitTests()});
            }
            collection.from(new Object[]{this.getAdditionalAndRequestedOptionalLibraries(creationConfig.getGlobalScope())});
            collection.from(new Object[]{creationConfig.getGlobalScope().getMockableJarArtifact()});
            return collection;
        }

        private ConfigurableFileCollection getAdditionalAndRequestedOptionalLibraries(GlobalScope globalScope) {
            return this.creationConfig.getServices().fileCollection(() -> BootClasspathBuilder.INSTANCE.computeAdditionalAndRequestedOptionalLibraries(globalScope.getProject(), (List)globalScope.getSdkComponents().flatMap(SdkComponentsBuildService::getAdditionalLibrariesProvider).get(), (List)globalScope.getSdkComponents().flatMap(SdkComponentsBuildService::getOptionalLibrariesProvider).get(), false, (List<LibraryRequest>)ImmutableList.copyOf(globalScope.getExtension().getLibraryRequests()), this.creationConfig.getServices().getIssueReporter()));
        }
    }
}

