/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.artifact.Artifact;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.VariantType;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010+\u001a\u00020\nH\u0002J\u0010\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020.H\u0002J\u000e\u0010/\u001a\u00020\n2\u0006\u0010-\u001a\u00020.J\u0014\u00100\u001a\u00020\n2\f\u00101\u001a\b\u0012\u0004\u0012\u00020302J\u0010\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020.H\u0002R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u0011\u0010\u0017\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\fR\u0011\u0010\u0019\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\fR\u0011\u0010\u001b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\fR\u0011\u0010\u001d\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\fR\u0011\u0010\u001f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\fR\u0011\u0010!\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\fR\u0011\u0010#\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\fR\u0011\u0010'\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\fR\u0011\u0010)\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/android/build/gradle/internal/variant/VariantPathHelper;", "", "project", "Lorg/gradle/api/Project;", "variantDslInfo", "Lcom/android/build/gradle/internal/core/VariantDslInfo;", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/internal/core/VariantDslInfo;Lcom/android/build/gradle/internal/services/DslServices;)V", "aarLocation", "Ljava/io/File;", "getAarLocation", "()Ljava/io/File;", "apkLocation", "getApkLocation", "buildConfigSourceOutputDir", "getBuildConfigSourceOutputDir", "coverageReportDir", "getCoverageReportDir", "defaultMergeResourcesOutputDir", "getDefaultMergeResourcesOutputDir", "generatedDir", "getGeneratedDir", "generatedPngsOutputDir", "getGeneratedPngsOutputDir", "generatedResOutputDir", "getGeneratedResOutputDir", "intermediatesDir", "getIntermediatesDir", "manifestOutputDirectory", "getManifestOutputDirectory", "microApkManifestFile", "getMicroApkManifestFile", "microApkResDirectory", "getMicroApkResDirectory", "outputDir", "getOutputDir", "renderscriptObjOutputDir", "getRenderscriptObjOutputDir", "renderscriptResOutputDir", "getRenderscriptResOutputDir", "reportsDir", "getReportsDir", "getDefaultApkLocation", "getGeneratedResourcesDir", "name", "", "getIncrementalDir", "getIntermediateDir", "taskOutput", "Lcom/android/build/api/artifact/Artifact;", "Lorg/gradle/api/file/Directory;", "intermediate", "directoryName", "gradle-core"})
public final class VariantPathHelper {
    private final Project project;
    private final VariantDslInfo variantDslInfo;
    private final DslServices dslServices;

    @NotNull
    public final File getIntermediatesDir() {
        return new File(this.project.getBuildDir(), "intermediates");
    }

    @NotNull
    public final File getOutputDir() {
        return new File(this.project.getBuildDir(), "outputs");
    }

    @NotNull
    public final File getGeneratedDir() {
        return new File(this.project.getBuildDir(), "generated");
    }

    @NotNull
    public final File getReportsDir() {
        return new File(this.project.getBuildDir(), "reports");
    }

    @NotNull
    public final File getGeneratedResOutputDir() {
        return this.getGeneratedResourcesDir("resValues");
    }

    @NotNull
    public final File getGeneratedPngsOutputDir() {
        return this.getGeneratedResourcesDir("pngs");
    }

    @NotNull
    public final File getRenderscriptResOutputDir() {
        return this.getGeneratedResourcesDir("rs");
    }

    @NotNull
    public final File getMicroApkResDirectory() {
        File file = FileUtils.join((File)this.getGeneratedDir(), (String[])new String[]{"res", "microapk", this.variantDslInfo.getDirName()});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(generated\u2026, variantDslInfo.dirName)");
        return file;
    }

    @NotNull
    public final File getMicroApkManifestFile() {
        File file = FileUtils.join((File)this.getGeneratedDir(), (String[])new String[]{"manifests", "microapk", this.variantDslInfo.getDirName(), "AndroidManifest.xml"});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(\n        \u2026ID_MANIFEST_XML\n        )");
        return file;
    }

    @NotNull
    public final File getDefaultMergeResourcesOutputDir() {
        File file = FileUtils.join((File)this.getIntermediatesDir(), (String[])new String[]{"res", "merged", this.variantDslInfo.getDirName()});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(\n        \u2026DslInfo.dirName\n        )");
        return file;
    }

    @NotNull
    public final File getBuildConfigSourceOutputDir() {
        File file = FileUtils.join((File)this.getGeneratedDir(), (String[])new String[]{"source", "buildConfig", this.variantDslInfo.getDirName()});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(generated\u2026, variantDslInfo.dirName)");
        return file;
    }

    @NotNull
    public final File getRenderscriptObjOutputDir() {
        File file = FileUtils.join((File)this.getIntermediatesDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"rs", this.variantDslInfo.getDirectorySegments(), "obj"}));
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(\n        \u2026\"\n            )\n        )");
        return file;
    }

    @NotNull
    public final File getCoverageReportDir() {
        File file = FileUtils.join((File)this.getReportsDir(), (String[])new String[]{"coverage", this.variantDslInfo.getDirName()});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(reportsDi\u2026, variantDslInfo.dirName)");
        return file;
    }

    @NotNull
    public final File getApkLocation() {
        String override = this.dslServices.getProjectOptions().get(StringOption.IDE_APK_LOCATION);
        File baseDirectory = override != null ? this.dslServices.file(override) : this.getDefaultApkLocation();
        return new File(baseDirectory, this.variantDslInfo.getDirName());
    }

    private final File getDefaultApkLocation() {
        File file = FileUtils.join((File)this.getOutputDir(), (String[])new String[]{"apk"});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(outputDir, \"apk\")");
        return file;
    }

    @NotNull
    public final File getAarLocation() {
        File file = FileUtils.join((File)this.getOutputDir(), (String[])new String[]{"aar"});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(outputDir\u2026onstants.EXT_LIB_ARCHIVE)");
        return file;
    }

    @NotNull
    public final File getManifestOutputDirectory() {
        VariantType variantType = this.variantDslInfo.getVariantType();
        if (variantType.isTestComponent()) {
            if (variantType.isApk()) {
                File file = FileUtils.join((File)this.getIntermediatesDir(), (String[])new String[]{"manifest", this.variantDslInfo.getDirName()});
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(\n        \u2026ame\n                    )");
                return file;
            }
        } else {
            File file = FileUtils.join((File)this.getIntermediatesDir(), (String[])new String[]{"manifests", "full", this.variantDslInfo.getDirName()});
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(\n        \u2026dirName\n                )");
            return file;
        }
        throw (Throwable)new RuntimeException("getManifestOutputDirectory called for an unexpected variant.");
    }

    @NotNull
    public final File getIncrementalDir(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        File file = FileUtils.join((File)this.getIntermediatesDir(), (String[])new String[]{"incremental", name2});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(intermedi\u2026Dir, \"incremental\", name)");
        return file;
    }

    @NotNull
    public final File getIntermediateDir(@NotNull Artifact<Directory> taskOutput) {
        Intrinsics.checkParameterIsNotNull(taskOutput, (String)"taskOutput");
        String string = taskOutput.name();
        Locale locale = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
        Locale locale2 = locale;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        return this.intermediate(string3);
    }

    private final File getGeneratedResourcesDir(String name2) {
        File file = FileUtils.join((File)this.getGeneratedDir(), (Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new String[]{"res", name2}), (Iterable)this.variantDslInfo.getDirectorySegments()));
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(\n        \u2026rectorySegments\n        )");
        return file;
    }

    private final File intermediate(String directoryName) {
        File file = FileUtils.join((File)this.getIntermediatesDir(), (String[])new String[]{directoryName, this.variantDslInfo.getDirName()});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(intermedi\u2026, variantDslInfo.dirName)");
        return file;
    }

    public VariantPathHelper(@NotNull Project project, @NotNull VariantDslInfo variantDslInfo, @NotNull DslServices dslServices) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)variantDslInfo, (String)"variantDslInfo");
        Intrinsics.checkParameterIsNotNull((Object)dslServices, (String)"dslServices");
        this.project = project;
        this.variantDslInfo = variantDslInfo;
        this.dslServices = dslServices;
    }
}

