/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.utp;

import com.android.build.gradle.internal.dsl.FailureRetention;
import com.android.build.gradle.internal.testing.utp.RetentionConfig;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.google.common.base.Preconditions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"createRetentionConfig", "Lcom/android/build/gradle/internal/testing/utp/RetentionConfig;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "failureRetention", "Lcom/android/build/gradle/internal/dsl/FailureRetention;", "gradle-core"})
public final class RetentionConfigKt {
    @NotNull
    public static final RetentionConfig createRetentionConfig(@NotNull ProjectOptions projectOptions, @NotNull FailureRetention failureRetention) {
        Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkParameterIsNotNull((Object)failureRetention, (String)"failureRetention");
        boolean enableFailureRetention = failureRetention.getEnable();
        boolean retainAll = failureRetention.getRetainAll();
        int maxSnapshots = failureRetention.getMaxSnapshots();
        Integer n = projectOptions.get(IntegerOption.TEST_FAILURE_RETENTION);
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            Integer failureRetentionValue = n2;
            boolean bl3 = false;
            if (Intrinsics.compare((int)failureRetentionValue, (int)0) > 0) {
                enableFailureRetention = true;
                retainAll = false;
                Integer n3 = failureRetentionValue;
                Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"failureRetentionValue");
                maxSnapshots = n3;
            } else {
                Integer n4 = failureRetentionValue;
                if (n4 != null && n4 == 0) {
                    enableFailureRetention = false;
                } else {
                    enableFailureRetention = true;
                    retainAll = true;
                }
            }
        }
        Preconditions.checkArgument((!enableFailureRetention || retainAll || maxSnapshots > 0 ? 1 : 0) != 0, (String)("android.testOptions.maxSnapshots should be >0, actual value " + failureRetention.getMaxSnapshots()), (Object[])new Object[0]);
        Boolean bl = projectOptions.get(OptionalBooleanOption.ENABLE_TEST_FAILURE_RETENTION_COMPRESS_SNAPSHOT);
        if (bl == null) {
            bl = failureRetention.getCompressSnapshots();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"projectOptions.get(\n    \u2026tention.compressSnapshots");
        boolean compressSnapshots = bl;
        return new RetentionConfig(enableFailureRetention, retainAll, compressSnapshots, maxSnapshots);
    }
}

