/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.api.variant.VariantOutputConfiguration;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.BuiltArtifactsSplitOutputMatcher;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/test/TestDataImpl;", "Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;", "testConfig", "Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;", "testApkDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "testedApksDir", "Lorg/gradle/api/file/FileCollection;", "(Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/file/FileCollection;)V", "libraryType", "", "getLibraryType", "()Lorg/gradle/api/provider/Provider;", "supportedAbis", "", "", "getSupportedAbis", "()Ljava/util/Set;", "findTestedApks", "", "Ljava/io/File;", "deviceConfigProvider", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "logger", "Lcom/android/utils/ILogger;", "gradle-core"})
public final class TestDataImpl
extends AbstractTestDataImpl {
    @NotNull
    private final Provider<Boolean> libraryType;
    @NotNull
    private final Set<String> supportedAbis;

    @Override
    @NotNull
    public Provider<Boolean> getLibraryType() {
        return this.libraryType;
    }

    @Input
    @NotNull
    public final Set<String> getSupportedAbis() {
        return this.supportedAbis;
    }

    @Override
    @NotNull
    public List<File> findTestedApks(@NotNull DeviceConfigProvider deviceConfigProvider, @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)deviceConfigProvider, (String)"deviceConfigProvider");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        if (this.getTestedApksDir() == null) {
            return CollectionsKt.emptyList();
        }
        ImmutableList.Builder apks = ImmutableList.builder();
        BuiltArtifactsImpl builtArtifactsImpl = new BuiltArtifactsLoaderImpl().load(this.getTestedApksDir());
        if (builtArtifactsImpl == null) {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
            return (List)immutableList;
        }
        BuiltArtifactsImpl builtArtifacts = builtArtifactsImpl;
        apks.addAll((Iterable)BuiltArtifactsSplitOutputMatcher.INSTANCE.computeBestOutput(deviceConfigProvider, builtArtifacts, (Collection<String>)this.supportedAbis));
        ImmutableList immutableList = apks.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"apks.build()");
        return (List)immutableList;
    }

    public TestDataImpl(@NotNull AndroidTestCreationConfig testConfig, @NotNull Provider<Directory> testApkDir, @Nullable FileCollection testedApksDir) {
        Intrinsics.checkParameterIsNotNull((Object)testConfig, (String)"testConfig");
        Intrinsics.checkParameterIsNotNull(testApkDir, (String)"testApkDir");
        super(testConfig, testConfig.getVariantSources(), testApkDir, testedApksDir);
        Collection collection = testConfig.getOutputs().getSplitsByType(VariantOutputConfiguration.OutputType.ONE_OF_MANY);
        boolean bl = false;
        if (!collection.isEmpty()) {
            throw (Throwable)new RuntimeException("Multi-output in test variant not yet supported");
        }
        this.libraryType = testConfig.getServices().provider((Function0)new Function0<Boolean>(testConfig){
            final /* synthetic */ AndroidTestCreationConfig $testConfig;

            public final boolean invoke() {
                return this.$testConfig.getTestedConfig().getVariantType().isAar();
            }
            {
                this.$testConfig = androidTestCreationConfig;
                super(0);
            }
        });
        this.supportedAbis = testConfig.getTestedConfig().getVariantDslInfo().getSupportedAbis();
    }
}

