/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.mlkit.codegen;

import com.android.build.gradle.internal.tasks.mlkit.codegen.ClassNames;
import com.android.tools.mlkit.MlNames;
import com.android.tools.mlkit.TensorInfo;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\t\u001a#\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\t\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0013\u001a\u0019\u0010\u0014\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0002\u0010\u0015\u001a\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u0017\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u0019\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u001a\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u001b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u001c"}, d2={"getArrayString", "", "type", "array", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getDataType", "Lcom/android/tools/mlkit/TensorInfo$DataType;", "getFloatArrayString", "", "getGroupClassParameterType", "Lcom/squareup/javapoet/TypeName;", "tensorInfo", "Lcom/android/tools/mlkit/TensorInfo;", "getIdentifierFromFileName", "name", "getImageHeightFieldName", "getImageWidthFieldName", "getIntArrayString", "", "getObjectArrayString", "([Ljava/lang/String;)Ljava/lang/String;", "getOutputParameterType", "getOutputParameterTypeName", "getParameterType", "getProcessedTypeName", "getProcessorBuilderName", "getProcessorName", "gradle-core"})
@JvmName(name="CodeUtils")
public final class CodeUtils {
    @NotNull
    public static final TypeName getParameterType(@NotNull TensorInfo tensorInfo) {
        Intrinsics.checkParameterIsNotNull((Object)tensorInfo, (String)"tensorInfo");
        return tensorInfo.isRGBImage() ? (TypeName)ClassNames.TENSOR_IMAGE : (TypeName)ClassNames.TENSOR_BUFFER;
    }

    @NotNull
    public static final TypeName getGroupClassParameterType(@NotNull TensorInfo tensorInfo) {
        TypeName typeName;
        Intrinsics.checkParameterIsNotNull((Object)tensorInfo, (String)"tensorInfo");
        if (tensorInfo.getFileType() == TensorInfo.FileType.TENSOR_VALUE_LABELS) {
            typeName = (TypeName)ClassNames.STRING;
        } else {
            TypeName typeName2 = tensorInfo.getContentType() == TensorInfo.ContentType.BOUNDING_BOX ? (TypeName)ClassNames.RECT_F : (tensorInfo.getDataType() == TensorInfo.DataType.FLOAT32 ? TypeName.FLOAT : (tensorInfo.getDataType() == TensorInfo.DataType.UINT8 ? TypeName.INT : (TypeName)ClassNames.TENSOR_BUFFER));
            typeName = typeName2;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeName2, (String)"if (tensorInfo.contentTy\u2026Names.TENSOR_BUFFER\n    }");
        }
        return typeName;
    }

    @NotNull
    public static final String getIdentifierFromFileName(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        CharSequence charSequence = name2;
        String string = "\\..*";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "";
        boolean bl2 = false;
        String string3 = MlNames.computeIdentifierName(string.replace(charSequence, string2));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"MlNames.computeIdentifie\u2026e(\"\\\\..*\".toRegex(), \"\"))");
        return string3;
    }

    @NotNull
    public static final String getProcessorName(@NotNull TensorInfo tensorInfo) {
        Intrinsics.checkParameterIsNotNull((Object)tensorInfo, (String)"tensorInfo");
        return tensorInfo.getSource() == TensorInfo.Source.INPUT ? tensorInfo.getIdentifierName() + "Processor" : tensorInfo.getIdentifierName() + "PostProcessor";
    }

    @NotNull
    public static final String getProcessedTypeName(@NotNull TensorInfo tensorInfo) {
        Intrinsics.checkParameterIsNotNull((Object)tensorInfo, (String)"tensorInfo");
        return "processed" + tensorInfo.getIdentifierName();
    }

    @NotNull
    public static final String getProcessorBuilderName(@NotNull TensorInfo tensorInfo) {
        Intrinsics.checkParameterIsNotNull((Object)tensorInfo, (String)"tensorInfo");
        return CodeUtils.getProcessorName(tensorInfo) + "Builder";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getFloatArrayString(@NotNull float[] array) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        float[] fArray = array;
        String string = "float";
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var6_7 = $this$mapTo$iv$iv;
        int n = ((void)var6_7).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = var6_7[j];
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = String.valueOf((float)it) + "f";
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return CodeUtils.getArrayString(string, stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getIntArrayString(@NotNull int[] array) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        int[] nArray = array;
        String string = "int";
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var6_7 = $this$mapTo$iv$iv;
        int n = ((void)var6_7).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = var6_7[j];
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = String.valueOf((int)it);
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return CodeUtils.getArrayString(string, stringArray);
    }

    @NotNull
    public static final String getObjectArrayString(@NotNull String[] array) {
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        return CodeUtils.getArrayString("Object", array);
    }

    private static final String getArrayString(String type, String[] array) {
        StringBuilder builder = new StringBuilder();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "new %s[] {";
        Object[] objectArray = new Object[]{type};
        int n = 0;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        builder.append(string2);
        for (String dim : array) {
            builder.append(dim).append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("}");
        String string3 = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"builder.toString()");
        return string3;
    }

    @NotNull
    public static final String getDataType(@NotNull TensorInfo.DataType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        return type.toString();
    }

    @NotNull
    public static final TypeName getOutputParameterType(@NotNull TensorInfo tensorInfo) {
        Intrinsics.checkParameterIsNotNull((Object)tensorInfo, (String)"tensorInfo");
        return tensorInfo.isRGBImage() ? (TypeName)ClassNames.TENSOR_IMAGE : (tensorInfo.getFileType() == TensorInfo.FileType.TENSOR_AXIS_LABELS ? ClassNames.CATEGORY_LIST : (tensorInfo.getFileType() == TensorInfo.FileType.TENSOR_VALUE_LABELS ? ClassNames.STRING_LIST : (tensorInfo.getContentType() == TensorInfo.ContentType.BOUNDING_BOX ? ClassNames.RECTF_LIST : (TypeName)ClassNames.TENSOR_BUFFER)));
    }

    @NotNull
    public static final String getOutputParameterTypeName(@NotNull TensorInfo tensorInfo) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)tensorInfo, (String)"tensorInfo");
        if (tensorInfo.isRGBImage()) {
            String string2 = ClassNames.TENSOR_IMAGE.simpleName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ClassNames.TENSOR_IMAGE.simpleName()");
        } else if (tensorInfo.getFileType() == TensorInfo.FileType.TENSOR_AXIS_LABELS) {
            string = "CategoryList";
        } else if (tensorInfo.getFileType() == TensorInfo.FileType.TENSOR_VALUE_LABELS) {
            string = "StringList";
        } else if (tensorInfo.getContentType() == TensorInfo.ContentType.BOUNDING_BOX) {
            string = "RectFList";
        } else {
            String string3 = ClassNames.TENSOR_BUFFER.simpleName();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ClassNames.TENSOR_BUFFER.simpleName()");
        }
        return string;
    }

    @NotNull
    public static final String getImageHeightFieldName(@NotNull TensorInfo tensorInfo) {
        Intrinsics.checkParameterIsNotNull((Object)tensorInfo, (String)"tensorInfo");
        return tensorInfo.getIdentifierName() + "Height";
    }

    @NotNull
    public static final String getImageWidthFieldName(@NotNull TensorInfo tensorInfo) {
        Intrinsics.checkParameterIsNotNull((Object)tensorInfo, (String)"tensorInfo");
        return tensorInfo.getIdentifierName() + "Width";
    }
}

