/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.cxx.gradle.generator.CxxConfigurationModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0006"}, d2={"getExternalNativeLibs", "Lorg/gradle/api/file/FileCollection;", "creationConfig", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "getProjectNativeLibs", "getSubProjectNativeLibs", "gradle-core"})
public final class MergeNativeLibsTaskKt {
    @NotNull
    public static final FileCollection getProjectNativeLibs(@NotNull VariantCreationConfig creationConfig) {
        Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
        ArtifactsImpl artifacts2 = creationConfig.getArtifacts();
        MutableTaskContainer taskContainer = creationConfig.getTaskContainer();
        ConfigurableFileCollection nativeLibs = creationConfig.getServices().fileCollection();
        nativeLibs.from(new Object[]{artifacts2.get(InternalArtifactType.MERGED_JNI_LIBS.INSTANCE)});
        Object buildServiceRegistry$iv = creationConfig.getServices().getBuildServiceRegistry();
        boolean $i$f$getBuildService = false;
        Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(SdkComponentsBuildService.class));
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT, *>");
        }
        Provider provider2 = ((BuildServiceRegistration)object).getService();
        Intrinsics.checkExpressionValueIsNotNull((Object)provider2, (String)"(buildServiceRegistry.re\u2026erviceT, *>).getService()");
        SdkComponentsBuildService sdkComponents = (SdkComponentsBuildService)provider2.get();
        Object object2 = taskContainer.getCxxConfigurationModel();
        if (object2 != null && (object2 = ((CxxConfigurationModel)object2).getVariant()) != null && (object2 = ((CxxVariantModel)object2).getObjFolder()) != null) {
            buildServiceRegistry$iv = object2;
            $i$f$getBuildService = false;
            boolean bl = false;
            Object objFolder = buildServiceRegistry$iv;
            boolean bl2 = false;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = new Object[1];
            TaskProvider<? extends ExternalNativeBuildTask> taskProvider = taskContainer.getExternalNativeBuildTask();
            objectArray2[0] = taskProvider != null ? taskProvider.getName() : null;
            objectArray[0] = creationConfig.getServices().fileCollection(objFolder).builtBy(objectArray2);
            nativeLibs.from(objectArray);
        }
        if (creationConfig.getVariantDslInfo().getRenderscriptSupportModeEnabled()) {
            File rsLibs;
            ConfigurableFileCollection rsFileCollection = creationConfig.getServices().fileCollection(artifacts2.get(InternalArtifactType.RENDERSCRIPT_LIB.INSTANCE));
            File file = rsLibs = (File)sdkComponents.getSupportNativeLibFolderProvider().getOrNull();
            if ((file != null ? Boolean.valueOf(file.isDirectory()) : null) != null) {
                rsFileCollection.from(new Object[]{rsLibs});
            }
            if (creationConfig.getVariantDslInfo().getRenderscriptSupportModeBlasEnabled()) {
                File rsBlasLib = (File)sdkComponents.getSupportBlasLibFolderProvider().getOrNull();
                if (rsBlasLib == null || !rsBlasLib.isDirectory()) {
                    throw (Throwable)new GradleException("Renderscript BLAS support mode is not supported in BuildTools " + rsBlasLib);
                }
                rsFileCollection.from(new Object[]{rsBlasLib});
            }
            nativeLibs.from(new Object[]{rsFileCollection});
        }
        return (FileCollection)nativeLibs;
    }

    @NotNull
    public static final FileCollection getSubProjectNativeLibs(@NotNull VariantCreationConfig creationConfig) {
        Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
        ConfigurableFileCollection nativeLibs = creationConfig.getServices().fileCollection();
        nativeLibs.from(new Object[]{VariantDependencies.getArtifactFileCollection$default(creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.JAVA_RES, null, 8, null)});
        nativeLibs.from(new Object[]{VariantDependencies.getArtifactFileCollection$default(creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.JNI, null, 8, null)});
        return (FileCollection)nativeLibs;
    }

    @NotNull
    public static final FileCollection getExternalNativeLibs(@NotNull VariantCreationConfig creationConfig) {
        Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
        ConfigurableFileCollection nativeLibs = creationConfig.getServices().fileCollection();
        nativeLibs.from(new Object[]{VariantDependencies.getArtifactFileCollection$default(creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.JAVA_RES, null, 8, null)});
        nativeLibs.from(new Object[]{VariantDependencies.getArtifactFileCollection$default(creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.JNI, null, 8, null)});
        return (FileCollection)nativeLibs;
    }
}

