/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataRunnable$sam$java_util_function_Function$0;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataTask;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.gradle.api.Action;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J6\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataRunnable$Params;", "()V", "execOperations", "Lorg/gradle/process/ExecOperations;", "getExecOperations", "()Lorg/gradle/process/ExecOperations;", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getLogger", "()Lcom/android/build/gradle/internal/LoggerWrapper;", "processSingle", "", "inputFile", "Ljava/io/File;", "outputFile", "objcopyExecutable", "objcopyArgs", "", "", "processExecutor", "Lcom/android/build/gradle/internal/process/GradleProcessExecutor;", "run", "Params", "SingleRequest", "gradle-core"})
public abstract class ExtractNativeDebugMetadataRunnable
extends ProfileAwareWorkAction<Params> {
    private final LoggerWrapper getLogger() {
        return new LoggerWrapper(Logging.getLogger(ExtractNativeDebugMetadataTask.class));
    }

    @Inject
    @NotNull
    public abstract ExecOperations getExecOperations();

    @Override
    public void run() {
        Function1 function1 = (Function1)new Function1<Action<? super ExecSpec>, ExecResult>(this.getExecOperations()){

            public final ExecResult invoke(Action<? super ExecSpec> p1) {
                return ((ExecOperations)this.receiver).exec(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ExecOperations.class);
            }

            public final String getName() {
                return "exec";
            }

            public final String getSignature() {
                return "exec(Lorg/gradle/api/Action;)Lorg/gradle/process/ExecResult;";
            }
        };
        GradleProcessExecutor processExecutor2 = new GradleProcessExecutor(new ExtractNativeDebugMetadataRunnable$sam$java_util_function_Function$0(function1));
        Object object = ((Params)this.getParameters()).getRequests().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.requests.get()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleRequest it = (SingleRequest)element$iv;
            boolean bl = false;
            this.processSingle(it.getInputFile(), it.getOutputFile(), it.getObjcopyExecutable(), it.getObjcopyArgs(), processExecutor2);
        }
    }

    private final void processSingle(File inputFile, File outputFile, File objcopyExecutable, List<String> objcopyArgs, GradleProcessExecutor processExecutor2) {
        FileUtils.mkdirs((File)outputFile.getParentFile());
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(objcopyExecutable);
        builder.addArgs(objcopyArgs);
        builder.addArgs(inputFile.toString(), outputFile.toString());
        ProcessResult processResult = processExecutor2.execute(builder.createProcess(), (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)new LoggerWrapper(Logging.getLogger(ExtractNativeDebugMetadataTask.class))));
        Intrinsics.checkExpressionValueIsNotNull((Object)processResult, (String)"processExecutor.execute(\u2026          )\n            )");
        ProcessResult result2 = processResult;
        if (result2.getExitValue() != 0) {
            this.getLogger().warning("Unable to extract native debug metadata from " + inputFile.getAbsolutePath() + ' ' + "because of non-zero exit value from objcopy.", new Object[0]);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J7\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataRunnable$SingleRequest;", "Ljava/io/Serializable;", "inputFile", "Ljava/io/File;", "outputFile", "objcopyExecutable", "objcopyArgs", "", "", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/util/List;)V", "getInputFile", "()Ljava/io/File;", "getObjcopyArgs", "()Ljava/util/List;", "getObjcopyExecutable", "getOutputFile", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle-core"})
    public static final class SingleRequest
    implements Serializable {
        @NotNull
        private final File inputFile;
        @NotNull
        private final File outputFile;
        @NotNull
        private final File objcopyExecutable;
        @NotNull
        private final List<String> objcopyArgs;

        @NotNull
        public final File getInputFile() {
            return this.inputFile;
        }

        @NotNull
        public final File getOutputFile() {
            return this.outputFile;
        }

        @NotNull
        public final File getObjcopyExecutable() {
            return this.objcopyExecutable;
        }

        @NotNull
        public final List<String> getObjcopyArgs() {
            return this.objcopyArgs;
        }

        public SingleRequest(@NotNull File inputFile, @NotNull File outputFile, @NotNull File objcopyExecutable, @NotNull List<String> objcopyArgs) {
            Intrinsics.checkParameterIsNotNull((Object)inputFile, (String)"inputFile");
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            Intrinsics.checkParameterIsNotNull((Object)objcopyExecutable, (String)"objcopyExecutable");
            Intrinsics.checkParameterIsNotNull(objcopyArgs, (String)"objcopyArgs");
            this.inputFile = inputFile;
            this.outputFile = outputFile;
            this.objcopyExecutable = objcopyExecutable;
            this.objcopyArgs = objcopyArgs;
        }

        @NotNull
        public final File component1() {
            return this.inputFile;
        }

        @NotNull
        public final File component2() {
            return this.outputFile;
        }

        @NotNull
        public final File component3() {
            return this.objcopyExecutable;
        }

        @NotNull
        public final List<String> component4() {
            return this.objcopyArgs;
        }

        @NotNull
        public final SingleRequest copy(@NotNull File inputFile, @NotNull File outputFile, @NotNull File objcopyExecutable, @NotNull List<String> objcopyArgs) {
            Intrinsics.checkParameterIsNotNull((Object)inputFile, (String)"inputFile");
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            Intrinsics.checkParameterIsNotNull((Object)objcopyExecutable, (String)"objcopyExecutable");
            Intrinsics.checkParameterIsNotNull(objcopyArgs, (String)"objcopyArgs");
            return new SingleRequest(inputFile, outputFile, objcopyExecutable, objcopyArgs);
        }

        public static /* synthetic */ SingleRequest copy$default(SingleRequest singleRequest, File file, File file2, File file3, List list, int n, Object object) {
            if ((n & 1) != 0) {
                file = singleRequest.inputFile;
            }
            if ((n & 2) != 0) {
                file2 = singleRequest.outputFile;
            }
            if ((n & 4) != 0) {
                file3 = singleRequest.objcopyExecutable;
            }
            if ((n & 8) != 0) {
                list = singleRequest.objcopyArgs;
            }
            return singleRequest.copy(file, file2, file3, list);
        }

        @NotNull
        public String toString() {
            return "SingleRequest(inputFile=" + this.inputFile + ", outputFile=" + this.outputFile + ", objcopyExecutable=" + this.objcopyExecutable + ", objcopyArgs=" + this.objcopyArgs + ")";
        }

        public int hashCode() {
            File file = this.inputFile;
            File file2 = this.outputFile;
            File file3 = this.objcopyExecutable;
            List<String> list = this.objcopyArgs;
            return (((file != null ? ((Object)file).hashCode() : 0) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SingleRequest)) break block3;
                    SingleRequest singleRequest = (SingleRequest)object;
                    if (!Intrinsics.areEqual((Object)this.inputFile, (Object)singleRequest.inputFile) || !Intrinsics.areEqual((Object)this.outputFile, (Object)singleRequest.outputFile) || !Intrinsics.areEqual((Object)this.objcopyExecutable, (Object)singleRequest.objcopyExecutable) || !Intrinsics.areEqual(this.objcopyArgs, singleRequest.objcopyArgs)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataRunnable$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "requests", "Lorg/gradle/api/provider/ListProperty;", "Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataRunnable$SingleRequest;", "getRequests", "()Lorg/gradle/api/provider/ListProperty;", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract ListProperty<SingleRequest> getRequests();
    }
}

