/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res;

import com.android.SdkConstants;
import com.android.Version;
import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.res.Aapt2FromMaven;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/res/Aapt2FromMaven;", "", "aapt2Directory", "Lorg/gradle/api/file/FileCollection;", "version", "", "(Lorg/gradle/api/file/FileCollection;Ljava/lang/String;)V", "getAapt2Directory", "()Lorg/gradle/api/file/FileCollection;", "getVersion", "()Ljava/lang/String;", "Companion", "gradle-core"})
public final class Aapt2FromMaven {
    @NotNull
    private final FileCollection aapt2Directory;
    @NotNull
    private final String version;
    private static final String TYPE_EXTRACTED_AAPT2_BINARY = "_internal-android-aapt2-binary";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final FileCollection getAapt2Directory() {
        return this.aapt2Directory;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public Aapt2FromMaven(@NotNull FileCollection aapt2Directory2, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)aapt2Directory2, (String)"aapt2Directory");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        this.aapt2Directory = aapt2Directory2;
        this.version = version;
    }

    @JvmStatic
    @NotNull
    public static final Aapt2FromMaven create(@NotNull Project project, @NotNull ProjectOptions projectOptions) {
        return Companion.create(project, projectOptions);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/res/Aapt2FromMaven$Companion;", "", "()V", "TYPE_EXTRACTED_AAPT2_BINARY", "", "create", "Lcom/android/build/gradle/internal/res/Aapt2FromMaven;", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "Aapt2Extractor", "Aapt2Version", "gradle-core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Aapt2FromMaven create(@NotNull Project project, @NotNull ProjectOptions projectOptions) {
            FileCollection aapt2Directory2;
            String string;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
            String customAapt2 = projectOptions.get(StringOption.AAPT2_FROM_MAVEN_OVERRIDE);
            CharSequence charSequence = customAapt2;
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                String string2 = SdkConstants.FN_AAPT2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SdkConstants.FN_AAPT2");
                if (!StringsKt.endsWith$default((String)customAapt2, (String)string2, (boolean)false, (int)2, null)) {
                    charSequence = "Custom AAPT2 location does not point to an AAPT2 executable: " + customAapt2;
                    bl = false;
                    throw (Throwable)new IllegalStateException(((Object)charSequence).toString());
                }
                ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{new File(customAapt2).getParentFile()});
                Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"project.files(File(customAapt2).parentFile)");
                return new Aapt2FromMaven((FileCollection)configurableFileCollection, customAapt2);
            }
            String version = Version.ANDROID_GRADLE_PLUGIN_VERSION + '-' + Aapt2Version.INSTANCE.getBUILD_NUMBER();
            switch (SdkConstants.currentPlatform()) {
                case 2: {
                    string = "windows";
                    break;
                }
                case 3: {
                    string = "osx";
                    break;
                }
                case 1: {
                    string = "linux";
                    break;
                }
                default: {
                    String string3 = "Unknown platform '" + System.getProperty("os.name") + '\'';
                    boolean bl3 = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
            }
            String classifier = string;
            Configuration configuration2 = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().module((Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"group", (Object)"com.android.tools.build"), TuplesKt.to((Object)"name", (Object)"aapt2"), TuplesKt.to((Object)"version", (Object)version), TuplesKt.to((Object)"classifier", (Object)classifier)}))});
            project.getDependencies().registerTransform(Aapt2Extractor.class, (Action)new Action<TransformSpec<GenericTransformParameters>>(project){
                final /* synthetic */ Project $project;

                public final void execute(TransformSpec<GenericTransformParameters> it) {
                    TransformSpec<GenericTransformParameters> transformSpec = it;
                    Intrinsics.checkExpressionValueIsNotNull(transformSpec, (String)"it");
                    ((GenericTransformParameters)transformSpec.getParameters()).getProjectName().set((Object)this.$project.getName());
                    it.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"jar");
                    it.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-android-aapt2-binary");
                }
                {
                    this.$project = project;
                }
            });
            Configuration configuration3 = configuration2;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"configuration");
            ArtifactView artifactView = configuration3.getIncoming().artifactView((Action)create.aapt2Directory.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"configuration.incoming.a\u2026          }\n            }");
            ArtifactCollection artifactCollection = artifactView.getArtifacts();
            Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"configuration.incoming.a\u2026}\n            }.artifacts");
            FileCollection fileCollection2 = aapt2Directory2 = artifactCollection.getArtifactFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"aapt2Directory");
            return new Aapt2FromMaven(fileCollection2, version);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/res/Aapt2FromMaven$Companion$Aapt2Version;", "", "()V", "BUILD_NUMBER", "", "getBUILD_NUMBER", "()Ljava/lang/String;", "BUILD_NUMBER$delegate", "Lkotlin/Lazy;", "gradle-core"})
        private static final class Aapt2Version {
            @NotNull
            private static final Lazy BUILD_NUMBER$delegate;
            public static final Aapt2Version INSTANCE;

            @NotNull
            public final String getBUILD_NUMBER() {
                Lazy lazy = BUILD_NUMBER$delegate;
                Aapt2Version aapt2Version = this;
                Object var3_3 = null;
                boolean bl = false;
                return (String)lazy.getValue();
            }

            private Aapt2Version() {
            }

            static {
                Aapt2Version aapt2Version;
                INSTANCE = aapt2Version = new Aapt2Version();
                BUILD_NUMBER$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)BUILD_NUMBER.2.INSTANCE);
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/res/Aapt2FromMaven$Companion$Aapt2Extractor;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "transform", "", "transformOutputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "gradle-core"})
        public static abstract class Aapt2Extractor
        implements TransformAction<GenericTransformParameters> {
            @Classpath
            @InputArtifact
            @NotNull
            public abstract Provider<FileSystemLocation> getInputArtifact();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transform(@NotNull TransformOutputs transformOutputs) {
                File input;
                Intrinsics.checkParameterIsNotNull((Object)transformOutputs, (String)"transformOutputs");
                Object object = this.getInputArtifact().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"inputArtifact.get()");
                File file = input = ((FileSystemLocation)object).getAsFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"input");
                Path outDir = transformOutputs.dir((Object)FilesKt.getNameWithoutExtension((File)file)).toPath();
                Files.createDirectories(outDir, new FileAttribute[0]);
                Object object2 = input;
                int n = 0;
                object2 = new FileInputStream((File)object2);
                n = 8192;
                boolean bl = false;
                object2 = new ZipInputStream(object2 instanceof BufferedInputStream ? (BufferedInputStream)object2 : new BufferedInputStream((InputStream)object2, n));
                n = 0;
                Throwable throwable = null;
                try {
                    ZipInputStream zipInputStream = (ZipInputStream)object2;
                    boolean bl2 = false;
                    while (zipInputStream.getNextEntry() != null) {
                        Path destinationFile;
                        ZipEntry entry;
                        if (entry.isDirectory()) continue;
                        Path path = destinationFile = outDir.resolve(entry.getName());
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"destinationFile");
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                        OutputStream outputStream = Files.newOutputStream(destinationFile, new OpenOption[0]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"Files.newOutputStream(destinationFile)");
                        Closeable closeable = outputStream;
                        int n2 = 8192;
                        boolean bl3 = false;
                        closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n2);
                        n2 = 0;
                        Throwable throwable2 = null;
                        try {
                            BufferedOutputStream output2 = (BufferedOutputStream)closeable;
                            boolean bl4 = false;
                            long l = ByteStreams.copy((InputStream)zipInputStream, (OutputStream)output2);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        }
                        if (!Intrinsics.areEqual((Object)entry.getName(), (Object)SdkConstants.FN_AAPT2) || SdkConstants.CURRENT_PLATFORM != 1 && SdkConstants.CURRENT_PLATFORM != 3) continue;
                        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(destinationFile, new LinkOption[0]);
                        Files.setPosixFilePermissions(destinationFile, (Set)Sets.union(permissions, (Set)SetsKt.setOf((Object)((Object)PosixFilePermission.OWNER_EXECUTE))));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
            }
        }
    }
}

