/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.instrumentation;

import com.android.build.gradle.internal.instrumentation.ClassesDataSourceCache;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\rH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/instrumentation/ClassesDataCache;", "Ljava/io/Closeable;", "()V", "sourcesCacheMap", "", "", "Lcom/android/build/gradle/internal/instrumentation/ClassesDataSourceCache;", "close", "", "getSourceCaches", "", "sources", "", "Ljava/io/File;", "getSourceFileKey", "file", "DirCache", "JarCache", "gradle-core"})
public final class ClassesDataCache
implements Closeable {
    private final Map<Object, ClassesDataSourceCache> sourcesCacheMap;

    private final Object getSourceFileKey(File file) {
        Object object = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]).fileKey();
        if (object == null) {
            String string = file.getCanonicalPath();
            object = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.canonicalPath");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<ClassesDataSourceCache> getSourceCaches(@NotNull Set<? extends File> sources) {
        void $this$associateByTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        Iterable $this$filter$iv = sources;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File p1 = (File)element$iv$iv;
            boolean bl = false;
            if (!p1.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            File bl = (File)element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl2 = false;
            Object object = this.getSourceFileKey((File)it);
            map2.put(object, element$iv$iv);
        }
        Map requested = destination$iv$iv2;
        ClassesDataCache classesDataCache = this;
        boolean bl = false;
        boolean bl3 = false;
        synchronized (classesDataCache) {
            void $this$mapTo$iv$iv;
            Object element$iv$iv;
            boolean bl4 = false;
            Map $this$map$iv = requested;
            boolean $i$f$map = false;
            element$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var12_19 = $this$mapTo$iv$iv;
            boolean bl5 = false;
            Iterator iterator = var12_19.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                void $dstr$key$sourceFile;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv3;
                boolean bl6 = false;
                void var19_29 = $dstr$key$sourceFile;
                boolean bl7 = false;
                Object k = var19_29.getKey();
                var19_29 = $dstr$key$sourceFile;
                bl7 = false;
                File sourceFile = (File)var19_29.getValue();
                ClassesDataSourceCache classesDataSourceCache = this.sourcesCacheMap.computeIfAbsent(key, new Function<Object, ClassesDataSourceCache>(sourceFile){
                    final /* synthetic */ File $sourceFile;

                    @NotNull
                    public final ClassesDataSourceCache apply(@NotNull Object it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        String string = this.$sourceFile.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.name");
                        return StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null) ? (ClassesDataSourceCache)new JarCache(this.$sourceFile) : (ClassesDataSourceCache)new DirCache(this.$sourceFile);
                    }
                    {
                        this.$sourceFile = file;
                    }
                });
                collection.add(classesDataSourceCache);
            }
            List list = (List)destination$iv$iv3;
            return list;
        }
    }

    @Override
    public void close() {
        Iterable $this$forEach$iv = this.sourcesCacheMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassesDataSourceCache p1 = (ClassesDataSourceCache)element$iv;
            boolean bl = false;
            p1.close();
        }
        this.sourcesCacheMap.clear();
    }

    public ClassesDataCache() {
        boolean bl = false;
        this.sourcesCacheMap = new LinkedHashMap();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/instrumentation/ClassesDataCache$JarCache;", "Lcom/android/build/gradle/internal/instrumentation/ClassesDataSourceCache;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "jarFile", "Ljava/util/jar/JarFile;", "close", "", "maybeLoadClassData", "Lcom/android/build/gradle/internal/instrumentation/ClassesDataSourceCache$ClassData;", "className", "", "gradle-core"})
    private static final class JarCache
    extends ClassesDataSourceCache {
        private final JarFile jarFile;

        @Override
        public void close() {
            super.close();
            this.jarFile.close();
        }

        @Override
        @Nullable
        public synchronized ClassesDataSourceCache.ClassData maybeLoadClassData(@NotNull String className) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            String classFileName = className + ".class";
            ZipEntry zipEntry = this.jarFile.getEntry(classFileName);
            if (zipEntry != null) {
                ZipEntry zipEntry2 = zipEntry;
                boolean bl = false;
                boolean bl2 = false;
                ZipEntry entry = zipEntry2;
                boolean bl3 = false;
                InputStream inputStream = this.jarFile.getInputStream(entry);
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"jarFile.getInputStream(entry)");
                InputStream inputStream2 = inputStream;
                int n = 8192;
                boolean bl4 = false;
                return this.loadClassData(className, inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n));
            }
            return null;
        }

        public JarCache(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            this.jarFile = new JarFile(file);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/instrumentation/ClassesDataCache$DirCache;", "Lcom/android/build/gradle/internal/instrumentation/ClassesDataSourceCache;", "dir", "Ljava/io/File;", "(Ljava/io/File;)V", "maybeLoadClassData", "Lcom/android/build/gradle/internal/instrumentation/ClassesDataSourceCache$ClassData;", "className", "", "gradle-core"})
    private static final class DirCache
    extends ClassesDataSourceCache {
        private final File dir;

        @Override
        @Nullable
        public synchronized ClassesDataSourceCache.ClassData maybeLoadClassData(@NotNull String className) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            String classFileName = className + ".class";
            File classFile = FilesKt.resolve((File)this.dir, (String)classFileName);
            if (classFile.exists()) {
                Object object = classFile;
                int n = 0;
                object = new FileInputStream((File)object);
                n = 8192;
                boolean bl = false;
                return this.loadClassData(className, object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n));
            }
            return null;
        }

        public DirCache(@NotNull File dir) {
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            this.dir = dir;
        }
    }
}

