/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.cxx.configure.CmakeLocatorKt;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.repository.Revision;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\b\u0010\u0012\u001a\u00020\fH\u0002J\u0015\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\fJ\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/CmakeVersionRequirements;", "", "cmakeVersionFromDsl", "", "(Ljava/lang/String;)V", "getCmakeVersionFromDsl", "()Ljava/lang/String;", "downloadVersion", "getDownloadVersion", "dslVersionHasPlus", "", "effectiveRequestVersion", "Lcom/android/repository/Revision;", "getEffectiveRequestVersion", "()Lcom/android/repository/Revision;", "humanReadableVersionLanguage", "getHumanReadableVersionLanguage", "component1", "computeEffectiveRequestVersion", "copy", "equals", "other", "hashCode", "", "isSatisfiedBy", "version", "toString", "gradle-core"})
public final class CmakeVersionRequirements {
    private final boolean dslVersionHasPlus;
    @NotNull
    private final Revision effectiveRequestVersion;
    @NotNull
    private final String humanReadableVersionLanguage;
    @Nullable
    private final String downloadVersion;
    @Nullable
    private final String cmakeVersionFromDsl;

    @NotNull
    public final Revision getEffectiveRequestVersion() {
        return this.effectiveRequestVersion;
    }

    @NotNull
    public final String getHumanReadableVersionLanguage() {
        return this.humanReadableVersionLanguage;
    }

    public final boolean isSatisfiedBy(@NotNull Revision version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return this.dslVersionHasPlus ? version.compareTo(this.effectiveRequestVersion, Revision.PreviewComparison.IGNORE) >= 0 : version.compareTo(this.effectiveRequestVersion, Revision.PreviewComparison.IGNORE) == 0;
    }

    @Nullable
    public final String getDownloadVersion() {
        return this.downloadVersion;
    }

    private final Revision computeEffectiveRequestVersion() {
        Revision revision;
        String withoutPlus;
        String string = this.cmakeVersionFromDsl;
        String string2 = withoutPlus = string != null ? StringsKt.trimEnd((String)string, (char[])new char[]{'+'}) : null;
        if (withoutPlus == null) {
            Revision revision2 = CmakeLocatorKt.getDefaultCmakeVersion();
            revision = revision2;
            Intrinsics.checkExpressionValueIsNotNull((Object)revision2, (String)"defaultCmakeVersion");
        } else {
            Revision revision3;
            try {
                Revision revision4;
                Revision result2 = Revision.parseRevision((String)withoutPlus);
                Revision revision5 = result2;
                Intrinsics.checkExpressionValueIsNotNull((Object)revision5, (String)"result");
                if (revision5.getMajor() < 3 || result2.getMajor() == 3 && result2.getMinor() < 6) {
                    LoggingEnvironmentKt.errorln("CMake version '" + result2 + "' is too low. Use 3.7.0 or higher.", new Object[0]);
                    revision4 = CmakeLocatorKt.getDefaultCmakeVersion();
                } else if (result2.toIntArray(true).length < 3) {
                    LoggingEnvironmentKt.errorln("CMake version '" + result2 + "' does not have enough precision. Use major.minor.micro in version.", new Object[0]);
                    revision4 = CmakeLocatorKt.getDefaultCmakeVersion();
                } else {
                    revision4 = revision3;
                }
                revision3 = revision4;
            }
            catch (NumberFormatException e) {
                LoggingEnvironmentKt.errorln("CMake version '" + this.cmakeVersionFromDsl + "' is not formatted correctly.", new Object[0]);
                revision3 = CmakeLocatorKt.getDefaultCmakeVersion();
            }
            Revision revision6 = revision3;
            revision = revision6;
            Intrinsics.checkExpressionValueIsNotNull((Object)revision6, (String)"try {\n                va\u2026makeVersion\n            }");
        }
        return revision;
    }

    @Nullable
    public final String getCmakeVersionFromDsl() {
        return this.cmakeVersionFromDsl;
    }

    public CmakeVersionRequirements(@Nullable String cmakeVersionFromDsl) {
        String string;
        String string2 = this.cmakeVersionFromDsl = cmakeVersionFromDsl;
        this.dslVersionHasPlus = string2 != null ? StringsKt.endsWith$default((String)string2, (String)"+", (boolean)false, (int)2, null) : false;
        this.effectiveRequestVersion = this.computeEffectiveRequestVersion();
        String string3 = this.humanReadableVersionLanguage = this.dslVersionHasPlus ? "" + '\'' + this.effectiveRequestVersion + "' or higher" : "" + '\'' + this.effectiveRequestVersion + '\'';
        if (this.effectiveRequestVersion.compareTo(CmakeLocatorKt.getForkCmakeReportedVersion(), Revision.PreviewComparison.IGNORE) == 0) {
            string = "3.6.4111459";
        } else {
            Revision revision = CmakeLocatorKt.getDefaultCmakeVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"defaultCmakeVersion");
            string = this.isSatisfiedBy(revision) ? "3.10.2.4988404" : null;
        }
        this.downloadVersion = string;
    }

    @Nullable
    public final String component1() {
        return this.cmakeVersionFromDsl;
    }

    @NotNull
    public final CmakeVersionRequirements copy(@Nullable String cmakeVersionFromDsl) {
        return new CmakeVersionRequirements(cmakeVersionFromDsl);
    }

    public static /* synthetic */ CmakeVersionRequirements copy$default(CmakeVersionRequirements cmakeVersionRequirements, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = cmakeVersionRequirements.cmakeVersionFromDsl;
        }
        return cmakeVersionRequirements.copy(string);
    }

    @NotNull
    public String toString() {
        return "CmakeVersionRequirements(cmakeVersionFromDsl=" + this.cmakeVersionFromDsl + ")";
    }

    public int hashCode() {
        String string = this.cmakeVersionFromDsl;
        return string != null ? string.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof CmakeVersionRequirements)) break block3;
                CmakeVersionRequirements cmakeVersionRequirements = (CmakeVersionRequirements)object;
                if (!Intrinsics.areEqual((Object)this.cmakeVersionFromDsl, (Object)cmakeVersionRequirements.cmakeVersionFromDsl)) break block3;
            }
            return true;
        }
        return false;
    }
}

