/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.cmake.server;

import com.android.build.gradle.external.cmake.server.CmakeInputsResult;
import com.android.build.gradle.external.cmake.server.CodeModel;
import com.android.build.gradle.external.cmake.server.ComputeResult;
import com.android.build.gradle.external.cmake.server.Configuration;
import com.android.build.gradle.external.cmake.server.ConfigureResult;
import com.android.build.gradle.external.cmake.server.FileGroup;
import com.android.build.gradle.external.cmake.server.HandshakeResult;
import com.android.build.gradle.external.cmake.server.HelloResult;
import com.android.build.gradle.external.cmake.server.Project;
import com.android.build.gradle.external.cmake.server.Target;

public class ServerUtils {
    public static boolean isHelloResultValid(HelloResult helloResult) {
        return helloResult != null && helloResult.type != null && helloResult.supportedProtocolVersions != null && helloResult.type.equals("hello") && helloResult.supportedProtocolVersions.length >= 1;
    }

    public static boolean isHandshakeResultValid(HandshakeResult handshakeResult) {
        return handshakeResult.cookie != null && handshakeResult.inReplyTo != null && handshakeResult.type != null;
    }

    public static boolean isConfigureResultValid(ConfigureResult configureResult) {
        return configureResult != null && configureResult.type != null && configureResult.inReplyTo != null && configureResult.type.equals("reply") && configureResult.inReplyTo.equals("configure");
    }

    public static boolean isComputedResultValid(ComputeResult computeResult) {
        return computeResult.inReplyTo != null && computeResult.type != null && computeResult.inReplyTo.equals("compute") && computeResult.type.equals("reply");
    }

    public static boolean isCodeModelValid(CodeModel codeModel) {
        return codeModel.type != null && codeModel.inReplyTo != null && codeModel.inReplyTo.equals("codemodel") && codeModel.type.equals("reply") && codeModel.configurations != null && ServerUtils.isCodeModelConfigurationsValid(codeModel.configurations);
    }

    public static boolean isCmakeInputsResultValid(CmakeInputsResult cmakeInputsResult) {
        return cmakeInputsResult.type != null && cmakeInputsResult.inReplyTo != null && cmakeInputsResult.inReplyTo.equals("cmakeInputs");
    }

    private static boolean isCodeModelConfigurationsValid(Configuration[] configurations) {
        if (configurations.length <= 0) {
            return false;
        }
        for (Configuration configuration2 : configurations) {
            if (configuration2.projects == null || configuration2.projects.length <= 0) {
                return false;
            }
            for (Project project : configuration2.projects) {
                if (ServerUtils.isCodeModelProjectValid(project)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isCodeModelProjectValid(Project project) {
        if (project == null || project.buildDirectory == null || project.sourceDirectory == null) {
            return false;
        }
        if (project.targets == null) {
            return true;
        }
        for (Target target : project.targets) {
            if (ServerUtils.isCodeModelTargetValid(target)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCodeModelTargetValid(Target target) {
        if (target != null && (target.artifacts == null || target.fileGroups == null)) {
            return true;
        }
        if (target == null || target.name == null || target.buildDirectory == null) {
            return false;
        }
        for (FileGroup fileGroup : target.fileGroups) {
            if (ServerUtils.isCodeModelFileGroupValid(fileGroup)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCodeModelFileGroupValid(FileGroup fileGroup) {
        return fileGroup != null && fileGroup.sources != null && fileGroup.sources.length > 0;
    }
}

