/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.IssueReporterLoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CreateCxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CreateCxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxModuleModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.process.ProcessOutputJunctionKt;
import com.android.build.gradle.internal.cxx.settings.CxxAbiModelCMakeSettingsRewriterKt;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.builder.errors.DefaultIssueReporter;
import com.android.builder.errors.IssueReporter;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import kotlin.jvm.functions.Function1;
import org.gradle.api.Action;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;

public abstract class ExternalNativeCleanTask
extends NonIncrementalTask {
    private CxxVariantModel variant;
    private List<CxxAbiModel> abis;
    private final ExecOperations execOperations;

    @Inject
    public ExternalNativeCleanTask(ExecOperations execOperations) {
        this.execOperations = execOperations;
    }

    @Override
    protected void doTaskAction() throws ProcessException, IOException {
        try (IssueReporterLoggingEnvironment ignore = new IssueReporterLoggingEnvironment((IssueReporter)new DefaultIssueReporter((ILogger)new LoggerWrapper(this.getLogger())));){
            LoggingEnvironmentKt.infoln("starting clean", new Object[0]);
            LoggingEnvironmentKt.infoln("finding existing JSONs", new Object[0]);
            ArrayList existingJsons = Lists.newArrayList();
            for (CxxAbiModel abi : this.abis) {
                if (CxxAbiModelKt.getJsonFile(abi).isFile()) {
                    existingJsons.add(CxxAbiModelKt.getJsonFile(abi));
                    continue;
                }
                LoggingEnvironmentKt.infoln("Json file not found so contents couldn't be cleaned %s", CxxAbiModelKt.getJsonFile(abi));
            }
            List<NativeBuildConfigValueMini> configValueList = AndroidBuildGradleJsons.getNativeBuildMiniConfigs(existingJsons, null);
            ArrayList cleanCommands = Lists.newArrayList();
            ArrayList targetNames2 = Lists.newArrayList();
            for (NativeBuildConfigValueMini config2 : configValueList) {
                cleanCommands.addAll(config2.cleanCommands);
                HashSet targets = Sets.newHashSet();
                for (NativeLibraryValueMini library : config2.libraries.values()) {
                    targets.add(String.format("%s %s", library.artifactName, library.abi));
                }
                targetNames2.add(Joiner.on((String)",").join((Iterable)targets));
            }
            LoggingEnvironmentKt.infoln("about to execute %s clean commands", cleanCommands.size());
            this.executeProcessBatch(cleanCommands, targetNames2);
            LoggingEnvironmentKt.infoln("clean complete", new Object[0]);
        }
    }

    private void executeProcessBatch(List<String> commands, List<String> targetNames2) throws ProcessException, IOException {
        for (int commandIndex = 0; commandIndex < commands.size(); ++commandIndex) {
            String command = commands.get(commandIndex);
            String target = targetNames2.get(commandIndex);
            this.getLogger().lifecycle(String.format("Clean %s", target));
            List tokens = StringHelper.tokenizeCommandLineToEscaped((String)command);
            ProcessInfoBuilder processBuilder = new ProcessInfoBuilder();
            processBuilder.setExecutable((String)tokens.get(0));
            for (int i2 = 1; i2 < tokens.size(); ++i2) {
                processBuilder.addArgs((String)tokens.get(i2));
            }
            LoggingEnvironmentKt.infoln("%s", processBuilder);
            ProcessOutputJunctionKt.createProcessOutputJunction(this.variant.getObjFolder(), "android_gradle_clean_" + commandIndex, processBuilder, this.getLogger(), new GradleProcessExecutor(arg_0 -> ((ExecOperations)this.execOperations).exec(arg_0)), "").logStderrToInfo().logStdoutToInfo().execute((Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult>)((Function1)arg_0 -> ((ExecOperations)this.execOperations).exec(arg_0)));
        }
    }

    public static class CreationAction
    extends VariantTaskCreationAction<ExternalNativeCleanTask> {
        private final CxxVariantModel variant;
        private final List<CxxAbiModel> abis = Lists.newArrayList();

        public CreationAction(CxxModuleModel module2, VariantScope scope) {
            super(scope);
            this.variant = CreateCxxVariantModelKt.createCxxVariantModel(module2, scope);
            for (Abi abi : Abi.values()) {
                this.abis.add(CxxAbiModelCMakeSettingsRewriterKt.rewriteCxxAbiModelWithCMakeSettings(CreateCxxAbiModelKt.createCxxAbiModel(this.variant, abi, scope.getGlobalScope(), scope.getVariantData())));
            }
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("externalNativeBuildClean");
        }

        @Override
        public Class<ExternalNativeCleanTask> getType() {
            return ExternalNativeCleanTask.class;
        }

        @Override
        public void configure(ExternalNativeCleanTask task) {
            super.configure(task);
            task.variant = this.variant;
            task.abis = this.abis;
        }
    }
}

