/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.VariantOutput;
import com.android.build.api.component.ComponentIdentity;
import com.android.build.api.variant.impl.ApplicationVariantImpl;
import com.android.build.api.variant.impl.ApplicationVariantPropertiesImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.api.variant.impl.VariantOutputImpl;
import com.android.build.api.variant.impl.VariantOutputList;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantDslInfoImpl;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.ApkData;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.OutputFactory;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantFactory;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.IssueReporter;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.resources.Density;
import com.android.utils.Pair;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.NamedDomainObjectContainer;

public class ApplicationVariantFactory
extends BaseVariantFactory {
    public ApplicationVariantFactory(GlobalScope globalScope) {
        super(globalScope);
    }

    @Override
    public VariantImpl createVariantObject(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo) {
        return (VariantImpl)this.globalScope.getDslScope().getObjectFactory().newInstance(ApplicationVariantImpl.class, new Object[]{variantDslInfo, componentIdentity});
    }

    @Override
    public VariantPropertiesImpl createVariantPropertiesObject(ComponentIdentity componentIdentity, VariantScope variantScope) {
        return (VariantPropertiesImpl)this.globalScope.getDslScope().getObjectFactory().newInstance(ApplicationVariantPropertiesImpl.class, new Object[]{this.globalScope.getDslScope(), variantScope, variantScope.getArtifacts().getOperations(), componentIdentity});
    }

    @Override
    public BaseVariantData createVariantData(VariantScope variantScope, VariantDslInfoImpl variantDslInfo, VariantImpl publicVariantApi, VariantPropertiesImpl publicVariantPropertiesApi, VariantSources variantSources, TaskManager taskManager) {
        ApplicationVariantData variant2 = new ApplicationVariantData(this.globalScope, taskManager, variantScope, (VariantDslInfo)variantDslInfo, publicVariantApi, publicVariantPropertiesApi, variantSources);
        this.computeOutputs(variantDslInfo, variant2, true);
        return variant2;
    }

    protected void computeOutputs(VariantDslInfo variantDslInfo, ApplicationVariantData variant2, boolean includeMainApk) {
        BaseExtension extension = this.globalScope.getExtension();
        variant2.calculateFilters(extension.getSplits());
        Set<String> densities = variant2.getFilters(VariantOutput.FilterType.DENSITY);
        Set<String> abis = variant2.getFilters(VariantOutput.FilterType.ABI);
        this.checkSplitsConflicts(variant2, abis);
        if (!densities.isEmpty()) {
            variant2.setCompatibleScreens(extension.getSplits().getDensity().getCompatibleScreens());
        }
        OutputFactory outputFactory = variant2.getOutputFactory();
        this.populateMultiApkOutputs(abis, densities, outputFactory, includeMainApk);
        outputFactory.finalizeApkDataList().forEach(apkData -> variant2.getPublicVariantPropertiesApi().addVariantOutput((ApkData)apkData));
        this.restrictEnabledOutputs(variantDslInfo, variant2.getPublicVariantPropertiesApi().getOutputs());
    }

    private void populateMultiApkOutputs(Set<String> abis, Set<String> densities, OutputFactory outputFactory, boolean includeMainApk) {
        boolean universalApkForAbi;
        if (densities.isEmpty() && abis.isEmpty()) {
            if (includeMainApk) {
                outputFactory.addMainApk();
            }
            return;
        }
        boolean bl = universalApkForAbi = this.globalScope.getExtension().getSplits().getAbi().isEnable() && this.globalScope.getExtension().getSplits().getAbi().isUniversalApk();
        if (universalApkForAbi) {
            outputFactory.addUniversalApk();
        } else if (abis.isEmpty() && includeMainApk) {
            outputFactory.addUniversalApk();
        }
        if (!abis.isEmpty()) {
            abis.forEach(abi -> outputFactory.addFullSplit((ImmutableList<Pair<VariantOutput.FilterType, String>>)ImmutableList.of((Object)Pair.of((Object)VariantOutput.FilterType.ABI, (Object)abi))));
        }
        for (String density : densities) {
            if (!abis.isEmpty()) {
                for (String abi2 : abis) {
                    outputFactory.addFullSplit((ImmutableList<Pair<VariantOutput.FilterType, String>>)ImmutableList.of((Object)Pair.of((Object)VariantOutput.FilterType.ABI, (Object)abi2), (Object)Pair.of((Object)VariantOutput.FilterType.DENSITY, (Object)density)));
                }
                continue;
            }
            outputFactory.addFullSplit((ImmutableList<Pair<VariantOutput.FilterType, String>>)ImmutableList.of((Object)Pair.of((Object)VariantOutput.FilterType.DENSITY, (Object)density)));
        }
    }

    private void checkSplitsConflicts(ApplicationVariantData variantData, Set<String> abiFilters) {
        if (abiFilters.isEmpty()) {
            return;
        }
        if (this.globalScope.getExtension().getSplits().getAbi().isUniversalApk()) {
            return;
        }
        Set<String> ndkConfigAbiFilters = variantData.getVariantDslInfo().getNdkConfig().getAbiFilters();
        if (ndkConfigAbiFilters == null || ndkConfigAbiFilters.isEmpty()) {
            return;
        }
        IssueReporter issueReporter = this.globalScope.getDslScope().getIssueReporter();
        issueReporter.reportError(IssueReporter.Type.GENERIC, String.format("Conflicting configuration : '%1$s' in ndk abiFilters cannot be present when splits abi filters are set : %2$s", Joiner.on((String)",").join(ndkConfigAbiFilters), Joiner.on((String)",").join(abiFilters)));
    }

    private void restrictEnabledOutputs(VariantDslInfo variantDslInfo, VariantOutputList variantOutputs) {
        String buildTargetAbi;
        Set<String> supportedAbis2 = variantDslInfo.getSupportedAbis();
        ProjectOptions projectOptions = this.globalScope.getProjectOptions();
        String string = buildTargetAbi = projectOptions.get(BooleanOption.BUILD_ONLY_TARGET_ABI) || this.globalScope.getExtension().getSplits().getAbi().isEnable() ? projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI) : null;
        if (buildTargetAbi == null) {
            return;
        }
        String buildTargetDensity = projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY);
        Density density = Density.getEnum((String)buildTargetDensity);
        List apkDataList = variantOutputs.stream().map(VariantOutputImpl::getApkData).collect(Collectors.toList());
        List apksToGenerate = SplitOutputMatcher.computeBestOutput(apkDataList, supportedAbis2, (int)(density == null ? -1 : density.getDpiValue()), Arrays.asList(Strings.nullToEmpty((String)buildTargetAbi).split(",")));
        if (apksToGenerate.isEmpty()) {
            List splits = apkDataList.stream().map(ApkData::getFilterName).filter(Objects::nonNull).collect(Collectors.toList());
            this.globalScope.getDslScope().getIssueReporter().reportWarning(IssueReporter.Type.GENERIC, String.format("Cannot build selected target ABI: %1$s, " + (splits.isEmpty() ? "no suitable splits configured: %2$s;" : "supported ABIs are: %2$s"), buildTargetAbi, supportedAbis2 == null ? Joiner.on((String)", ").join(splits) : Joiner.on((String)", ").join(supportedAbis2)));
            return;
        }
        variantOutputs.forEach(variantOutput -> {
            if (!apksToGenerate.contains(variantOutput.getApkData())) {
                variantOutput.isEnabled().set((Object)false);
            }
        });
    }

    @Override
    public Class<? extends BaseVariantImpl> getVariantImplementationClass(BaseVariantData variantData) {
        return com.android.build.gradle.internal.api.ApplicationVariantImpl.class;
    }

    @Override
    public VariantType getVariantType() {
        if (this.globalScope.getExtension().getBaseFeature().booleanValue()) {
            return VariantTypeImpl.BASE_APK;
        }
        return VariantTypeImpl.OPTIONAL_APK;
    }

    @Override
    public boolean hasTestScope() {
        return true;
    }

    @Override
    public void validateModel(VariantInputModel model2) {
        super.validateModel(model2);
        this.validateVersionCodes(model2);
        if (!this.getVariantType().isDynamicFeature()) {
            return;
        }
        IssueReporter issueReporter = this.globalScope.getDslScope().getIssueReporter();
        for (BuildTypeData buildType : model2.getBuildTypes().values()) {
            if (!buildType.getBuildType().isMinifyEnabled()) continue;
            issueReporter.reportError(IssueReporter.Type.GENERIC, "Dynamic feature modules cannot set minifyEnabled to true. minifyEnabled is set to true in build type '" + buildType.getBuildType().getName() + "'.\nTo enable minification for a dynamic feature module, set minifyEnabled to true in the base module.");
        }
        String message = "Signing configuration should not be declared in build types of dynamic-feature. Dynamic-features use the signing configuration declared in the application module.";
        for (BuildTypeData buildTypeData : model2.getBuildTypes().values()) {
            if (buildTypeData.getBuildType().getSigningConfig() == null) continue;
            issueReporter.reportWarning(IssueReporter.Type.SIGNING_CONFIG_DECLARED_IN_DYNAMIC_FEATURE, message);
        }
        message = "Signing configuration should not be declared in product flavors of dynamic-feature. Dynamic-features use the signing configuration declared in the application module.";
        for (ProductFlavorData productFlavorData : model2.getProductFlavors().values()) {
            if (((ProductFlavor)productFlavorData.getProductFlavor()).getSigningConfig() == null) continue;
            issueReporter.reportWarning(IssueReporter.Type.SIGNING_CONFIG_DECLARED_IN_DYNAMIC_FEATURE, message);
        }
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
        buildTypes.create("release");
    }

    private void validateVersionCodes(VariantInputModel model2) {
        IssueReporter issueReporter = this.globalScope.getDslScope().getIssueReporter();
        Integer versionCode = model2.getDefaultConfig().getProductFlavor().getVersionCode();
        if (versionCode != null && versionCode < 1) {
            issueReporter.reportError(IssueReporter.Type.GENERIC, "android.defaultConfig.versionCode is set to " + versionCode + ", but it should be a positive integer.\nSee https://developer.android.com/studio/publish/versioning#appversioning for more information.");
            return;
        }
        for (ProductFlavorData<ProductFlavor> flavorData : model2.getProductFlavors().values()) {
            Integer flavorVersionCode = flavorData.getProductFlavor().getVersionCode();
            if (flavorVersionCode == null || flavorVersionCode > 0) {
                return;
            }
            issueReporter.reportError(IssueReporter.Type.GENERIC, "versionCode is set to " + flavorVersionCode + " in product flavor " + flavorData.getProductFlavor().getName() + ", but it should be a positive integer.\nSee https://developer.android.com/studio/publish/versioning#appversioning for more information.");
        }
    }
}

