/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing;

import com.android.build.gradle.internal.testing.BaseTestRunner;
import com.android.build.gradle.internal.testing.CustomTestRunListener;
import com.android.build.gradle.internal.testing.TestData;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ddmlib.testrunner.TestRunResult;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class ShardedTestRunnable
implements Runnable {
    public static final String FILE_COVERAGE_EC_SUFFIX = "coverage.ec";
    private final String projectName;
    private final DeviceConnector device;
    private final String flavorName;
    private final TestData testData;
    private final File resultsDir;
    private final File coverageDir;
    private final List<File> testedApks;
    private final ILogger logger;
    private final ShardProvider shardProvider;
    private final BaseTestRunner.TestResult testResult;
    private final int timeoutInMs;
    private final ProgressListener progressListener;

    @Inject
    public ShardedTestRunnable(ShardedTestParams params) {
        this.projectName = params.projectName;
        this.device = params.device;
        this.flavorName = params.flavorName;
        this.resultsDir = params.resultsDir;
        this.coverageDir = params.coverageDir;
        this.testedApks = params.testedApks;
        this.testData = params.testData;
        this.timeoutInMs = params.timeoutInMs;
        this.logger = params.logger;
        this.shardProvider = params.shardProvider;
        this.progressListener = params.progressListener;
        this.testResult = params.testResult;
    }

    private String createCoverageFileName(int shard) {
        return "shard_" + shard + FILE_COVERAGE_EC_SUFFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        String deviceName = this.device.getName();
        boolean isInstalled = false;
        long time = System.currentTimeMillis();
        boolean failed = false;
        ArrayList<String> coverageFiles = new ArrayList<String>();
        String coverageFileLocation = "/data/data/" + this.testData.getTestedApplicationId() + "/";
        CustomTestRunListener runListener = null;
        try {
            this.device.connect(this.timeoutInMs, this.logger);
            this.logger.verbose("Connected to %s to run tests", new Object[]{deviceName});
            Class<ShardedTestRunnable> clazz = ShardedTestRunnable.class;
            synchronized (ShardedTestRunnable.class) {
                Integer shard;
                if (!this.testedApks.isEmpty()) {
                    this.logger.verbose("DeviceConnector '%s': installing %s", new Object[]{deviceName, Joiner.on((char)',').join(this.testedApks)});
                    if (this.testedApks.size() > 1 && this.device.getApiLevel() < 21) {
                        throw new InstallException("Internal error, file a bug, multi-apk applications require a device with API level 21+");
                    }
                    if (this.testedApks.size() > 1) {
                        this.device.installPackages(this.testedApks, (Collection)ImmutableList.of(), this.timeoutInMs, this.logger);
                    } else {
                        this.device.installPackage(this.testedApks.get(0), (Collection)ImmutableList.of(), this.timeoutInMs, this.logger);
                    }
                }
                this.logger.verbose("DeviceConnector '%s': installing %s", new Object[]{deviceName, this.testData.getTestApk()});
                if (this.device.getApiLevel() >= 21) {
                    this.device.installPackages((List)ImmutableList.of((Object)this.testData.getTestApk()), (Collection)ImmutableList.of(), this.timeoutInMs, this.logger);
                } else {
                    this.device.installPackage(this.testData.getTestApk(), (Collection)ImmutableList.of(), this.timeoutInMs, this.logger);
                }
                this.logger.verbose("Installed test apk on %s", new Object[]{deviceName});
                // ** MonitorExit[var9_8] (shouldn't be in output)
                isInstalled = true;
                while ((shard = this.shardProvider.getNextShard()) != null) {
                    this.logger.verbose("Running shard %d on %s", new Object[]{shard, deviceName});
                    RemoteAndroidTestRunner runner = new RemoteAndroidTestRunner(this.testData.getApplicationId(), this.testData.getInstrumentationRunner(), (IShellEnabledDevice)this.device);
                    for (Map.Entry<String, String> argument : this.testData.getInstrumentationRunnerArguments().entrySet()) {
                        runner.addInstrumentationArg(argument.getKey(), argument.getValue());
                    }
                    if (this.testData.isTestCoverageEnabled()) {
                        runner.addInstrumentationArg("coverage", "true");
                        String coverageFileName = this.createCoverageFileName(shard);
                        coverageFiles.add(coverageFileName);
                        runner.addInstrumentationArg("coverageFile", coverageFileLocation + coverageFileName);
                    }
                    runner.addInstrumentationArg("shardIndex", String.valueOf(shard));
                    runner.addInstrumentationArg("numShards", String.valueOf(this.shardProvider.getTotalShards()));
                    runner.setRunName(deviceName);
                    runner.setMaxtimeToOutputResponse(this.timeoutInMs);
                    runListener = new ShardedTestListener(shard, deviceName, this.projectName, this.flavorName, this.logger);
                    runListener.setReportDir(this.resultsDir);
                    ((ShardedTestListener)runListener).setProgressListener(this.progressListener);
                    runner.run(new ITestRunListener[]{runListener});
                    TestRunResult testRunResult = runListener.getRunResult();
                    if (testRunResult.getNumTests() == 0) {
                        this.logger.warning("shard %d  has 0 tests. This might be OK", new Object[]{shard});
                    }
                    failed |= testRunResult.hasFailedTests() || testRunResult.isRunFailure();
                    this.logger.verbose("done running shard %d on %s", new Object[]{shard, deviceName});
                }
                this.testResult.setTestResult(failed ? BaseTestRunner.TestResult.Result.FAILED : BaseTestRunner.TestResult.Result.SUCCEEDED);
                if (!isInstalled) break block40;
                if (!this.testData.isTestCoverageEnabled()) break block41;
            }
        }
        catch (Exception e) {
            try {
                Map<String, String> emptyMetrics = Collections.emptyMap();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(baos, true);
                e.printStackTrace(pw);
                TestIdentifier fakeTest = new TestIdentifier(this.device.getClass().getName(), "runTests");
                if (runListener == null) throw new RuntimeException(e);
                runListener.testStarted(fakeTest);
                runListener.testFailed(fakeTest, baos.toString());
                runListener.testEnded(fakeTest, emptyMetrics);
                runListener.testRunEnded(System.currentTimeMillis() - time, emptyMetrics);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                if (isInstalled) {
                    if (this.testData.isTestCoverageEnabled()) {
                        MultiLineReceiver outputReceiver = new MultiLineReceiver(){

                            public void processNewLines(String[] lines) {
                                for (String line : lines) {
                                    ShardedTestRunnable.this.logger.verbose(line, new Object[0]);
                                }
                            }

                            public boolean isCancelled() {
                                return false;
                            }
                        };
                        this.logger.verbose("Have %d coverage files to fetch", new Object[]{coverageFiles.size()});
                        for (String name2 : coverageFiles) {
                            String temporaryCoverageCopy = "/data/local/tmp/" + this.testData.getTestedApplicationId() + "." + name2;
                            String coverageFile = coverageFileLocation + name2;
                            this.logger.verbose("DeviceConnector '%s': fetching coverage data from %s", new Object[]{deviceName, coverageFile});
                            try {
                                this.device.executeShellCommand("run-as " + this.testData.getTestedApplicationId() + " cat " + coverageFile + " | cat > " + temporaryCoverageCopy, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
                                this.device.pullFile(temporaryCoverageCopy, new File(this.coverageDir, name2).getPath());
                                this.device.executeShellCommand("rm " + temporaryCoverageCopy, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
                            }
                            catch (Throwable e2) {
                                throw new RuntimeException(e2);
                            }
                        }
                    }
                    try {
                        this.uninstall(this.testData.getTestApk(), this.testData.getApplicationId(), deviceName);
                    }
                    catch (DeviceException e3) {
                        throw new RuntimeException(e3);
                    }
                    if (!this.testedApks.isEmpty()) {
                        for (File testedApk : this.testedApks) {
                            try {
                                this.uninstall(testedApk, this.testData.getTestedApplicationId(), deviceName);
                            }
                            catch (DeviceException e4) {
                                throw new RuntimeException(e4);
                            }
                        }
                    }
                }
                try {
                    this.device.disconnect(this.timeoutInMs, this.logger);
                    throw throwable;
                }
                catch (TimeoutException e5) {
                    throw new RuntimeException(e5);
                }
            }
        }
        {
            block40: {
                block41: {
                    MultiLineReceiver outputReceiver = new /* invalid duplicate definition of identical inner class */;
                    this.logger.verbose("Have %d coverage files to fetch", new Object[]{coverageFiles.size()});
                    for (String name3 : coverageFiles) {
                        String temporaryCoverageCopy = "/data/local/tmp/" + this.testData.getTestedApplicationId() + "." + name3;
                        String coverageFile = coverageFileLocation + name3;
                        this.logger.verbose("DeviceConnector '%s': fetching coverage data from %s", new Object[]{deviceName, coverageFile});
                        try {
                            this.device.executeShellCommand("run-as " + this.testData.getTestedApplicationId() + " cat " + coverageFile + " | cat > " + temporaryCoverageCopy, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
                            this.device.pullFile(temporaryCoverageCopy, new File(this.coverageDir, name3).getPath());
                            this.device.executeShellCommand("rm " + temporaryCoverageCopy, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
                        }
                        catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                try {
                    this.uninstall(this.testData.getTestApk(), this.testData.getApplicationId(), deviceName);
                }
                catch (DeviceException e) {
                    throw new RuntimeException(e);
                }
                if (!this.testedApks.isEmpty()) {
                    for (File testedApk : this.testedApks) {
                        try {
                            this.uninstall(testedApk, this.testData.getTestedApplicationId(), deviceName);
                        }
                        catch (DeviceException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            try {
                this.device.disconnect(this.timeoutInMs, this.logger);
                return;
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void uninstall(File apkFile, String packageName, String deviceName) throws DeviceException {
        if (packageName != null) {
            this.logger.verbose("DeviceConnector '%s': uninstalling %s", new Object[]{deviceName, packageName});
            this.device.uninstallPackage(packageName, this.timeoutInMs, this.logger);
        } else {
            this.logger.verbose("DeviceConnector '%s': unable to uninstall %s: unable to get package name", new Object[]{deviceName, apkFile});
        }
    }

    public static class ShardedTestParams
    implements Serializable {
        private final String projectName;
        private final DeviceConnector device;
        private final String flavorName;
        private final TestData testData;
        private final File resultsDir;
        private final File coverageDir;
        private final List<File> testedApks;
        private final ILogger logger;
        private final ShardProvider shardProvider;
        private final BaseTestRunner.TestResult testResult;
        private final int timeoutInMs;
        private final ProgressListener progressListener;

        public ShardedTestParams(DeviceConnector device, String projectName, String flavorName2, List<File> testedApks, TestData testData, File resultsDir, File coverageDir, int timeoutInMs, ILogger logger, ShardProvider shardProvider, ProgressListener progressListener, BaseTestRunner.TestResult testResult) {
            this.projectName = projectName;
            this.device = device;
            this.flavorName = flavorName2;
            this.resultsDir = resultsDir;
            this.coverageDir = coverageDir;
            this.testedApks = testedApks;
            this.testData = testData;
            this.timeoutInMs = timeoutInMs;
            this.logger = logger;
            this.shardProvider = shardProvider;
            this.progressListener = progressListener;
            this.testResult = testResult;
        }
    }

    public static class ProgressListener {
        int knownShardCounts;
        int estimatedTestCount;
        int finishedTestCount;
        int shardCount;
        int knownTestCount;
        ILogger logger;

        public ProgressListener(int shardCount, ILogger logger) {
            this.shardCount = shardCount;
            this.logger = logger;
        }

        public synchronized void setTestCountForOneShard(int testCount) {
            ++this.knownShardCounts;
            this.knownTestCount += testCount;
            this.estimatedTestCount = this.shardCount * (int)Math.ceil((float)this.knownTestCount / (float)this.knownShardCounts);
        }

        public synchronized void onTestFinished() {
            ++this.finishedTestCount;
            this.logger.verbose("finished %d of estimated %d tests. %.2f%%", new Object[]{this.finishedTestCount, this.estimatedTestCount, Float.valueOf(this.estimatedTestCount == 0 ? 0.0f : 100.0f * (float)this.finishedTestCount / (float)this.estimatedTestCount)});
        }
    }

    private static final class ShardedTestListener
    extends CustomTestRunListener {
        private final String name;
        private ProgressListener mProgressListener;

        public ShardedTestListener(int shard, String deviceName, String projectName, String flavorName2, ILogger logger) {
            super(deviceName, projectName, flavorName2, logger);
            this.name = "TEST-" + deviceName + "-" + projectName + "-" + flavorName2 + "-shard-" + shard + ".xml";
        }

        public void setProgressListener(ProgressListener progressListener) {
            this.mProgressListener = progressListener;
        }

        @Override
        protected File getResultFile(File reportDir) throws IOException {
            return new File(reportDir, this.name);
        }

        @Override
        public void testRunStarted(String runName, int testCount) {
            super.testRunStarted(runName, testCount);
            if (this.mProgressListener != null) {
                this.mProgressListener.setTestCountForOneShard(testCount);
            }
        }

        @Override
        public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
            super.testEnded(test, testMetrics);
            if (this.mProgressListener != null) {
                this.mProgressListener.onTestFinished();
            }
        }
    }

    public static interface ShardProvider {
        public Integer getNextShard();

        public int getTotalShards();
    }
}

