/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.builder.core.DesugarProcessBuilder;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.tasks.OutputFile;

public abstract class ExtractTryWithResourcesSupportJar
extends NonIncrementalTask {
    private ConfigurableFileCollection outputLocation;

    @Override
    protected void doTaskAction() throws IOException {
        try (InputStream in = DesugarProcessBuilder.class.getClassLoader().getResourceAsStream("libthrowable_extension.jar");){
            FileUtils.cleanOutputDir((File)this.outputLocation.getSingleFile().getParentFile());
            Files.copy(in, this.outputLocation.getSingleFile().toPath(), new CopyOption[0]);
        }
    }

    @OutputFile
    public File getOutputLocation() {
        return this.outputLocation.getSingleFile();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<ExtractTryWithResourcesSupportJar> {
        public CreationAction(VariantScope variantScope) {
            super(variantScope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("extractTryWithResourcesSupportJar");
        }

        @Override
        public Class<ExtractTryWithResourcesSupportJar> getType() {
            return ExtractTryWithResourcesSupportJar.class;
        }

        @Override
        public void configure(ExtractTryWithResourcesSupportJar task) {
            super.configure(task);
            task.outputLocation = this.getVariantScope().getTryWithResourceRuntimeSupportJar();
        }
    }
}

