/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.dependency.ClassesDirToClassesTransformKt;
import com.android.build.gradle.internal.packaging.JarCreatorFactory;
import com.android.build.gradle.internal.packaging.JarCreatorType;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.tasks.BundleLibraryClassesKt;
import com.android.build.gradle.internal.tasks.BundleLibraryClassesRunnable$WhenMappings;
import com.android.build.gradle.internal.tasks.LibraryAarJarsTask;
import com.android.builder.dexing.ClassBucketGroupKt;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableFileChanges;
import com.android.builder.packaging.JarCreator;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J,\u0010\u000e\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0002J\b\u0010\u0014\u001a\u00020\u0006H\u0016J4\u0010\u0015\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0016\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleLibraryClassesRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/BundleLibraryClassesRunnable$Params;", "(Lcom/android/build/gradle/internal/tasks/BundleLibraryClassesRunnable$Params;)V", "copyFilesIncrementally", "", "inputChanges", "Lcom/android/builder/files/SerializableFileChanges;", "outputDir", "Ljava/io/File;", "filter", "Ljava/util/function/Predicate;", "", "copyFilesNonIncrementally", "input", "", "getClassesDirFormat", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ClassesDirFormat;", "inputClassRoots", "run", "zipFilesNonIncrementally", "outputJar", "jarCreatorType", "Lcom/android/build/gradle/internal/packaging/JarCreatorType;", "Params", "gradle"})
public final class BundleLibraryClassesRunnable
implements Runnable {
    private final Params params;

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.plus((Collection)LibraryAarJarsTask.Companion.getDefaultExcludes(StringsKt.replace$default((String)this.params.getPackageName(), (char)'.', (char)'/', (boolean)false, (int)4, null), this.params.getPackageRClass()), (Iterable)this.params.getToIgnore());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pattern pattern = Pattern.compile((String)it);
            collection.add(pattern);
        }
        List ignorePatterns = (List)destination$iv$iv;
        Predicate predicate2 = new Predicate<String>(ignorePatterns){
            final /* synthetic */ List $ignorePatterns;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean test(@NotNull String relativePath) {
                Pattern it;
                Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                String normalizedPath = FileUtils.toSystemIndependentPath((String)relativePath);
                if (!BundleLibraryClassesKt.access$getCLASS_PATTERN$p().matcher(normalizedPath).matches()) {
                    if (!BundleLibraryClassesKt.access$getMETA_INF_PATTERN$p().matcher(normalizedPath).matches()) return false;
                }
                Iterable $this$any$iv = this.$ignorePatterns;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return true;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return true;
                    T element$iv = iterator.next();
                    it = (Pattern)element$iv;
                    boolean bl = false;
                } while (!it.matcher(normalizedPath).matches());
                return false;
            }
            {
                this.$ignorePatterns = list;
            }
        };
        if (this.params.getOutputType() == AndroidArtifacts.ArtifactType.CLASSES_JAR) {
            this.zipFilesNonIncrementally(this.params.getInput(), this.params.getOutput(), predicate2, this.params.getJarCreatorType());
        } else {
            switch (BundleLibraryClassesRunnable$WhenMappings.$EnumSwitchMapping$0[this.getClassesDirFormat(this.params.getInput()).ordinal()]) {
                case 1: {
                    FileUtils.deleteRecursivelyIfExists((File)this.params.getOutput());
                    FileUtils.mkdirs((File)this.params.getOutput());
                    this.zipFilesNonIncrementally(this.params.getInput(), FilesKt.resolve((File)this.params.getOutput(), (String)"classes.jar"), predicate2, this.params.getJarCreatorType());
                    break;
                }
                case 2: {
                    if (this.params.getIncremental()) {
                        if (ClassesDirToClassesTransformKt.getClassesDirFormat(this.params.getOutput()) == AndroidArtifacts.ClassesDirFormat.CONTAINS_SINGLE_JAR) {
                            this.copyFilesNonIncrementally(this.params.getInput(), this.params.getOutput(), predicate2);
                            break;
                        }
                        this.copyFilesIncrementally(this.params.getInputChanges(), this.params.getOutput(), predicate2);
                        break;
                    }
                    this.copyFilesNonIncrementally(this.params.getInput(), this.params.getOutput(), predicate2);
                    break;
                }
            }
        }
    }

    private final AndroidArtifacts.ClassesDirFormat getClassesDirFormat(Set<? extends File> inputClassRoots) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = inputClassRoots;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    File it = (File)element$iv;
                    boolean bl2 = false;
                    if (!((Boolean)ClassBucketGroupKt.isJarFile().invoke((Object)it)).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl ? AndroidArtifacts.ClassesDirFormat.CONTAINS_SINGLE_JAR : AndroidArtifacts.ClassesDirFormat.CONTAINS_CLASS_FILES_ONLY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zipFilesNonIncrementally(Set<? extends File> input, File outputJar, Predicate<String> filter2, JarCreatorType jarCreatorType) {
        FileUtils.deleteIfExists((File)outputJar);
        FileUtils.mkdirs((File)outputJar.getParentFile());
        Path path = outputJar.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"outputJar.toPath()");
        Closeable closeable = (Closeable)JarCreatorFactory.INSTANCE.make(path, filter2, jarCreatorType);
        boolean bl = false;
        Throwable throwable = null;
        try {
            JarCreator jarCreator = (JarCreator)closeable;
            boolean bl2 = false;
            jarCreator.setCompressionLevel(0);
            Iterable $this$forEach$iv = input;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File base = (File)element$iv;
                boolean bl3 = false;
                if (base.isDirectory()) {
                    jarCreator.addDirectory(base.toPath());
                    continue;
                }
                boolean bl4 = (Boolean)ClassBucketGroupKt.isJarFile().invoke((Object)base);
                boolean bl5 = false;
                boolean bl6 = false;
                if (!bl4) {
                    boolean bl7 = false;
                    String string = "Expected jar file but found " + base.getPath() + '.';
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                jarCreator.addJar(base.toPath());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void copyFilesNonIncrementally(Set<? extends File> input, File outputDir, Predicate<String> filter2) {
        FileUtils.deleteRecursivelyIfExists((File)outputDir);
        FileUtils.mkdirs((File)outputDir);
        Iterable $this$forEach$iv = input;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File classRoot = (File)element$iv;
            boolean bl = false;
            boolean bl2 = classRoot.isDirectory();
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "Expected directory but found " + classRoot.getPath() + '.';
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Sequence $this$forEach$iv2 = (Sequence)FilesKt.walk$default((File)classRoot, null, (int)1, null);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String relativePath;
                File it = (File)element$iv2;
                boolean bl6 = false;
                String string = relativePath = FilesKt.relativeTo((File)it, (File)classRoot).getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"relativePath");
                CharSequence charSequence = string;
                boolean bl7 = false;
                if (!(charSequence.length() > 0) || !filter2.test(relativePath)) continue;
                File outputFile = FilesKt.resolve((File)outputDir, (String)relativePath);
                FileUtils.mkdirs((File)outputFile.getParentFile());
                FileUtils.copyFile((File)it, (File)outputFile);
            }
        }
    }

    private final void copyFilesIncrementally(SerializableFileChanges inputChanges, File outputDir, Predicate<String> filter2) {
        SerializableChange it;
        Iterable $this$forEach$iv = inputChanges.getRemovedFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SerializableChange)element$iv;
            boolean bl = false;
            File staleOutputFile = FilesKt.resolve((File)outputDir, (String)it.getNormalizedPath());
            FileUtils.deleteRecursivelyIfExists((File)staleOutputFile);
        }
        $this$forEach$iv = CollectionsKt.plus((Collection)inputChanges.getModifiedFiles(), (Iterable)inputChanges.getAddedFiles());
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SerializableChange)element$iv;
            boolean bl = false;
            String relativePath = it.getNormalizedPath();
            CharSequence charSequence = relativePath;
            boolean bl2 = false;
            if (!(charSequence.length() > 0) || !filter2.test(relativePath)) continue;
            File outputFile = FilesKt.resolve((File)outputDir, (String)relativePath);
            FileUtils.mkdirs((File)outputFile.getParentFile());
            FileUtils.copyFile((File)it.getFile(), (File)outputFile);
        }
    }

    @Inject
    public BundleLibraryClassesRunnable(@NotNull Params params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        this.params = params;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 52\u00020\u0001:\u00015BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\r\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0007H\u00c6\u0003J\t\u0010(\u001a\u00020\tH\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u00c6\u0003J\t\u0010*\u001a\u00020\rH\u00c6\u0003J\t\u0010+\u001a\u00020\u000fH\u00c6\u0003J\t\u0010,\u001a\u00020\rH\u00c6\u0003J\t\u0010-\u001a\u00020\u0012H\u00c6\u0003Jo\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u00c6\u0001J\u0013\u0010/\u001a\u00020\r2\b\u00100\u001a\u0004\u0018\u000101H\u00d6\u0003J\t\u00102\u001a\u000203H\u00d6\u0001J\t\u00104\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0015R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00066"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleLibraryClassesRunnable$Params;", "Ljava/io/Serializable;", "packageName", "", "toIgnore", "", "outputType", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ArtifactType;", "output", "Ljava/io/File;", "input", "", "incremental", "", "inputChanges", "Lcom/android/builder/files/SerializableFileChanges;", "packageRClass", "jarCreatorType", "Lcom/android/build/gradle/internal/packaging/JarCreatorType;", "(Ljava/lang/String;Ljava/util/List;Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ArtifactType;Ljava/io/File;Ljava/util/Set;ZLcom/android/builder/files/SerializableFileChanges;ZLcom/android/build/gradle/internal/packaging/JarCreatorType;)V", "getIncremental", "()Z", "getInput", "()Ljava/util/Set;", "getInputChanges", "()Lcom/android/builder/files/SerializableFileChanges;", "getJarCreatorType", "()Lcom/android/build/gradle/internal/packaging/JarCreatorType;", "getOutput", "()Ljava/io/File;", "getOutputType", "()Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ArtifactType;", "getPackageName", "()Ljava/lang/String;", "getPackageRClass", "getToIgnore", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "gradle"})
    public static final class Params
    implements Serializable {
        @NotNull
        private final String packageName;
        @NotNull
        private final List<String> toIgnore;
        @NotNull
        private final AndroidArtifacts.ArtifactType outputType;
        @NotNull
        private final File output;
        @NotNull
        private final Set<File> input;
        private final boolean incremental;
        @NotNull
        private final SerializableFileChanges inputChanges;
        private final boolean packageRClass;
        @NotNull
        private final JarCreatorType jarCreatorType;
        private static final long serialVersionUID = 1L;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        @NotNull
        public final List<String> getToIgnore() {
            return this.toIgnore;
        }

        @NotNull
        public final AndroidArtifacts.ArtifactType getOutputType() {
            return this.outputType;
        }

        @NotNull
        public final File getOutput() {
            return this.output;
        }

        @NotNull
        public final Set<File> getInput() {
            return this.input;
        }

        public final boolean getIncremental() {
            return this.incremental;
        }

        @NotNull
        public final SerializableFileChanges getInputChanges() {
            return this.inputChanges;
        }

        public final boolean getPackageRClass() {
            return this.packageRClass;
        }

        @NotNull
        public final JarCreatorType getJarCreatorType() {
            return this.jarCreatorType;
        }

        public Params(@NotNull String packageName, @NotNull List<String> toIgnore, @NotNull AndroidArtifacts.ArtifactType outputType, @NotNull File output2, @NotNull Set<? extends File> input, boolean incremental, @NotNull SerializableFileChanges inputChanges, boolean packageRClass, @NotNull JarCreatorType jarCreatorType) {
            Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
            Intrinsics.checkParameterIsNotNull(toIgnore, (String)"toIgnore");
            Intrinsics.checkParameterIsNotNull((Object)((Object)outputType), (String)"outputType");
            Intrinsics.checkParameterIsNotNull((Object)output2, (String)"output");
            Intrinsics.checkParameterIsNotNull(input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)inputChanges, (String)"inputChanges");
            Intrinsics.checkParameterIsNotNull((Object)((Object)jarCreatorType), (String)"jarCreatorType");
            this.packageName = packageName;
            this.toIgnore = toIgnore;
            this.outputType = outputType;
            this.output = output2;
            this.input = input;
            this.incremental = incremental;
            this.inputChanges = inputChanges;
            this.packageRClass = packageRClass;
            this.jarCreatorType = jarCreatorType;
            if (this.outputType == AndroidArtifacts.ArtifactType.CLASSES_JAR) {
                boolean bl = (Boolean)ClassBucketGroupKt.isJarFile().invoke((Object)this.output);
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl42 = false;
                    String string = "Expected jar file but found " + this.output.getPath();
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            } else {
                boolean bl = this.outputType == AndroidArtifacts.ArtifactType.CLASSES_DIR;
                boolean bl5 = false;
                boolean bl6 = false;
                bl6 = false;
                boolean bl42 = false;
                if (!bl) {
                    boolean bl7 = false;
                    String bl42 = "Check failed.";
                    throw (Throwable)new IllegalStateException(bl42.toString());
                }
                bl = (Boolean)ClassBucketGroupKt.isJarFile().invoke((Object)this.output) == false;
                bl5 = false;
                bl6 = false;
                if (!bl) {
                    boolean bl8 = false;
                    String string = "Expected directory but found " + this.output.getPath();
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }

        @NotNull
        public final String component1() {
            return this.packageName;
        }

        @NotNull
        public final List<String> component2() {
            return this.toIgnore;
        }

        @NotNull
        public final AndroidArtifacts.ArtifactType component3() {
            return this.outputType;
        }

        @NotNull
        public final File component4() {
            return this.output;
        }

        @NotNull
        public final Set<File> component5() {
            return this.input;
        }

        public final boolean component6() {
            return this.incremental;
        }

        @NotNull
        public final SerializableFileChanges component7() {
            return this.inputChanges;
        }

        public final boolean component8() {
            return this.packageRClass;
        }

        @NotNull
        public final JarCreatorType component9() {
            return this.jarCreatorType;
        }

        @NotNull
        public final Params copy(@NotNull String packageName, @NotNull List<String> toIgnore, @NotNull AndroidArtifacts.ArtifactType outputType, @NotNull File output2, @NotNull Set<? extends File> input, boolean incremental, @NotNull SerializableFileChanges inputChanges, boolean packageRClass, @NotNull JarCreatorType jarCreatorType) {
            Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
            Intrinsics.checkParameterIsNotNull(toIgnore, (String)"toIgnore");
            Intrinsics.checkParameterIsNotNull((Object)((Object)outputType), (String)"outputType");
            Intrinsics.checkParameterIsNotNull((Object)output2, (String)"output");
            Intrinsics.checkParameterIsNotNull(input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)inputChanges, (String)"inputChanges");
            Intrinsics.checkParameterIsNotNull((Object)((Object)jarCreatorType), (String)"jarCreatorType");
            return new Params(packageName, toIgnore, outputType, output2, input, incremental, inputChanges, packageRClass, jarCreatorType);
        }

        public static /* synthetic */ Params copy$default(Params params, String string, List list, AndroidArtifacts.ArtifactType artifactType, File file, Set set, boolean bl, SerializableFileChanges serializableFileChanges, boolean bl2, JarCreatorType jarCreatorType, int n, Object object) {
            if ((n & 1) != 0) {
                string = params.packageName;
            }
            if ((n & 2) != 0) {
                list = params.toIgnore;
            }
            if ((n & 4) != 0) {
                artifactType = params.outputType;
            }
            if ((n & 8) != 0) {
                file = params.output;
            }
            if ((n & 0x10) != 0) {
                set = params.input;
            }
            if ((n & 0x20) != 0) {
                bl = params.incremental;
            }
            if ((n & 0x40) != 0) {
                serializableFileChanges = params.inputChanges;
            }
            if ((n & 0x80) != 0) {
                bl2 = params.packageRClass;
            }
            if ((n & 0x100) != 0) {
                jarCreatorType = params.jarCreatorType;
            }
            return params.copy(string, list, artifactType, file, set, bl, serializableFileChanges, bl2, jarCreatorType);
        }

        @NotNull
        public String toString() {
            return "Params(packageName=" + this.packageName + ", toIgnore=" + this.toIgnore + ", outputType=" + (Object)((Object)this.outputType) + ", output=" + this.output + ", input=" + this.input + ", incremental=" + this.incremental + ", inputChanges=" + this.inputChanges + ", packageRClass=" + this.packageRClass + ", jarCreatorType=" + (Object)((Object)this.jarCreatorType) + ")";
        }

        public int hashCode() {
            String string = this.packageName;
            List<String> list = this.toIgnore;
            AndroidArtifacts.ArtifactType artifactType = this.outputType;
            File file = this.output;
            Set<File> set = this.input;
            int n = (((((string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (artifactType != null ? ((Object)((Object)artifactType)).hashCode() : 0)) * 31 + (file != null ? ((Object)file).hashCode() : 0)) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31;
            int n2 = this.incremental ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            SerializableFileChanges serializableFileChanges = this.inputChanges;
            int n3 = ((n + n2) * 31 + (serializableFileChanges != null ? serializableFileChanges.hashCode() : 0)) * 31;
            int n4 = this.packageRClass ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            JarCreatorType jarCreatorType = this.jarCreatorType;
            return (n3 + n4) * 31 + (jarCreatorType != null ? ((Object)((Object)jarCreatorType)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual((Object)this.packageName, (Object)params.packageName) || !Intrinsics.areEqual(this.toIgnore, params.toIgnore) || !Intrinsics.areEqual((Object)((Object)this.outputType), (Object)((Object)params.outputType)) || !Intrinsics.areEqual((Object)this.output, (Object)params.output) || !Intrinsics.areEqual(this.input, params.input) || this.incremental != params.incremental || !Intrinsics.areEqual((Object)this.inputChanges, (Object)params.inputChanges) || this.packageRClass != params.packageRClass || !Intrinsics.areEqual((Object)((Object)this.jarCreatorType), (Object)((Object)params.jarCreatorType))) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleLibraryClassesRunnable$Params$Companion;", "", "()V", "serialVersionUID", "", "gradle"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

