/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.attributes.VariantAttr;
import com.android.build.api.dsl.extension.BundleExtension;
import com.android.build.gradle.internal.tasks.ZipModuleTask;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/dsl/BundleExtensionImpl;", "Lcom/android/build/api/dsl/extension/BundleExtension;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "_modules", "", "", "Lorg/gradle/api/file/FileCollection;", "modules", "", "getModules", "()Ljava/util/Map;", "bundle", "", "moduleName", "projectPath", "variantName", "gradle"})
public class BundleExtensionImpl
implements BundleExtension {
    private final Map<String, FileCollection> _modules;
    private final Project project;

    @NotNull
    public final Map<String, FileCollection> getModules() {
        ImmutableMap immutableMap = ImmutableMap.copyOf(this._modules);
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"ImmutableMap.copyOf(_modules)");
        return (Map)immutableMap;
    }

    public void bundle(@NotNull String moduleName, @NotNull String projectPath, @NotNull String variantName) {
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        if (this._modules.containsKey(moduleName)) {
            throw (Throwable)new RuntimeException("Module name '" + moduleName + "' already used");
        }
        String configName = "bundle" + StringsKt.replace$default((String)projectPath, (char)':', (char)'_', (boolean)false, (int)4, null);
        Configuration config = (Configuration)this.project.getConfigurations().create(configName);
        DependencyHandler handler = this.project.getDependencies();
        ImmutableMap projectNotation = ImmutableMap.of((Object)"path", (Object)projectPath);
        handler.add(configName, (Object)handler.project((Map)projectNotation));
        ObjectFactory factory = this.project.getObjects();
        Configuration configuration = config;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"config");
        AttributeContainer attributes = configuration.getAttributes();
        attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)factory.named(Usage.class, "android-bundle"));
        attributes.attribute(VariantAttr.ATTRIBUTE, (Object)factory.named(VariantAttr.class, variantName));
        ProjectLayout projectLayout = this.project.getLayout();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectLayout, (String)"project.layout");
        Provider moduleOutput = projectLayout.getBuildDirectory().file("intermediates/" + moduleName + ".zip");
        TaskContainer taskContainer = this.project.getTasks();
        String string = "zip" + moduleName;
        Provider provider = moduleOutput;
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"moduleOutput");
        ZipModuleTask task = (ZipModuleTask)taskContainer.create(string, ZipModuleTask.class, (Action)new ZipModuleTask.ConfigAction((Provider<RegularFile>)provider, config));
        Map<String, FileCollection> map = this._modules;
        ConfigurableFileCollection configurableFileCollection = this.project.files(new Object[]{moduleOutput}).builtBy(new Object[]{task});
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"project.files(moduleOutput).builtBy(task)");
        ConfigurableFileCollection configurableFileCollection2 = configurableFileCollection;
        map.put(moduleName, (FileCollection)configurableFileCollection2);
    }

    public BundleExtensionImpl(@NotNull Project project) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        BundleExtensionImpl bundleExtensionImpl = this;
        bundleExtensionImpl._modules = map = (Map)new LinkedHashMap();
    }
}

