/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SourceStamp;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.splitters.ApkGenerationConfiguration;
import com.android.tools.build.bundletool.splitters.ModuleSplitter;
import com.android.tools.build.bundletool.splitters.VariantGenerator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import javax.inject.Inject;

public final class SplitApksGenerator {
    private final Version bundletoolVersion;
    private final Optional<SourceStamp> stampSource;
    private final VariantGenerator variantGenerator;
    private final AppBundle appBundle;

    @Inject
    public SplitApksGenerator(Version bundletoolVersion, Optional<SourceStamp> stampSource, VariantGenerator variantGenerator, AppBundle appBundle) {
        this.bundletoolVersion = bundletoolVersion;
        this.stampSource = stampSource;
        this.variantGenerator = variantGenerator;
        this.appBundle = appBundle;
    }

    public ImmutableList<ModuleSplit> generateSplits(ImmutableList<BundleModule> modules, ApkGenerationConfiguration apkGenerationConfiguration) {
        ImmutableSet<Targeting.VariantTargeting> variantTargetings = this.generateVariants(modules, apkGenerationConfiguration);
        return (ImmutableList)variantTargetings.stream().flatMap(variantTargeting -> this.generateSplitApks(modules, apkGenerationConfiguration, (Targeting.VariantTargeting)variantTargeting).stream()).collect(ImmutableList.toImmutableList());
    }

    private ImmutableSet<Targeting.VariantTargeting> generateVariants(ImmutableList<BundleModule> modules, ApkGenerationConfiguration apkGenerationConfiguration) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (BundleModule module : modules) {
            ImmutableSet<Targeting.VariantTargeting> splitApks = this.variantGenerator.generateVariants(module, apkGenerationConfiguration);
            builder.addAll(splitApks);
        }
        return TargetingUtils.generateAllVariantTargetings((ImmutableSet<Targeting.VariantTargeting>)builder.build());
    }

    private ImmutableList<ModuleSplit> generateSplitApks(ImmutableList<BundleModule> modules, ApkGenerationConfiguration apkGenerationConfiguration, Targeting.VariantTargeting variantTargeting) {
        ImmutableSet allModuleNames = (ImmutableSet)modules.stream().map(module -> module.getName().getName()).collect(ImmutableSet.toImmutableSet());
        ImmutableList.Builder splits = ImmutableList.builder();
        for (BundleModule module2 : modules) {
            ModuleSplitter moduleSplitter = ModuleSplitter.create(module2, this.bundletoolVersion, this.appBundle, apkGenerationConfiguration, variantTargeting, (ImmutableSet<String>)allModuleNames, this.stampSource.map(SourceStamp::getSource), SourceStamp.StampType.STAMP_TYPE_DISTRIBUTION_APK);
            splits.addAll(moduleSplitter.splitModule());
        }
        return splits.build();
    }
}

