/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.bundle.Commands;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ResultUtils {
    public static Commands.BuildApksResult readTableOfContents(Path apksPath) {
        try {
            if (Files.isDirectory(apksPath, new LinkOption[0])) {
                return ResultUtils.readTableOfContentFromApksDirectory(apksPath);
            }
            return ResultUtils.readTableOfContentFromApksArchive(apksPath);
        }
        catch (IOException e5) {
            throw new UncheckedIOException(String.format("Error while reading the table of contents file from '%s'.", apksPath), e5);
        }
    }

    private static Commands.BuildApksResult readTableOfContentFromApksArchive(Path apksArchivePath) throws IOException {
        try (ZipFile apksArchive = new ZipFile(apksArchivePath.toFile());){
            Commands.BuildApksResult buildApksResult = Commands.BuildApksResult.parseFrom(ZipUtils.asByteSource(apksArchive, new ZipEntry("toc.pb")).read());
            return buildApksResult;
        }
    }

    private static Commands.BuildApksResult readTableOfContentFromApksDirectory(Path apksDirectoryPath) throws IOException {
        return Commands.BuildApksResult.parseFrom(Files.readAllBytes(apksDirectoryPath.resolve("toc.pb")));
    }

    public static ImmutableList<Commands.Variant> splitApkVariants(Commands.BuildApksResult result) {
        return ResultUtils.splitApkVariants((ImmutableList<Commands.Variant>)ImmutableList.copyOf(result.getVariantList()));
    }

    public static ImmutableList<Commands.Variant> splitApkVariants(ImmutableList<Commands.Variant> variants) {
        return (ImmutableList)variants.stream().filter(ResultUtils::isSplitApkVariant).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Commands.Variant> instantApkVariants(Commands.BuildApksResult result) {
        return ResultUtils.instantApkVariants((ImmutableList<Commands.Variant>)ImmutableList.copyOf(result.getVariantList()));
    }

    public static ImmutableList<Commands.Variant> instantApkVariants(ImmutableList<Commands.Variant> variants) {
        return (ImmutableList)variants.stream().filter(ResultUtils::isInstantApkVariant).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Commands.Variant> standaloneApkVariants(Commands.BuildApksResult result) {
        return ResultUtils.standaloneApkVariants((ImmutableList<Commands.Variant>)ImmutableList.copyOf(result.getVariantList()));
    }

    public static ImmutableList<Commands.Variant> standaloneApkVariants(ImmutableList<Commands.Variant> variants) {
        return (ImmutableList)variants.stream().filter(ResultUtils::isStandaloneApkVariant).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Commands.Variant> apexApkVariants(Commands.BuildApksResult result) {
        return ResultUtils.apexApkVariants((ImmutableList<Commands.Variant>)ImmutableList.copyOf(result.getVariantList()));
    }

    public static ImmutableList<Commands.Variant> apexApkVariants(ImmutableList<Commands.Variant> variants) {
        return (ImmutableList)variants.stream().filter(ResultUtils::isApexApkVariant).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Commands.Variant> systemApkVariants(Commands.BuildApksResult result) {
        return ResultUtils.systemApkVariants((ImmutableList<Commands.Variant>)ImmutableList.copyOf(result.getVariantList()));
    }

    public static ImmutableList<Commands.Variant> systemApkVariants(ImmutableList<Commands.Variant> variants) {
        return (ImmutableList)variants.stream().filter(variant -> ResultUtils.isSystemApkVariant(variant)).collect(ImmutableList.toImmutableList());
    }

    public static boolean isSplitApkVariant(Commands.Variant variant) {
        return variant.getApkSetList().stream().flatMap(apkSet -> apkSet.getApkDescriptionList().stream()).allMatch(Commands.ApkDescription::hasSplitApkMetadata);
    }

    public static boolean isStandaloneApkVariant(Commands.Variant variant) {
        return variant.getApkSetList().stream().flatMap(apkSet -> apkSet.getApkDescriptionList().stream()).allMatch(Commands.ApkDescription::hasStandaloneApkMetadata);
    }

    public static boolean isApexApkVariant(Commands.Variant variant) {
        return variant.getApkSetList().stream().flatMap(apkSet -> apkSet.getApkDescriptionList().stream()).allMatch(Commands.ApkDescription::hasApexApkMetadata);
    }

    public static boolean isInstantApkVariant(Commands.Variant variant) {
        return variant.getApkSetList().stream().flatMap(apkSet -> apkSet.getApkDescriptionList().stream()).allMatch(Commands.ApkDescription::hasInstantApkMetadata);
    }

    public static boolean isSystemApkVariant(Commands.Variant variant) {
        return variant.getApkSetList().stream().flatMap(apkSet -> apkSet.getApkDescriptionList().stream()).anyMatch(Commands.ApkDescription::hasSystemApkMetadata);
    }

    public static ImmutableSet<String> getAllTargetedLanguages(Commands.BuildApksResult result) {
        return (ImmutableSet)Streams.concat((Stream[])new Stream[]{result.getAssetSliceSetList().stream().flatMap(assetSliceSet -> assetSliceSet.getApkDescriptionList().stream()), result.getVariantList().stream().flatMap(variant -> variant.getApkSetList().stream()).flatMap(apkSet -> apkSet.getApkDescriptionList().stream())}).flatMap(apkDescription -> apkDescription.getTargeting().getLanguageTargeting().getValueList().stream()).collect(ImmutableSet.toImmutableSet());
    }

    public static ImmutableSet<String> getAllBaseMasterSplitPaths(Commands.BuildApksResult toc) {
        return (ImmutableSet)ResultUtils.splitApkVariants(toc).stream().map(Commands.Variant::getApkSetList).flatMap(Collection::stream).filter(apkSet -> apkSet.getModuleMetadata().getName().equals(BundleModuleName.BASE_MODULE_NAME.getName())).map(Commands.ApkSet::getApkDescriptionList).flatMap(Collection::stream).filter(apkDescription -> apkDescription.getSplitApkMetadata().getIsMasterSplit()).map(Commands.ApkDescription::getPath).collect(ImmutableSet.toImmutableSet());
    }

    private ResultUtils() {
    }
}

