/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.utils.SparseArray;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;

public class FakeAndroidTarget
implements IAndroidTarget {
    private final Path mSdkLocation;
    private final SparseArray<Path> mPaths = new SparseArray();
    private final List<String> mBootClasspath = Lists.newArrayListWithExpectedSize((int)2);
    private final int mApiLevel;

    public FakeAndroidTarget(String sdkLocation, String target) {
        this.mSdkLocation = Paths.get(sdkLocation, new String[0]);
        this.mApiLevel = this.getApiLevel(target);
        if ("unstubbed".equals(target)) {
            this.mBootClasspath.add(this.mSdkLocation + "/out/target/common/obj/JAVA_LIBRARIES/framework_intermediates/classes.jar");
            this.mBootClasspath.add(this.mSdkLocation + "/out/target/common/obj/JAVA_LIBRARIES/core_intermediates/classes.jar");
            this.mPaths.put(1, (Object)this.mSdkLocation.resolve("prebuilts/sdk/current").resolve("android.jar"));
            this.mPaths.put(2, (Object)this.mSdkLocation.resolve("prebuilts/sdk/renderscript").resolve("framework.aidl"));
        } else {
            Path apiPrebuilts = "current".equals(target) ? this.mSdkLocation.resolve("prebuilts/sdk/current/") : this.mSdkLocation.resolve("prebuilts/sdk").resolve(Integer.toString(this.mApiLevel));
            this.mBootClasspath.add(apiPrebuilts + "android.jar");
            this.mPaths.put(1, (Object)apiPrebuilts.resolve("android.jar"));
            this.mPaths.put(2, (Object)apiPrebuilts.resolve("framework.aidl"));
        }
    }

    private int getApiLevel(String target) {
        if (target.startsWith("android-")) {
            return Integer.parseInt(target.substring("android-".length()));
        }
        return 99;
    }

    public Path getPath(int pathId) {
        return (Path)this.mPaths.get(pathId);
    }

    public BuildToolInfo getBuildToolInfo() {
        return null;
    }

    public List<String> getBootClasspath() {
        return this.mBootClasspath;
    }

    public String getLocation() {
        return this.mSdkLocation.toString();
    }

    public String getVendor() {
        return "android";
    }

    public String getName() {
        return "android";
    }

    public String getFullName() {
        return "android";
    }

    public String getClasspathName() {
        return "android";
    }

    public String getShortClasspathName() {
        return "android";
    }

    public AndroidVersion getVersion() {
        return new AndroidVersion(this.mApiLevel, null);
    }

    public String getVersionName() {
        return "Android API level " + this.mApiLevel;
    }

    public int getRevision() {
        return 1;
    }

    public boolean isPlatform() {
        return true;
    }

    public IAndroidTarget getParent() {
        return null;
    }

    public boolean hasRenderingLibrary() {
        return false;
    }

    public Path[] getSkins() {
        return new Path[0];
    }

    public Path getDefaultSkin() {
        return null;
    }

    public List<OptionalLibrary> getAdditionalLibraries() {
        return ImmutableList.of();
    }

    public List<OptionalLibrary> getOptionalLibraries() {
        return ImmutableList.of();
    }

    public String[] getPlatformLibraries() {
        return new String[0];
    }

    public String getProperty(String name) {
        return null;
    }

    public Map<String, String> getProperties() {
        return null;
    }

    public boolean canRunOn(IAndroidTarget target) {
        return false;
    }

    public String hashString() {
        return "android-" + this.mApiLevel;
    }

    public int compareTo(IAndroidTarget iAndroidTarget) {
        FakeAndroidTarget that = (FakeAndroidTarget)iAndroidTarget;
        return this.mSdkLocation.compareTo(that.mSdkLocation);
    }
}

