/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.builder.dexing.DexUtilsKt;
import com.android.utils.PathUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.jvm.functions.Function1;

final class DirDexArchive
implements DexArchive {
    private final Path rootDir;

    public DirDexArchive(Path rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    public Path getRootPath() {
        return this.rootDir;
    }

    @Override
    public void addFile(String relativePath, byte[] bytes, int offset, int end) throws IOException {
        Path finalPath = this.rootDir.resolve(relativePath);
        Files.createDirectories(finalPath.getParent(), new FileAttribute[0]);
        try (BufferedOutputStream os2 = new BufferedOutputStream(Files.newOutputStream(finalPath, new OpenOption[0]));){
            ((OutputStream)os2).write(bytes, offset, end);
            ((OutputStream)os2).flush();
        }
    }

    @Override
    public List<DexArchiveEntry> getSortedDexArchiveEntries() {
        List<Path> dexFiles = DexUtilsKt.getSortedFilesInDir(this.rootDir, (Function1<? super String, Boolean>)((Function1)relativePath -> relativePath.toLowerCase(Locale.ENGLISH).endsWith(".dex")));
        ArrayList<DexArchiveEntry> dexArchiveEntries = new ArrayList<DexArchiveEntry>(dexFiles.size());
        for (Path dexFile : dexFiles) {
            dexArchiveEntries.add(this.createEntry(dexFile));
        }
        return dexArchiveEntries;
    }

    @Override
    public void close() {
    }

    private DexArchiveEntry createEntry(Path dexFile) {
        byte[] content;
        try {
            content = Files.readAllBytes(dexFile);
        }
        catch (IOException e11) {
            throw new UncheckedIOException(e11);
        }
        Path relativePath = this.getRootPath().relativize(dexFile);
        return new DexArchiveEntry(content, PathUtils.toSystemIndependentPath((Path)relativePath), this);
    }
}

