/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.Comment;
import com.amihaiemil.eoyaml.ScalarComment;
import com.amihaiemil.eoyaml.YamlNode;

final class Concatenated
implements ScalarComment {
    private final Comment above;
    private final Comment inline;

    Concatenated(Comment above, Comment inline) {
        this.above = above;
        this.inline = inline;
    }

    @Override
    public YamlNode yamlNode() {
        return this.inline.yamlNode();
    }

    @Override
    public String value() {
        StringBuilder comment = new StringBuilder();
        String aboveValue = this.above.value();
        String inlineValue = this.inline.value();
        if (inlineValue.trim().isEmpty()) {
            comment.append(aboveValue);
        } else if (aboveValue.trim().isEmpty()) {
            comment.append(inlineValue);
        } else {
            comment.append(aboveValue).append(System.lineSeparator()).append(inlineValue);
        }
        return comment.toString();
    }

    @Override
    public Comment above() {
        return this.above;
    }

    @Override
    public Comment inline() {
        return this.inline;
    }
}

