/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kms.model.GetParametersForImportRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetParametersForImportRequestMarshaller
implements Marshaller<Request<GetParametersForImportRequest>, GetParametersForImportRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetParametersForImportRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetParametersForImportRequest> marshall(GetParametersForImportRequest getParametersForImportRequest) {
        if (getParametersForImportRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getParametersForImportRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.GetParametersForImport");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getParametersForImportRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(getParametersForImportRequest.getKeyId());
            }
            if (getParametersForImportRequest.getWrappingAlgorithm() != null) {
                jsonGenerator.writeFieldName("WrappingAlgorithm").writeValue(getParametersForImportRequest.getWrappingAlgorithm());
            }
            if (getParametersForImportRequest.getWrappingKeySpec() != null) {
                jsonGenerator.writeFieldName("WrappingKeySpec").writeValue(getParametersForImportRequest.getWrappingKeySpec());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

