/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisvideo.model.ChannelProtocol;
import com.amazonaws.services.kinesisvideo.model.transform.ResourceEndpointListItemMarshaller;
import java.io.Serializable;

public class ResourceEndpointListItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String protocol;
    private String resourceEndpoint;

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public ResourceEndpointListItem withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public ResourceEndpointListItem withProtocol(ChannelProtocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public void setResourceEndpoint(String resourceEndpoint) {
        this.resourceEndpoint = resourceEndpoint;
    }

    public String getResourceEndpoint() {
        return this.resourceEndpoint;
    }

    public ResourceEndpointListItem withResourceEndpoint(String resourceEndpoint) {
        this.setResourceEndpoint(resourceEndpoint);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getResourceEndpoint() != null) {
            sb.append("ResourceEndpoint: ").append(this.getResourceEndpoint());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceEndpointListItem)) {
            return false;
        }
        ResourceEndpointListItem other = (ResourceEndpointListItem)obj;
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getResourceEndpoint() == null ^ this.getResourceEndpoint() == null) {
            return false;
        }
        return other.getResourceEndpoint() == null || other.getResourceEndpoint().equals(this.getResourceEndpoint());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getResourceEndpoint() == null ? 0 : this.getResourceEndpoint().hashCode());
        return hashCode;
    }

    public ResourceEndpointListItem clone() {
        try {
            return (ResourceEndpointListItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceEndpointListItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

