/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisvideo.model.ConfigurationStatus;
import com.amazonaws.services.kinesisvideo.model.Format;
import com.amazonaws.services.kinesisvideo.model.ImageGenerationDestinationConfig;
import com.amazonaws.services.kinesisvideo.model.ImageSelectorType;
import com.amazonaws.services.kinesisvideo.model.transform.ImageGenerationConfigurationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ImageGenerationConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String status;
    private String imageSelectorType;
    private ImageGenerationDestinationConfig destinationConfig;
    private Integer samplingInterval;
    private String format;
    private Map<String, String> formatConfig;
    private Integer widthPixels;
    private Integer heightPixels;

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ImageGenerationConfiguration withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public ImageGenerationConfiguration withStatus(ConfigurationStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setImageSelectorType(String imageSelectorType) {
        this.imageSelectorType = imageSelectorType;
    }

    public String getImageSelectorType() {
        return this.imageSelectorType;
    }

    public ImageGenerationConfiguration withImageSelectorType(String imageSelectorType) {
        this.setImageSelectorType(imageSelectorType);
        return this;
    }

    public ImageGenerationConfiguration withImageSelectorType(ImageSelectorType imageSelectorType) {
        this.imageSelectorType = imageSelectorType.toString();
        return this;
    }

    public void setDestinationConfig(ImageGenerationDestinationConfig destinationConfig) {
        this.destinationConfig = destinationConfig;
    }

    public ImageGenerationDestinationConfig getDestinationConfig() {
        return this.destinationConfig;
    }

    public ImageGenerationConfiguration withDestinationConfig(ImageGenerationDestinationConfig destinationConfig) {
        this.setDestinationConfig(destinationConfig);
        return this;
    }

    public void setSamplingInterval(Integer samplingInterval) {
        this.samplingInterval = samplingInterval;
    }

    public Integer getSamplingInterval() {
        return this.samplingInterval;
    }

    public ImageGenerationConfiguration withSamplingInterval(Integer samplingInterval) {
        this.setSamplingInterval(samplingInterval);
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public ImageGenerationConfiguration withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public ImageGenerationConfiguration withFormat(Format format) {
        this.format = format.toString();
        return this;
    }

    public Map<String, String> getFormatConfig() {
        return this.formatConfig;
    }

    public void setFormatConfig(Map<String, String> formatConfig) {
        this.formatConfig = formatConfig;
    }

    public ImageGenerationConfiguration withFormatConfig(Map<String, String> formatConfig) {
        this.setFormatConfig(formatConfig);
        return this;
    }

    public ImageGenerationConfiguration addFormatConfigEntry(String key, String value) {
        if (null == this.formatConfig) {
            this.formatConfig = new HashMap<String, String>();
        }
        if (this.formatConfig.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.formatConfig.put(key, value);
        return this;
    }

    public ImageGenerationConfiguration clearFormatConfigEntries() {
        this.formatConfig = null;
        return this;
    }

    public void setWidthPixels(Integer widthPixels) {
        this.widthPixels = widthPixels;
    }

    public Integer getWidthPixels() {
        return this.widthPixels;
    }

    public ImageGenerationConfiguration withWidthPixels(Integer widthPixels) {
        this.setWidthPixels(widthPixels);
        return this;
    }

    public void setHeightPixels(Integer heightPixels) {
        this.heightPixels = heightPixels;
    }

    public Integer getHeightPixels() {
        return this.heightPixels;
    }

    public ImageGenerationConfiguration withHeightPixels(Integer heightPixels) {
        this.setHeightPixels(heightPixels);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getImageSelectorType() != null) {
            sb.append("ImageSelectorType: ").append(this.getImageSelectorType()).append(",");
        }
        if (this.getDestinationConfig() != null) {
            sb.append("DestinationConfig: ").append(this.getDestinationConfig()).append(",");
        }
        if (this.getSamplingInterval() != null) {
            sb.append("SamplingInterval: ").append(this.getSamplingInterval()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getFormatConfig() != null) {
            sb.append("FormatConfig: ").append(this.getFormatConfig()).append(",");
        }
        if (this.getWidthPixels() != null) {
            sb.append("WidthPixels: ").append(this.getWidthPixels()).append(",");
        }
        if (this.getHeightPixels() != null) {
            sb.append("HeightPixels: ").append(this.getHeightPixels());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageGenerationConfiguration)) {
            return false;
        }
        ImageGenerationConfiguration other = (ImageGenerationConfiguration)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getImageSelectorType() == null ^ this.getImageSelectorType() == null) {
            return false;
        }
        if (other.getImageSelectorType() != null && !other.getImageSelectorType().equals(this.getImageSelectorType())) {
            return false;
        }
        if (other.getDestinationConfig() == null ^ this.getDestinationConfig() == null) {
            return false;
        }
        if (other.getDestinationConfig() != null && !other.getDestinationConfig().equals(this.getDestinationConfig())) {
            return false;
        }
        if (other.getSamplingInterval() == null ^ this.getSamplingInterval() == null) {
            return false;
        }
        if (other.getSamplingInterval() != null && !other.getSamplingInterval().equals(this.getSamplingInterval())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getFormatConfig() == null ^ this.getFormatConfig() == null) {
            return false;
        }
        if (other.getFormatConfig() != null && !other.getFormatConfig().equals(this.getFormatConfig())) {
            return false;
        }
        if (other.getWidthPixels() == null ^ this.getWidthPixels() == null) {
            return false;
        }
        if (other.getWidthPixels() != null && !other.getWidthPixels().equals(this.getWidthPixels())) {
            return false;
        }
        if (other.getHeightPixels() == null ^ this.getHeightPixels() == null) {
            return false;
        }
        return other.getHeightPixels() == null || other.getHeightPixels().equals(this.getHeightPixels());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getImageSelectorType() == null ? 0 : this.getImageSelectorType().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationConfig() == null ? 0 : this.getDestinationConfig().hashCode());
        hashCode = 31 * hashCode + (this.getSamplingInterval() == null ? 0 : this.getSamplingInterval().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getFormatConfig() == null ? 0 : this.getFormatConfig().hashCode());
        hashCode = 31 * hashCode + (this.getWidthPixels() == null ? 0 : this.getWidthPixels().hashCode());
        hashCode = 31 * hashCode + (this.getHeightPixels() == null ? 0 : this.getHeightPixels().hashCode());
        return hashCode;
    }

    public ImageGenerationConfiguration clone() {
        try {
            return (ImageGenerationConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageGenerationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

