/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.ServerProcess;

public class ServerProcessJsonMarshaller {
    private static ServerProcessJsonMarshaller instance;

    public void marshall(ServerProcess serverProcess, StructuredJsonGenerator jsonGenerator) {
        if (serverProcess == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (serverProcess.getLaunchPath() != null) {
                jsonGenerator.writeFieldName("LaunchPath").writeValue(serverProcess.getLaunchPath());
            }
            if (serverProcess.getParameters() != null) {
                jsonGenerator.writeFieldName("Parameters").writeValue(serverProcess.getParameters());
            }
            if (serverProcess.getConcurrentExecutions() != null) {
                jsonGenerator.writeFieldName("ConcurrentExecutions").writeValue(serverProcess.getConcurrentExecutions().intValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ServerProcessJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ServerProcessJsonMarshaller();
        }
        return instance;
    }
}

