/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Purchase;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class PurchaseStaxUnmarshaller
implements Unmarshaller<Purchase, StaxUnmarshallerContext> {
    private static PurchaseStaxUnmarshaller instance;

    public Purchase unmarshall(StaxUnmarshallerContext context) throws Exception {
        Purchase purchase = new Purchase();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return purchase;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("currencyCode", targetDepth)) {
                    purchase.setCurrencyCode(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("duration", targetDepth)) {
                    purchase.setDuration(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hostIdSet", targetDepth)) {
                    purchase.withHostIdSet(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("hostIdSet/item", targetDepth)) {
                    purchase.withHostIdSet(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hostReservationId", targetDepth)) {
                    purchase.setHostReservationId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hourlyPrice", targetDepth)) {
                    purchase.setHourlyPrice(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceFamily", targetDepth)) {
                    purchase.setInstanceFamily(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("paymentOption", targetDepth)) {
                    purchase.setPaymentOption(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("upfrontPrice", targetDepth)) continue;
                purchase.setUpfrontPrice(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return purchase;
    }

    public static PurchaseStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PurchaseStaxUnmarshaller();
        }
        return instance;
    }
}

