/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeVpcEndpointConnectionsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeVpcEndpointConnectionsRequestMarshaller
implements Marshaller<Request<DescribeVpcEndpointConnectionsRequest>, DescribeVpcEndpointConnectionsRequest> {
    public Request<DescribeVpcEndpointConnectionsRequest> marshall(DescribeVpcEndpointConnectionsRequest describeVpcEndpointConnectionsRequest) {
        if (describeVpcEndpointConnectionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpcEndpointConnectionsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVpcEndpointConnections");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVpcEndpointConnectionsRequestFiltersList = (SdkInternalList)describeVpcEndpointConnectionsRequest.getFilters();
        if (!describeVpcEndpointConnectionsRequestFiltersList.isEmpty() || !describeVpcEndpointConnectionsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVpcEndpointConnectionsRequestFiltersListValue : describeVpcEndpointConnectionsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVpcEndpointConnectionsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVpcEndpointConnectionsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVpcEndpointConnectionsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVpcEndpointConnectionsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeVpcEndpointConnectionsRequest.getMaxResults()));
        }
        if (describeVpcEndpointConnectionsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeVpcEndpointConnectionsRequest.getNextToken()));
        }
        return request;
    }
}

