/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreditSpecification;
import com.amazonaws.services.ec2.model.ElasticGpuSpecificationResponse;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.LaunchTemplateBlockDeviceMapping;
import com.amazonaws.services.ec2.model.LaunchTemplateCpuOptions;
import com.amazonaws.services.ec2.model.LaunchTemplateIamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceMarketOptions;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.LaunchTemplatePlacement;
import com.amazonaws.services.ec2.model.LaunchTemplateTagSpecification;
import com.amazonaws.services.ec2.model.LaunchTemplatesMonitoring;
import com.amazonaws.services.ec2.model.ShutdownBehavior;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ResponseLaunchTemplateData
implements Serializable,
Cloneable {
    private String kernelId;
    private Boolean ebsOptimized;
    private LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile;
    private SdkInternalList<LaunchTemplateBlockDeviceMapping> blockDeviceMappings;
    private SdkInternalList<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces;
    private String imageId;
    private String instanceType;
    private String keyName;
    private LaunchTemplatesMonitoring monitoring;
    private LaunchTemplatePlacement placement;
    private String ramDiskId;
    private Boolean disableApiTermination;
    private String instanceInitiatedShutdownBehavior;
    private String userData;
    private SdkInternalList<LaunchTemplateTagSpecification> tagSpecifications;
    private SdkInternalList<ElasticGpuSpecificationResponse> elasticGpuSpecifications;
    private SdkInternalList<String> securityGroupIds;
    private SdkInternalList<String> securityGroups;
    private LaunchTemplateInstanceMarketOptions instanceMarketOptions;
    private CreditSpecification creditSpecification;
    private LaunchTemplateCpuOptions cpuOptions;

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public ResponseLaunchTemplateData withKernelId(String kernelId) {
        this.setKernelId(kernelId);
        return this;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public ResponseLaunchTemplateData withEbsOptimized(Boolean ebsOptimized) {
        this.setEbsOptimized(ebsOptimized);
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setIamInstanceProfile(LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile) {
        this.iamInstanceProfile = iamInstanceProfile;
    }

    public LaunchTemplateIamInstanceProfileSpecification getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public ResponseLaunchTemplateData withIamInstanceProfile(LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile) {
        this.setIamInstanceProfile(iamInstanceProfile);
        return this;
    }

    public List<LaunchTemplateBlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new SdkInternalList();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<LaunchTemplateBlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new SdkInternalList(blockDeviceMappings);
    }

    public ResponseLaunchTemplateData withBlockDeviceMappings(LaunchTemplateBlockDeviceMapping ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings((Collection<LaunchTemplateBlockDeviceMapping>)new SdkInternalList(blockDeviceMappings.length));
        }
        for (LaunchTemplateBlockDeviceMapping ele : blockDeviceMappings) {
            this.blockDeviceMappings.add((Object)ele);
        }
        return this;
    }

    public ResponseLaunchTemplateData withBlockDeviceMappings(Collection<LaunchTemplateBlockDeviceMapping> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public List<LaunchTemplateInstanceNetworkInterfaceSpecification> getNetworkInterfaces() {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new SdkInternalList();
        }
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces) {
        if (networkInterfaces == null) {
            this.networkInterfaces = null;
            return;
        }
        this.networkInterfaces = new SdkInternalList(networkInterfaces);
    }

    public ResponseLaunchTemplateData withNetworkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecification ... networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.setNetworkInterfaces((Collection<LaunchTemplateInstanceNetworkInterfaceSpecification>)new SdkInternalList(networkInterfaces.length));
        }
        for (LaunchTemplateInstanceNetworkInterfaceSpecification ele : networkInterfaces) {
            this.networkInterfaces.add((Object)ele);
        }
        return this;
    }

    public ResponseLaunchTemplateData withNetworkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces) {
        this.setNetworkInterfaces(networkInterfaces);
        return this;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public ResponseLaunchTemplateData withImageId(String imageId) {
        this.setImageId(imageId);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public ResponseLaunchTemplateData withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public ResponseLaunchTemplateData withInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public ResponseLaunchTemplateData withKeyName(String keyName) {
        this.setKeyName(keyName);
        return this;
    }

    public void setMonitoring(LaunchTemplatesMonitoring monitoring) {
        this.monitoring = monitoring;
    }

    public LaunchTemplatesMonitoring getMonitoring() {
        return this.monitoring;
    }

    public ResponseLaunchTemplateData withMonitoring(LaunchTemplatesMonitoring monitoring) {
        this.setMonitoring(monitoring);
        return this;
    }

    public void setPlacement(LaunchTemplatePlacement placement) {
        this.placement = placement;
    }

    public LaunchTemplatePlacement getPlacement() {
        return this.placement;
    }

    public ResponseLaunchTemplateData withPlacement(LaunchTemplatePlacement placement) {
        this.setPlacement(placement);
        return this;
    }

    public void setRamDiskId(String ramDiskId) {
        this.ramDiskId = ramDiskId;
    }

    public String getRamDiskId() {
        return this.ramDiskId;
    }

    public ResponseLaunchTemplateData withRamDiskId(String ramDiskId) {
        this.setRamDiskId(ramDiskId);
        return this;
    }

    public void setDisableApiTermination(Boolean disableApiTermination) {
        this.disableApiTermination = disableApiTermination;
    }

    public Boolean getDisableApiTermination() {
        return this.disableApiTermination;
    }

    public ResponseLaunchTemplateData withDisableApiTermination(Boolean disableApiTermination) {
        this.setDisableApiTermination(disableApiTermination);
        return this;
    }

    public Boolean isDisableApiTermination() {
        return this.disableApiTermination;
    }

    public void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
    }

    public String getInstanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public ResponseLaunchTemplateData withInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.setInstanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior);
        return this;
    }

    public ResponseLaunchTemplateData withInstanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior.toString();
        return this;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public String getUserData() {
        return this.userData;
    }

    public ResponseLaunchTemplateData withUserData(String userData) {
        this.setUserData(userData);
        return this;
    }

    public List<LaunchTemplateTagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<LaunchTemplateTagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public ResponseLaunchTemplateData withTagSpecifications(LaunchTemplateTagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<LaunchTemplateTagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (LaunchTemplateTagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public ResponseLaunchTemplateData withTagSpecifications(Collection<LaunchTemplateTagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public List<ElasticGpuSpecificationResponse> getElasticGpuSpecifications() {
        if (this.elasticGpuSpecifications == null) {
            this.elasticGpuSpecifications = new SdkInternalList();
        }
        return this.elasticGpuSpecifications;
    }

    public void setElasticGpuSpecifications(Collection<ElasticGpuSpecificationResponse> elasticGpuSpecifications) {
        if (elasticGpuSpecifications == null) {
            this.elasticGpuSpecifications = null;
            return;
        }
        this.elasticGpuSpecifications = new SdkInternalList(elasticGpuSpecifications);
    }

    public ResponseLaunchTemplateData withElasticGpuSpecifications(ElasticGpuSpecificationResponse ... elasticGpuSpecifications) {
        if (this.elasticGpuSpecifications == null) {
            this.setElasticGpuSpecifications((Collection<ElasticGpuSpecificationResponse>)new SdkInternalList(elasticGpuSpecifications.length));
        }
        for (ElasticGpuSpecificationResponse ele : elasticGpuSpecifications) {
            this.elasticGpuSpecifications.add((Object)ele);
        }
        return this;
    }

    public ResponseLaunchTemplateData withElasticGpuSpecifications(Collection<ElasticGpuSpecificationResponse> elasticGpuSpecifications) {
        this.setElasticGpuSpecifications(elasticGpuSpecifications);
        return this;
    }

    public List<String> getSecurityGroupIds() {
        if (this.securityGroupIds == null) {
            this.securityGroupIds = new SdkInternalList();
        }
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new SdkInternalList(securityGroupIds);
    }

    public ResponseLaunchTemplateData withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds((Collection<String>)new SdkInternalList(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add((Object)ele);
        }
        return this;
    }

    public ResponseLaunchTemplateData withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    public List<String> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new SdkInternalList();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new SdkInternalList(securityGroups);
    }

    public ResponseLaunchTemplateData withSecurityGroups(String ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups((Collection<String>)new SdkInternalList(securityGroups.length));
        }
        for (String ele : securityGroups) {
            this.securityGroups.add((Object)ele);
        }
        return this;
    }

    public ResponseLaunchTemplateData withSecurityGroups(Collection<String> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setInstanceMarketOptions(LaunchTemplateInstanceMarketOptions instanceMarketOptions) {
        this.instanceMarketOptions = instanceMarketOptions;
    }

    public LaunchTemplateInstanceMarketOptions getInstanceMarketOptions() {
        return this.instanceMarketOptions;
    }

    public ResponseLaunchTemplateData withInstanceMarketOptions(LaunchTemplateInstanceMarketOptions instanceMarketOptions) {
        this.setInstanceMarketOptions(instanceMarketOptions);
        return this;
    }

    public void setCreditSpecification(CreditSpecification creditSpecification) {
        this.creditSpecification = creditSpecification;
    }

    public CreditSpecification getCreditSpecification() {
        return this.creditSpecification;
    }

    public ResponseLaunchTemplateData withCreditSpecification(CreditSpecification creditSpecification) {
        this.setCreditSpecification(creditSpecification);
        return this;
    }

    public void setCpuOptions(LaunchTemplateCpuOptions cpuOptions) {
        this.cpuOptions = cpuOptions;
    }

    public LaunchTemplateCpuOptions getCpuOptions() {
        return this.cpuOptions;
    }

    public ResponseLaunchTemplateData withCpuOptions(LaunchTemplateCpuOptions cpuOptions) {
        this.setCpuOptions(cpuOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKernelId() != null) {
            sb.append("KernelId: ").append(this.getKernelId()).append(",");
        }
        if (this.getEbsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.getEbsOptimized()).append(",");
        }
        if (this.getIamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(this.getIamInstanceProfile()).append(",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.getBlockDeviceMappings()).append(",");
        }
        if (this.getNetworkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.getNetworkInterfaces()).append(",");
        }
        if (this.getImageId() != null) {
            sb.append("ImageId: ").append(this.getImageId()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getKeyName() != null) {
            sb.append("KeyName: ").append(this.getKeyName()).append(",");
        }
        if (this.getMonitoring() != null) {
            sb.append("Monitoring: ").append(this.getMonitoring()).append(",");
        }
        if (this.getPlacement() != null) {
            sb.append("Placement: ").append(this.getPlacement()).append(",");
        }
        if (this.getRamDiskId() != null) {
            sb.append("RamDiskId: ").append(this.getRamDiskId()).append(",");
        }
        if (this.getDisableApiTermination() != null) {
            sb.append("DisableApiTermination: ").append(this.getDisableApiTermination()).append(",");
        }
        if (this.getInstanceInitiatedShutdownBehavior() != null) {
            sb.append("InstanceInitiatedShutdownBehavior: ").append(this.getInstanceInitiatedShutdownBehavior()).append(",");
        }
        if (this.getUserData() != null) {
            sb.append("UserData: ").append(this.getUserData()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getElasticGpuSpecifications() != null) {
            sb.append("ElasticGpuSpecifications: ").append(this.getElasticGpuSpecifications()).append(",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.getSecurityGroupIds()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getInstanceMarketOptions() != null) {
            sb.append("InstanceMarketOptions: ").append(this.getInstanceMarketOptions()).append(",");
        }
        if (this.getCreditSpecification() != null) {
            sb.append("CreditSpecification: ").append(this.getCreditSpecification()).append(",");
        }
        if (this.getCpuOptions() != null) {
            sb.append("CpuOptions: ").append(this.getCpuOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseLaunchTemplateData)) {
            return false;
        }
        ResponseLaunchTemplateData other = (ResponseLaunchTemplateData)obj;
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getEbsOptimized() == null ^ this.getEbsOptimized() == null) {
            return false;
        }
        if (other.getEbsOptimized() != null && !other.getEbsOptimized().equals(this.getEbsOptimized())) {
            return false;
        }
        if (other.getIamInstanceProfile() == null ^ this.getIamInstanceProfile() == null) {
            return false;
        }
        if (other.getIamInstanceProfile() != null && !other.getIamInstanceProfile().equals(this.getIamInstanceProfile())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getNetworkInterfaces() == null ^ this.getNetworkInterfaces() == null) {
            return false;
        }
        if (other.getNetworkInterfaces() != null && !other.getNetworkInterfaces().equals(this.getNetworkInterfaces())) {
            return false;
        }
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getMonitoring() == null ^ this.getMonitoring() == null) {
            return false;
        }
        if (other.getMonitoring() != null && !other.getMonitoring().equals(this.getMonitoring())) {
            return false;
        }
        if (other.getPlacement() == null ^ this.getPlacement() == null) {
            return false;
        }
        if (other.getPlacement() != null && !other.getPlacement().equals(this.getPlacement())) {
            return false;
        }
        if (other.getRamDiskId() == null ^ this.getRamDiskId() == null) {
            return false;
        }
        if (other.getRamDiskId() != null && !other.getRamDiskId().equals(this.getRamDiskId())) {
            return false;
        }
        if (other.getDisableApiTermination() == null ^ this.getDisableApiTermination() == null) {
            return false;
        }
        if (other.getDisableApiTermination() != null && !other.getDisableApiTermination().equals(this.getDisableApiTermination())) {
            return false;
        }
        if (other.getInstanceInitiatedShutdownBehavior() == null ^ this.getInstanceInitiatedShutdownBehavior() == null) {
            return false;
        }
        if (other.getInstanceInitiatedShutdownBehavior() != null && !other.getInstanceInitiatedShutdownBehavior().equals(this.getInstanceInitiatedShutdownBehavior())) {
            return false;
        }
        if (other.getUserData() == null ^ this.getUserData() == null) {
            return false;
        }
        if (other.getUserData() != null && !other.getUserData().equals(this.getUserData())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getElasticGpuSpecifications() == null ^ this.getElasticGpuSpecifications() == null) {
            return false;
        }
        if (other.getElasticGpuSpecifications() != null && !other.getElasticGpuSpecifications().equals(this.getElasticGpuSpecifications())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getInstanceMarketOptions() == null ^ this.getInstanceMarketOptions() == null) {
            return false;
        }
        if (other.getInstanceMarketOptions() != null && !other.getInstanceMarketOptions().equals(this.getInstanceMarketOptions())) {
            return false;
        }
        if (other.getCreditSpecification() == null ^ this.getCreditSpecification() == null) {
            return false;
        }
        if (other.getCreditSpecification() != null && !other.getCreditSpecification().equals(this.getCreditSpecification())) {
            return false;
        }
        if (other.getCpuOptions() == null ^ this.getCpuOptions() == null) {
            return false;
        }
        return other.getCpuOptions() == null || other.getCpuOptions().equals(this.getCpuOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getEbsOptimized() == null ? 0 : this.getEbsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.getIamInstanceProfile() == null ? 0 : this.getIamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaces() == null ? 0 : this.getNetworkInterfaces().hashCode());
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoring() == null ? 0 : this.getMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.getPlacement() == null ? 0 : this.getPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getRamDiskId() == null ? 0 : this.getRamDiskId().hashCode());
        hashCode = 31 * hashCode + (this.getDisableApiTermination() == null ? 0 : this.getDisableApiTermination().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceInitiatedShutdownBehavior() == null ? 0 : this.getInstanceInitiatedShutdownBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getUserData() == null ? 0 : this.getUserData().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getElasticGpuSpecifications() == null ? 0 : this.getElasticGpuSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceMarketOptions() == null ? 0 : this.getInstanceMarketOptions().hashCode());
        hashCode = 31 * hashCode + (this.getCreditSpecification() == null ? 0 : this.getCreditSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getCpuOptions() == null ? 0 : this.getCpuOptions().hashCode());
        return hashCode;
    }

    public ResponseLaunchTemplateData clone() {
        try {
            return (ResponseLaunchTemplateData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

