/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Storage;
import com.amazonaws.services.ec2.model.transform.BundleInstanceRequestMarshaller;
import java.io.Serializable;

public class BundleInstanceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<BundleInstanceRequest> {
    private String instanceId;
    private Storage storage;

    public BundleInstanceRequest() {
    }

    public BundleInstanceRequest(String instanceId, Storage storage) {
        this.setInstanceId(instanceId);
        this.setStorage(storage);
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public BundleInstanceRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public BundleInstanceRequest withStorage(Storage storage) {
        this.setStorage(storage);
        return this;
    }

    @Override
    public Request<BundleInstanceRequest> getDryRunRequest() {
        Request<BundleInstanceRequest> request = new BundleInstanceRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getStorage() != null) {
            sb.append("Storage: ").append(this.getStorage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleInstanceRequest)) {
            return false;
        }
        BundleInstanceRequest other = (BundleInstanceRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getStorage() == null ^ this.getStorage() == null) {
            return false;
        }
        return other.getStorage() == null || other.getStorage().equals(this.getStorage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getStorage() == null ? 0 : this.getStorage().hashCode());
        return hashCode;
    }

    public BundleInstanceRequest clone() {
        return (BundleInstanceRequest)super.clone();
    }
}

