/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.transform.NewPrivateVirtualInterfaceJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreatePrivateVirtualInterfaceRequestMarshaller
implements Marshaller<Request<CreatePrivateVirtualInterfaceRequest>, CreatePrivateVirtualInterfaceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreatePrivateVirtualInterfaceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreatePrivateVirtualInterfaceRequest> marshall(CreatePrivateVirtualInterfaceRequest createPrivateVirtualInterfaceRequest) {
        if (createPrivateVirtualInterfaceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPrivateVirtualInterfaceRequest, "AmazonDirectConnect");
        request.addHeader("X-Amz-Target", "OvertureService.CreatePrivateVirtualInterface");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createPrivateVirtualInterfaceRequest.getConnectionId() != null) {
                jsonGenerator.writeFieldName("connectionId").writeValue(createPrivateVirtualInterfaceRequest.getConnectionId());
            }
            if (createPrivateVirtualInterfaceRequest.getNewPrivateVirtualInterface() != null) {
                jsonGenerator.writeFieldName("newPrivateVirtualInterface");
                NewPrivateVirtualInterfaceJsonMarshaller.getInstance().marshall(createPrivateVirtualInterfaceRequest.getNewPrivateVirtualInterface(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

