/*
 * Copyright 2011-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not
 * use this file except in compliance with the License. A copy of the License is
 * located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.cognitoidp.model;

import java.io.Serializable;
import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * The request to respond to an authentication challenge.
 * </p>
 */
public class RespondToAuthChallengeRequest extends AmazonWebServiceRequest
        implements Serializable, Cloneable {

    /**
     * <p>
     * The client ID.
     * </p>
     */
    private String clientId;
    /**
     * <p>
     * The name of the challenge.
     * </p>
     */
    private String challengeName;
    /**
     * <p>
     * The session.
     * </p>
     */
    private String session;
    /**
     * <p>
     * The responses to the authentication challenge.
     * </p>
     */
    private java.util.Map<String, String> challengeResponses;

    /**
     * <p>
     * The client ID.
     * </p>
     * 
     * @param clientId
     *        The client ID.
     */

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    /**
     * <p>
     * The client ID.
     * </p>
     * 
     * @return The client ID.
     */

    public String getClientId() {
        return this.clientId;
    }

    /**
     * <p>
     * The client ID.
     * </p>
     * 
     * @param clientId
     *        The client ID.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public RespondToAuthChallengeRequest withClientId(String clientId) {
        setClientId(clientId);
        return this;
    }

    /**
     * <p>
     * The name of the challenge.
     * </p>
     * 
     * @param challengeName
     *        The name of the challenge.
     * @see ChallengeNameType
     */

    public void setChallengeName(String challengeName) {
        this.challengeName = challengeName;
    }

    /**
     * <p>
     * The name of the challenge.
     * </p>
     * 
     * @return The name of the challenge.
     * @see ChallengeNameType
     */

    public String getChallengeName() {
        return this.challengeName;
    }

    /**
     * <p>
     * The name of the challenge.
     * </p>
     * 
     * @param challengeName
     *        The name of the challenge.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see ChallengeNameType
     */

    public RespondToAuthChallengeRequest withChallengeName(String challengeName) {
        setChallengeName(challengeName);
        return this;
    }

    /**
     * <p>
     * The name of the challenge.
     * </p>
     * 
     * @param challengeName
     *        The name of the challenge.
     * @see ChallengeNameType
     */

    public void setChallengeName(ChallengeNameType challengeName) {
        this.challengeName = challengeName.toString();
    }

    /**
     * <p>
     * The name of the challenge.
     * </p>
     * 
     * @param challengeName
     *        The name of the challenge.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see ChallengeNameType
     */

    public RespondToAuthChallengeRequest withChallengeName(
            ChallengeNameType challengeName) {
        setChallengeName(challengeName);
        return this;
    }

    /**
     * <p>
     * The session.
     * </p>
     * 
     * @param session
     *        The session.
     */

    public void setSession(String session) {
        this.session = session;
    }

    /**
     * <p>
     * The session.
     * </p>
     * 
     * @return The session.
     */

    public String getSession() {
        return this.session;
    }

    /**
     * <p>
     * The session.
     * </p>
     * 
     * @param session
     *        The session.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public RespondToAuthChallengeRequest withSession(String session) {
        setSession(session);
        return this;
    }

    /**
     * <p>
     * The responses to the authentication challenge.
     * </p>
     * 
     * @return The responses to the authentication challenge.
     */

    public java.util.Map<String, String> getChallengeResponses() {
        return challengeResponses;
    }

    /**
     * <p>
     * The responses to the authentication challenge.
     * </p>
     * 
     * @param challengeResponses
     *        The responses to the authentication challenge.
     */

    public void setChallengeResponses(
            java.util.Map<String, String> challengeResponses) {
        this.challengeResponses = challengeResponses;
    }

    /**
     * <p>
     * The responses to the authentication challenge.
     * </p>
     * 
     * @param challengeResponses
     *        The responses to the authentication challenge.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public RespondToAuthChallengeRequest withChallengeResponses(
            java.util.Map<String, String> challengeResponses) {
        setChallengeResponses(challengeResponses);
        return this;
    }

    public RespondToAuthChallengeRequest addChallengeResponsesEntry(String key,
            String value) {
        if (null == this.challengeResponses) {
            this.challengeResponses = new java.util.HashMap<String, String>();
        }
        if (this.challengeResponses.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys ("
                    + key.toString() + ") are provided.");
        this.challengeResponses.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into ChallengeResponses. &lt;p> Returns a
     * reference to this object so that method calls can be chained together.
     */

    public RespondToAuthChallengeRequest clearChallengeResponsesEntries() {
        this.challengeResponses = null;
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getClientId() != null)
            sb.append("ClientId: " + getClientId() + ",");
        if (getChallengeName() != null)
            sb.append("ChallengeName: " + getChallengeName() + ",");
        if (getSession() != null)
            sb.append("Session: " + getSession() + ",");
        if (getChallengeResponses() != null)
            sb.append("ChallengeResponses: " + getChallengeResponses());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RespondToAuthChallengeRequest == false)
            return false;
        RespondToAuthChallengeRequest other = (RespondToAuthChallengeRequest) obj;
        if (other.getClientId() == null ^ this.getClientId() == null)
            return false;
        if (other.getClientId() != null
                && other.getClientId().equals(this.getClientId()) == false)
            return false;
        if (other.getChallengeName() == null ^ this.getChallengeName() == null)
            return false;
        if (other.getChallengeName() != null
                && other.getChallengeName().equals(this.getChallengeName()) == false)
            return false;
        if (other.getSession() == null ^ this.getSession() == null)
            return false;
        if (other.getSession() != null
                && other.getSession().equals(this.getSession()) == false)
            return false;
        if (other.getChallengeResponses() == null
                ^ this.getChallengeResponses() == null)
            return false;
        if (other.getChallengeResponses() != null
                && other.getChallengeResponses().equals(
                        this.getChallengeResponses()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode
                + ((getClientId() == null) ? 0 : getClientId().hashCode());
        hashCode = prime
                * hashCode
                + ((getChallengeName() == null) ? 0 : getChallengeName()
                        .hashCode());
        hashCode = prime * hashCode
                + ((getSession() == null) ? 0 : getSession().hashCode());
        hashCode = prime
                * hashCode
                + ((getChallengeResponses() == null) ? 0
                        : getChallengeResponses().hashCode());
        return hashCode;
    }

    @Override
    public RespondToAuthChallengeRequest clone() {
        return (RespondToAuthChallengeRequest) super.clone();
    }
}
