/**! hopscotch - v0.2.0
*
* Copyright 2014 LinkedIn Corp. All rights reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
!function(context,namespace){var Hopscotch,HopscotchBubble,HopscotchCalloutManager,HopscotchI18N,customI18N,customRenderer,customEscape,utils,callbacks,helpers,winLoadHandler,defaultOpts,templateToUse="bubble_default",Sizzle=window.Sizzle||null,winHopscotch=context[namespace],undefinedStr="undefined",waitingToStart=!1,hasJquery=typeof window.jQuery!==undefinedStr,hasSessionStorage=!1,document=window.document;try{hasSessionStorage=typeof window.sessionStorage!==undefinedStr}catch(err){}defaultOpts={smoothScroll:!0,scrollDuration:1e3,scrollTopMargin:200,showCloseButton:!0,showPrevButton:!1,showNextButton:!0,bubbleWidth:280,bubblePadding:15,arrowWidth:20,skipIfNoElement:!0,cookieName:"hopscotch.tour.state"},winHopscotch||(Array.isArray||(Array.isArray=function(a){return"[object Array]"===Object.prototype.toString.call(a)}),winLoadHandler=function(){waitingToStart&&winHopscotch.startTour()},utils={addClass:function(a,b){var c,d,e,f;if(a.className){for(d=b.split(/\s+/),c=" "+a.className+" ",e=0,f=d.length;f>e;++e)c.indexOf(" "+d[e]+" ")<0&&(c+=d[e]+" ");a.className=c.replace(/^\s+|\s+$/g,"")}else a.className=b},removeClass:function(a,b){var c,d,e,f;for(d=b.split(/\s+/),c=" "+a.className+" ",e=0,f=d.length;f>e;++e)c=c.replace(" "+d[e]+" "," ");a.className=c.replace(/^\s+|\s+$/g,"")},hasClass:function(a,b){var c;return a.className?(c=" "+a.className+" ",-1!==c.indexOf(" "+b+" ")):!1},getPixelValue:function(a){var b=typeof a;return"number"===b?a:"string"===b?parseInt(a,10):0},valOrDefault:function(a,b){return typeof a!==undefinedStr?a:b},invokeCallbackArrayHelper:function(a){var b;return Array.isArray(a)&&(b=helpers[a[0]],"function"==typeof b)?b.apply(this,a.slice(1)):void 0},invokeCallbackArray:function(a){var b,c;if(Array.isArray(a)){if("string"==typeof a[0])return utils.invokeCallbackArrayHelper(a);for(b=0,c=a.length;c>b;++b)utils.invokeCallback(a[b])}},invokeCallback:function(a){return"function"==typeof a?a():"string"==typeof a&&helpers[a]?helpers[a]():utils.invokeCallbackArray(a)},invokeEventCallbacks:function(a,b){var c,d,e=callbacks[a];if(b)return this.invokeCallback(b);for(c=0,d=e.length;d>c;++c)this.invokeCallback(e[c].cb)},getScrollTop:function(){var a;return a=typeof window.pageYOffset!==undefinedStr?window.pageYOffset:document.documentElement.scrollTop},getScrollLeft:function(){var a;return a=typeof window.pageXOffset!==undefinedStr?window.pageXOffset:document.documentElement.scrollLeft},getWindowHeight:function(){return window.innerHeight||document.documentElement.clientHeight},getWindowWidth:function(){return window.innerWidth||document.documentElement.clientWidth},addEvtListener:function(a,b,c){return a.addEventListener?a.addEventListener(b,c,!1):a.attachEvent("on"+b,c)},removeEvtListener:function(a,b,c){return a.removeEventListener?a.removeEventListener(b,c,!1):a.detachEvent("on"+b,c)},documentIsReady:function(){return"complete"===document.readyState||"interactive"===document.readyState},evtPreventDefault:function(a){a.preventDefault?a.preventDefault():event&&(event.returnValue=!1)},extend:function(a,b){var c;for(c in b)b.hasOwnProperty(c)&&(a[c]=b[c])},getStepTargetHelper:function(a){var b=document.getElementById(a);return b?b:document.querySelector?document.querySelector(a):hasJquery?(b=jQuery(a),b.length?b[0]:null):Sizzle?(b=new Sizzle(a),b.length?b[0]:null):/^#[a-zA-Z][\w-_:.]*$/.test(a)?document.getElementById(a.substring(1)):null},getStepTarget:function(a){var b;if(!a||!a.target)return null;if("string"==typeof a.target)return a.target=utils.getStepTargetHelper(a.target),a.target;if(Array.isArray(a.target)){var c,d;for(c=0,d=a.target.length;d>c;c++)if("string"==typeof a.target[c]&&(b=utils.getStepTargetHelper(a.target[c])))return a.target=b,b;return null}return a.target},getI18NString:function(a){return customI18N[a]||HopscotchI18N[a]},setState:function(a,b,c){var d,e="";hasSessionStorage?sessionStorage.setItem(a,b):(c&&(d=new Date,d.setTime(d.getTime()+24*c*60*60*1e3),e="; expires="+d.toGMTString()),document.cookie=a+"="+b+e+"; path=/")},getState:function(a){var b,c,d,e=a+"=",f=document.cookie.split(";");if(hasSessionStorage)d=sessionStorage.getItem(a);else for(b=0;b<f.length;b++){for(c=f[b];" "===c.charAt(0);)c=c.substring(1,c.length);if(0===c.indexOf(e)){d=c.substring(e.length,c.length);break}}return d},clearState:function(a){hasSessionStorage?sessionStorage.removeItem(a):this.setState(a,"",-1)}},utils.addEvtListener(window,"load",winLoadHandler),callbacks={next:[],prev:[],start:[],end:[],show:[],error:[],close:[]},helpers={},HopscotchI18N={stepNums:null,nextBtn:"Next",prevBtn:"Back",doneBtn:"Done",skipBtn:"Skip",closeTooltip:"Close"},customI18N={},HopscotchBubble=function(a){this.init(a)},HopscotchBubble.prototype={isShowing:!1,currStep:void 0,setPosition:function(a){var b,c,d,e,f,g,h=utils.getStepTarget(a),i=this.element,j=this.arrowEl;if(c=i.offsetWidth,b=i.offsetHeight,utils.removeClass(i,"fade-in-down fade-in-up fade-in-left fade-in-right"),!a.placement&&a.orientation&&(a.placement=a.orientation),d=h.getBoundingClientRect(),"top"===a.placement)e=d.top-b-this.opt.arrowWidth,f=d.left;else if("bottom"===a.placement)e=d.bottom+this.opt.arrowWidth,f=d.left;else if("left"===a.placement)e=d.top,f=d.left-c-this.opt.arrowWidth;else{if("right"!==a.placement)throw"Bubble placement failed because step.placement is invalid or undefined!";e=d.top,f=d.right+this.opt.arrowWidth}g="center"!==a.arrowOffset?utils.getPixelValue(a.arrowOffset):a.arrowOffset,g?"top"===a.placement||"bottom"===a.placement?(j.style.top="",j.style.left="center"===g?Math.floor(c/2-j.offsetWidth/2)+"px":g+"px"):("left"===a.placement||"right"===a.placement)&&(j.style.left="",j.style.top="center"===g?Math.floor(b/2-j.offsetHeight/2)+"px":g+"px"):(j.style.top="",j.style.left=""),"center"===a.xOffset?f=d.left+h.offsetWidth/2-c/2:f+=utils.getPixelValue(a.xOffset),"center"===a.yOffset?e=d.top+h.offsetHeight/2-b/2:e+=utils.getPixelValue(a.yOffset),a.fixedElement||(e+=utils.getScrollTop(),f+=utils.getScrollLeft()),i.style.position=a.fixedElement?"fixed":"absolute",i.style.top=e+"px",i.style.left=f+"px"},render:function(a,b,c){var d,e,f,g,h,j,k,l,m=this.element;if(a?this.currStep=a:this.currStep&&(a=this.currStep),this.opt.isTourBubble?(g=winHopscotch.getCurrTour(),g&&(e=g.customData,d=g.customRenderer,f=g.unsafe,Array.isArray(g.steps)&&(h=g.steps.length,k=b===h-1))):(e=a.customData,d=a.customRenderer,f=a.unsafe),j=utils.getI18NString(k?"doneBtn":a.showSkip?"skipBtn":"nextBtn"),!a.placement&&a.orientation&&(a.placement=a.orientation),this.placement=a.placement,l={i18n:{prevBtn:utils.getI18NString("prevBtn"),nextBtn:j,closeTooltip:utils.getI18NString("closeTooltip"),stepNum:this._getStepI18nNum(b)},buttons:{showPrev:utils.valOrDefault(a.showPrevButton,this.opt.showPrevButton)&&b>0,showNext:utils.valOrDefault(a.showNextButton,this.opt.showNextButton),showCTA:utils.valOrDefault(a.showCTAButton&&a.ctaLabel,!1),ctaLabel:a.ctaLabel,showClose:utils.valOrDefault(this.opt.showCloseButton,!0)},step:{num:b,isLast:utils.valOrDefault(k,!1),title:a.title||"",content:a.content||"",placement:a.placement,padding:utils.valOrDefault(a.padding,this.opt.bubblePadding),width:utils.getPixelValue(a.width)||this.opt.bubbleWidth,customData:a.customData||{}},tour:{isTour:this.opt.isTourBubble,numSteps:h,unsafe:utils.valOrDefault(f,!1),customData:e||{}}},"function"==typeof d)m.innerHTML=d(l);else if("string"==typeof d){if(!hopscotch.templates||"function"!=typeof hopscotch.templates[d])throw'Bubble rendering failed - template "'+d+'" is not a function.';m.innerHTML=hopscotch.templates[d](l)}else if(customRenderer)m.innerHTML=customRenderer(l);else{if(!hopscotch.templates||"function"!=typeof hopscotch.templates[templateToUse])throw'Bubble rendering failed - template "'+templateToUse+'" is not a function.';m.innerHTML=hopscotch.templates[templateToUse](l)}for(children=m.children,numChildren=children.length,i=0;numChildren>i;i++)node=children[i],utils.hasClass(node,"hopscotch-arrow")&&(this.arrowEl=node);return m.style.zIndex=a.zindex||"",this._setArrow(a.placement),this.hide(!1),this.setPosition(a),c&&c(!a.fixedElement),this},_getStepI18nNum:function(a){var b=utils.getI18NString("stepNums");return b&&a<b.length?a=b[a]:a+=1,a},_setArrow:function(a){utils.removeClass(this.arrowEl,"down up right left"),"top"===a?utils.addClass(this.arrowEl,"down"):"bottom"===a?utils.addClass(this.arrowEl,"up"):"left"===a?utils.addClass(this.arrowEl,"right"):"right"===a&&utils.addClass(this.arrowEl,"left")},_getArrowDirection:function(){return"top"===this.placement?"down":"bottom"===this.placement?"up":"left"===this.placement?"right":"right"===this.placement?"left":void 0},show:function(){var a=this,b="fade-in-"+this._getArrowDirection(),c=1e3;return utils.removeClass(this.element,"hide"),utils.addClass(this.element,b),setTimeout(function(){utils.removeClass(a.element,"invisible")},50),setTimeout(function(){utils.removeClass(a.element,b)},c),this.isShowing=!0,this},hide:function(a){var b=this.element;return a=utils.valOrDefault(a,!0),b.style.top="",b.style.left="",a?(utils.addClass(b,"hide"),utils.removeClass(b,"invisible")):(utils.removeClass(b,"hide"),utils.addClass(b,"invisible")),utils.removeClass(b,"animate fade-in-up fade-in-down fade-in-right fade-in-left"),this.isShowing=!1,this},destroy:function(){var a=this.element;a&&a.parentNode.removeChild(a),utils.removeEvtListener(a,"click",this.clickCb)},_handleBubbleClick:function(a){function b(c){return c===a.currentTarget?null:utils.hasClass(c,"hopscotch-cta")?"cta":utils.hasClass(c,"hopscotch-next")?"next":utils.hasClass(c,"hopscotch-prev")?"prev":utils.hasClass(c,"hopscotch-close")?"close":b(c.parentElement)}var c;if(c=b(a.target),"cta"===c)this.opt.isTourBubble||winHopscotch.getCalloutManager().removeCallout(this.currStep.id),this.currStep.onCTA&&utils.invokeCallback(this.currStep.onCTA);else if("next"===c)winHopscotch.nextStep(!0);else if("prev"===c)winHopscotch.prevStep(!0);else if("close"===c){if(this.opt.isTourBubble){var d=winHopscotch.getCurrStepNum(),e=winHopscotch.getCurrTour(),f=d===e.steps.length-1;utils.invokeEventCallbacks("close"),winHopscotch.endTour(!0,f)}else this.opt.onClose&&utils.invokeCallback(this.opt.onClose),this.opt.id&&!this.opt.isTourBubble?winHopscotch.getCalloutManager().removeCallout(this.opt.id):this.destroy();utils.evtPreventDefault(a)}},init:function(a){var b,c,d,e=document.createElement("div"),f=this,g=!1;this.element=e,d={showPrevButton:defaultOpts.showPrevButton,showNextButton:defaultOpts.showNextButton,bubbleWidth:defaultOpts.bubbleWidth,bubblePadding:defaultOpts.bubblePadding,arrowWidth:defaultOpts.arrowWidth,showNumber:!0,isTourBubble:!0},a=typeof a===undefinedStr?{}:a,utils.extend(d,a),this.opt=d,e.className="hopscotch-bubble animated",d.isTourBubble||utils.addClass(e,"hopscotch-callout no-number"),b=function(){!g&&f.isShowing&&(g=!0,setTimeout(function(){f.setPosition(f.currStep),g=!1},100))},utils.addEvtListener(window,"resize",b),this.clickCb=function(a){f._handleBubbleClick(a)},utils.addEvtListener(e,"click",this.clickCb),this.hide(),utils.documentIsReady()?document.body.appendChild(e):(document.addEventListener?(c=function(){document.removeEventListener("DOMContentLoaded",c),window.removeEventListener("load",c),document.body.appendChild(e)},document.addEventListener("DOMContentLoaded",c,!1)):(c=function(){"complete"===document.readyState&&(document.detachEvent("onreadystatechange",c),window.detachEvent("onload",c),document.body.appendChild(e))},document.attachEvent("onreadystatechange",c)),utils.addEvtListener(window,"load",c))}},HopscotchCalloutManager=function(){var a={};this.createCallout=function(b){var c;if(!b.id)throw"Must specify a callout id.";if(a[b.id])throw"Callout by that id already exists. Please choose a unique id.";return b.showNextButton=b.showPrevButton=!1,b.isTourBubble=!1,c=new HopscotchBubble(b),a[b.id]=c,b.target&&c.render(b,null,function(){c.show()}),c},this.getCallout=function(b){return a[b]},this.removeAllCallouts=function(){var b;for(b in a)a.hasOwnProperty(b)&&this.removeCallout(b)},this.removeCallout=function(b){var c=a[b];a[b]=null,c&&c.destroy()}},Hopscotch=function(a){var b,c,d,e,f,g,h,i,j=this,k=function(a){return b||(b=new HopscotchBubble(d)),a&&utils.extend(b.opt,{bubblePadding:l("bubblePadding"),bubbleWidth:l("bubbleWidth"),showNextButton:l("showNextButton"),showPrevButton:l("showPrevButton"),showCloseButton:l("showCloseButton"),arrowWidth:l("arrowWidth")}),b},l=function(a){return"undefined"==typeof d?defaultOpts[a]:utils.valOrDefault(d[a],defaultOpts[a])},m=function(){var a;return a=0>f||f>=e.steps.length?null:e.steps[f]},n=function(){j.nextStep()},o=function(a){var b,c,d,e,f,g,h=k(),i=h.element,j=utils.getPixelValue(i.style.top),n=j+utils.getPixelValue(i.offsetHeight),o=utils.getStepTarget(m()),p=o.getBoundingClientRect(),q=p.top+utils.getScrollTop(),r=p.bottom+utils.getScrollTop(),s=q>j?j:q,t=n>r?n:r,u=utils.getScrollTop(),v=u+utils.getWindowHeight(),w=s-l("scrollTopMargin");s>=u&&(s<=u+l("scrollTopMargin")||v>=t)?a&&a():l("smoothScroll")?typeof YAHOO!==undefinedStr&&typeof YAHOO.env!==undefinedStr&&typeof YAHOO.env.ua!==undefinedStr&&typeof YAHOO.util!==undefinedStr&&typeof YAHOO.util.Scroll!==undefinedStr?(b=YAHOO.env.ua.webkit?document.body:document.documentElement,d=YAHOO.util.Easing?YAHOO.util.Easing.easeOut:void 0,c=new YAHOO.util.Scroll(b,{scroll:{to:[0,w]}},l("scrollDuration")/1e3,d),c.onComplete.subscribe(a),c.animate()):hasJquery?jQuery("body, html").animate({scrollTop:w},l("scrollDuration"),a):(0>w&&(w=0),e=u>s?-1:1,f=Math.abs(u-w)/(l("scrollDuration")/10),(g=function(){var b=utils.getScrollTop(),c=b+e*f;return e>0&&c>=w||0>e&&w>=c?(c=w,a&&a(),void window.scrollTo(0,c)):(window.scrollTo(0,c),utils.getScrollTop()===b?void(a&&a()):void setTimeout(g,10))})()):(window.scrollTo(0,w),a&&a())},p=function(a,b){var c,d,g;f+a>=0&&f+a<e.steps.length?(f+=a,d=m(),g=function(){c=utils.getStepTarget(d),c?b(f):(utils.invokeEventCallbacks("error"),p(a,b))},d.delay?setTimeout(g,d.delay):g()):b(-1)},q=function(a,b){var c,d,g,h,i=k(),j=this;if(i.hide(),a=utils.valOrDefault(a,!0),c=m(),d=c,g=b>0?d.multipage:f>0&&e.steps[f-1].multipage,h=function(c){var h;if(-1===c)return this.endTour(!0);if(a&&(h=b>0?utils.invokeEventCallbacks("next",d.onNext):utils.invokeEventCallbacks("prev",d.onPrev)),c===f){if(g)return void utils.setState(l("cookieName"),e.id+":"+f,1);h=utils.valOrDefault(h,!0),h?this.showStep(c):this.endTour(!1)}},!g&&l("skipIfNoElement"))p(b,function(a){h.call(j,a)});else if(f+b>=0&&f+b<e.steps.length){if(f+=b,c=m(),!utils.getStepTarget(c)&&!g)return utils.invokeEventCallbacks("error"),this.endTour(!0,!1);h.call(this,f)}return this},r=function(a){var b,c,d,e={};for(b in a)a.hasOwnProperty(b)&&"id"!==b&&"steps"!==b&&(e[b]=a[b]);return i.call(this,e,!0),c=utils.getState(l("cookieName")),c&&(d=c.split(":"),g=d[0],h=d[1],h=parseInt(h,10)),this},s=function(a,b){var c,d;if(f=a||0,c=m(),d=utils.getStepTarget(c))return void b(f);if(!d){if(utils.invokeEventCallbacks("error"),l("skipIfNoElement"))return void p(1,b);f=-1,b(f)}},t=function(a){var b,c,d=e.steps[a],g=e.steps,h=g.length,i=e.id+":"+a,j=k(),m=utils.getStepTarget(d);c=function(){j.show(),utils.invokeEventCallbacks("show",d.onShow)},f=a,j.hide(!1),b=a===h-1,j.render(d,a,function(a){a?o(c):c(),d.nextOnTargetClick&&utils.addEvtListener(m,"click",n)}),utils.setState(l("cookieName"),i,1)},u=function(a){a&&this.configure(a)};this.getCalloutManager=function(){return typeof c===undefinedStr&&(c=new HopscotchCalloutManager),c},this.startTour=function(a,b){var c,d,f=this;if(e||(e=a,r.call(this,a)),typeof b!==undefinedStr){if(b>=e.steps.length)throw"Specified step number out of bounds.";d=b}return utils.documentIsReady()?("undefined"==typeof d&&e.id===g&&typeof h!==undefinedStr?d=h:d||(d=0),s(d,function(a){var b=-1!==a&&utils.getStepTarget(e.steps[a]);return b?(utils.invokeEventCallbacks("start"),c=k(),c.hide(!1),f.isActive=!0,void(utils.getStepTarget(m())?f.showStep(a):(utils.invokeEventCallbacks("error"),l("skipIfNoElement")&&f.nextStep(!1)))):void f.endTour(!1,!1)}),this):(waitingToStart=!0,this)},this.showStep=function(a){var b=e.steps[a];return b.delay?setTimeout(function(){t(a)},b.delay):t(a),this},this.prevStep=function(a){return q.call(this,a,-1),this},this.nextStep=function(a){var b=m(),c=utils.getStepTarget(b);return b.nextOnTargetClick&&utils.removeEvtListener(c,"click",n),q.call(this,a,1),this},this.endTour=function(a,b){var c=k();return a=utils.valOrDefault(a,!0),b=utils.valOrDefault(b,!0),f=0,h=void 0,c.hide(),a&&utils.clearState(l("cookieName")),this.isActive&&(this.isActive=!1,e&&b&&utils.invokeEventCallbacks("end")),this.removeCallbacks(null,!0),this.resetDefaultOptions(),e=null,this},this.getCurrTour=function(){return e},this.getCurrTarget=function(){return utils.getStepTarget(m())},this.getCurrStepNum=function(){return f},this.refreshBubblePosition=function(){return b.setPosition(m()),this},this.listen=function(a,b,c){return a&&callbacks[a].push({cb:b,fromTour:c}),this},this.unlisten=function(a,b){var c,d,e=callbacks[a];for(c=0,d=e.length;d>c;++c)e[c]===b&&e.splice(c,1);return this},this.removeCallbacks=function(a,b){var c,d,e,f;for(f in callbacks)if(!a||a===f)if(b)for(c=callbacks[f],d=0,e=c.length;e>d;++d)c[d].fromTour&&(c.splice(d--,1),--e);else callbacks[f]=[];return this},this.registerHelper=function(a,b){"string"==typeof a&&"function"==typeof b&&(helpers[a]=b)},this.unregisterHelper=function(a){helpers[a]=null},this.invokeHelper=function(a){var b,c,d=[];for(b=1,c=arguments.length;c>b;++b)d.push(arguments[b]);helpers[a]&&helpers[a].call(null,d)},this.setCookieName=function(a){return d.cookieName=a,this},this.resetDefaultOptions=function(){return d={},this},this.resetDefaultI18N=function(){return customI18N={},this},this.getState=function(){return utils.getState(l("cookieName"))},i=function(a,b){var c,e,f,g,h=["next","prev","start","end","show","error","close"];for(d||this.resetDefaultOptions(),utils.extend(d,a),a&&utils.extend(customI18N,a.i18n),f=0,g=h.length;g>f;++f)e="on"+h[f].charAt(0).toUpperCase()+h[f].substring(1),a[e]&&this.listen(h[f],a[e],b);return c=k(!0),this},this.configure=function(a){return i.call(this,a,!1)},this.setRenderer=function(a){var b=typeof a;return"string"===b?(templateToUse=a,customRenderer=void 0):"function"===b&&(customRenderer=a),this},this.setEscaper=function(a){return"function"==typeof a&&(customEscape=a),this},u.call(this,a)},winHopscotch=new Hopscotch,context[namespace]=winHopscotch,function(){var _={};_.escape=function(a){return customEscape?customEscape(a):null==a?"":(""+a).replace(new RegExp("[&<>\"']","g"),function(a){return"&"==a?"&amp;":"<"==a?"&lt;":">"==a?"&gt;":'"'==a?"&quot;":"'"==a?"&#x27;":void 0})},this.hopscotch=this.hopscotch||{},this.hopscotch.templates=this.hopscotch.templates||{},this.hopscotch.templates.bubble_default=function(obj){function optEscape(a,b){return b?_.escape(a):a}obj||(obj={});{var __t,__p="";_.escape,Array.prototype.join}with(obj)__p+='\n<div class="hopscotch-bubble-container" style="width: '+(null==(__t=step.width)?"":__t)+"px; padding: "+(null==(__t=step.padding)?"":__t)+'px;">\n  ',tour.isTour&&(__p+='<span class="hopscotch-bubble-number">'+(null==(__t=i18n.stepNum)?"":__t)+"</span>"),__p+='\n  <div class="hopscotch-bubble-content">\n    ',""!==step.title&&(__p+='<h3 class="hopscotch-title">'+(null==(__t=optEscape(step.title,tour.unsafe))?"":__t)+"</h3>"),__p+="\n    ",""!==step.content&&(__p+='<div class="hopscotch-content">'+(null==(__t=optEscape(step.content,tour.unsafe))?"":__t)+"</div>"),__p+='\n  </div>\n  <div class="hopscotch-actions">\n    ',buttons.showPrev&&(__p+='<button class="hopscotch-nav-button prev hopscotch-prev">'+(null==(__t=i18n.prevBtn)?"":__t)+"</button>"),__p+="\n    ",buttons.showCTA&&(__p+='<button class="hopscotch-nav-button next hopscotch-cta">'+(null==(__t=buttons.ctaLabel)?"":__t)+"</button>"),__p+="\n    ",buttons.showNext&&(__p+='<button class="hopscotch-nav-button next hopscotch-next">'+(null==(__t=i18n.nextBtn)?"":__t)+"</button>"),__p+="\n  </div>\n  ",buttons.showClose&&(__p+='<a title="'+(null==(__t=i18n.closeTooltip)?"":__t)+'" href="#" class="hopscotch-bubble-close hopscotch-close">'+(null==(__t=i18n.closeTooltip)?"":__t)+"</a>"),__p+='\n</div>\n<div class="hopscotch-bubble-arrow-container hopscotch-arrow">\n  <div class="hopscotch-bubble-arrow-border"></div>\n  <div class="hopscotch-bubble-arrow"></div>\n</div>';return __p}}())}(window,"hopscotch");