/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.access.awssdkv2.converters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.model.CancellationReason;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.ItemCollectionSizeLimitExceededException;
import com.amazonaws.services.dynamodbv2.model.ResourceInUseException;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.util.CollectionUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.dynamodb.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.dynamodb.model.TransactionCanceledException;
import software.amazon.awssdk.services.dynamodb.model.TransactionConflictException;
import software.amazon.awssdk.services.dynamodb.model.TrimmedDataAccessException;

public class AwsServiceExceptionConverter {
    private static final Map<Class<? extends AmazonServiceException>, AwsServiceException.Builder> builderMapper = new HashMap<Class<? extends AmazonServiceException>, AwsServiceException.Builder>();

    public static AwsServiceException convert(AmazonServiceException src) {
        List cancellationReasons;
        AwsServiceException.Builder awsServiceExceptionBuilder = builderMapper.getOrDefault(((Object)((Object)src)).getClass(), AwsServiceException.builder());
        if (src instanceof com.amazonaws.services.dynamodbv2.model.TransactionCanceledException && !CollectionUtils.isNullOrEmpty((Collection)(cancellationReasons = ((com.amazonaws.services.dynamodbv2.model.TransactionCanceledException)src).getCancellationReasons()))) {
            ((TransactionCanceledException.Builder)awsServiceExceptionBuilder).cancellationReasons(AwsServiceExceptionConverter.buildCancellationReasons(cancellationReasons));
        }
        return awsServiceExceptionBuilder.requestId(src.getRequestId()).statusCode(src.getStatusCode()).awsErrorDetails(AwsErrorDetails.builder().errorMessage(src.getErrorMessage()).errorCode(src.getErrorCode()).serviceName(src.getServiceName()).build()).build();
    }

    private static Collection<software.amazon.awssdk.services.dynamodb.model.CancellationReason> buildCancellationReasons(List<CancellationReason> cancellationReasons) {
        return cancellationReasons.stream().map(cancellationReason -> (software.amazon.awssdk.services.dynamodb.model.CancellationReason)software.amazon.awssdk.services.dynamodb.model.CancellationReason.builder().code(cancellationReason.getCode()).message(cancellationReason.getMessage()).build()).collect(Collectors.toList());
    }

    static {
        builderMapper.put(ConditionalCheckFailedException.class, (AwsServiceException.Builder)software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException.builder());
        builderMapper.put(com.amazonaws.services.dynamodbv2.model.TransactionCanceledException.class, (AwsServiceException.Builder)TransactionCanceledException.builder());
        builderMapper.put(com.amazonaws.services.dynamodbv2.model.InternalServerErrorException.class, (AwsServiceException.Builder)InternalServerErrorException.builder());
        builderMapper.put(ItemCollectionSizeLimitExceededException.class, (AwsServiceException.Builder)software.amazon.awssdk.services.dynamodb.model.ItemCollectionSizeLimitExceededException.builder());
        builderMapper.put(com.amazonaws.services.dynamodbv2.model.LimitExceededException.class, (AwsServiceException.Builder)LimitExceededException.builder());
        builderMapper.put(com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputExceededException.class, (AwsServiceException.Builder)ProvisionedThroughputExceededException.builder());
        builderMapper.put(ResourceInUseException.class, (AwsServiceException.Builder)software.amazon.awssdk.services.dynamodb.model.ResourceInUseException.builder());
        builderMapper.put(ResourceNotFoundException.class, (AwsServiceException.Builder)software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException.builder());
        builderMapper.put(com.amazonaws.services.dynamodbv2.model.TransactionConflictException.class, (AwsServiceException.Builder)TransactionConflictException.builder());
        builderMapper.put(com.amazonaws.services.dynamodbv2.model.IdempotentParameterMismatchException.class, (AwsServiceException.Builder)IdempotentParameterMismatchException.builder());
        builderMapper.put(com.amazonaws.services.dynamodbv2.model.TrimmedDataAccessException.class, (AwsServiceException.Builder)TrimmedDataAccessException.builder());
    }
}

