/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.utils;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.csvreader.CsvReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class CSVRecordParser {
    public static ParseResult parse(String csvString) throws OdpsException {
        CsvReader reader = new CsvReader((Reader)new StringReader(csvString));
        reader.setSafetySwitch(false);
        int lineCount = 0;
        Column[] columns = new Column[]{};
        ArrayList<Record> records = new ArrayList<Record>();
        TableSchema schema = new TableSchema();
        try {
            while (reader.readRecord()) {
                String[] newline = reader.getValues();
                if (lineCount == 0) {
                    columns = new Column[newline.length];
                    for (int i = 0; i < newline.length; ++i) {
                        columns[i] = new Column(newline[i], OdpsType.STRING);
                        schema.addColumn(columns[i]);
                    }
                } else {
                    ArrayRecord record = new ArrayRecord(columns);
                    for (int i = 0; i < newline.length; ++i) {
                        record.set(i, (Object)newline[i]);
                    }
                    records.add((Record)record);
                }
                ++lineCount;
            }
        }
        catch (IOException e) {
            throw new OdpsException("Error when parse sql results.", e);
        }
        return new ParseResult(schema, records);
    }

    public static class ParseResult {
        TableSchema schema = null;
        List<Record> records = null;

        public ParseResult(TableSchema schema, List<Record> records) {
            this.schema = schema;
            this.records = records;
        }

        public TableSchema getSchema() {
            return this.schema;
        }

        public List<Record> getRecords() {
            return this.records;
        }
    }
}

