/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.streams;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.CompressOption;
import java.io.IOException;
import java.util.List;

public interface UpsertStream {
    public void upsert(Record var1) throws IOException, TunnelException;

    public void upsert(Record var1, List<String> var2) throws IOException, TunnelException;

    public void delete(Record var1) throws IOException, TunnelException;

    public void flush() throws IOException, TunnelException;

    public void close() throws IOException, TunnelException;

    public void reset() throws IOException;

    public static interface Builder {
        public long getMaxBufferSize();

        public Builder setMaxBufferSize(long var1);

        public long getSlotBufferSize();

        public Builder setSlotBufferSize(long var1);

        public CompressOption getCompressOption();

        public Builder setCompressOption(CompressOption var1);

        public Listener getListener();

        public Builder setListener(Listener var1);

        public UpsertStream build() throws IOException, TunnelException;
    }

    public static interface Listener {
        public void onFlush(FlushResult var1);

        default public boolean onFlushFail(Exception error, int retry) {
            return this.onFlushFail(error.getMessage(), retry);
        }

        @Deprecated
        default public boolean onFlushFail(String error, int retry) {
            return false;
        }
    }

    public static class FlushResult {
        public String traceId;
        public long flushSize;
        public long recordCount;
        public long flushTime;
    }
}

