/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.proto.ProtobufRecordStreamReader;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class RawTunnelRecordReader
extends ProtobufRecordStreamReader {
    private Connection conn;

    public RawTunnelRecordReader(TableSchema schema, List<Column> columns, Connection conn, CompressOption option) throws IOException {
        super(schema, columns, conn.getInputStream(), option);
        this.conn = conn;
    }

    public RawTunnelRecordReader(List<Column> columns, Connection conn, CompressOption option) throws IOException {
        super(columns, conn.getInputStream(), option);
        this.conn = conn;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.conn.disconnect();
    }

    public static RawTunnelRecordReader createInstanceTunnelReader(long start, long count, CompressOption compress, List<Column> columns, RestClient restClient, InstanceTunnel.DownloadSession session, boolean longPolling) throws TunnelException, IOException {
        return RawTunnelRecordReader.createInstanceTunnelReader(start, count, 0L, compress, columns, restClient, session, longPolling);
    }

    public static RawTunnelRecordReader createInstanceTunnelReader(long start, long count, long sizeLimit, CompressOption compress, List<Column> columns, RestClient restClient, InstanceTunnel.DownloadSession session, boolean longPolling) throws TunnelException, IOException {
        Configuration conf;
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Length", String.valueOf(0));
        headers.put("x-odps-tunnel-version", String.valueOf(5));
        switch (compress.algorithm) {
            case ODPS_RAW: {
                break;
            }
            case ODPS_ZLIB: {
                headers.put("Accept-Encoding", "deflate");
                break;
            }
            case ODPS_SNAPPY: {
                headers.put("Accept-Encoding", "x-snappy-framed");
                break;
            }
            case ODPS_LZ4_FRAME: {
                headers.put("Accept-Encoding", "x-lz4-frame");
                break;
            }
            default: {
                throw new TunnelException("invalid compression option.");
            }
        }
        if (columns != null && columns.size() != 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < columns.size(); ++i) {
                sb.append(columns.get(i).getName());
                if (i == columns.size() - 1) continue;
                sb.append(",");
            }
            params.put("columns", sb.toString());
        }
        if (session.getEnableLimit()) {
            params.put("instance_tunnel_limit_enabled", null);
        }
        if (!StringUtils.isNullOrEmpty((String)(conf = session.getConfig()).getQuotaName())) {
            params.put("quotaName", conf.getQuotaName());
        }
        params.put("data", null);
        if (longPolling) {
            params.put("schema_in_stream", null);
            params.put("cached", null);
            params.put("taskname", session.getTaskName());
            if (session.getQueryId() != -1) {
                params.put("queryid", String.valueOf(session.getQueryId()));
            }
            if (start < 0L) {
                TunnelException err = new TunnelException("The specified row range is not valid. start index is negative.");
                throw err;
            }
            if (count > 0L || start > 0L) {
                if (start > 0L && count < 0L) {
                    params.put("rowrange", "(" + start + "," + Long.MAX_VALUE + ")");
                } else {
                    params.put("rowrange", "(" + start + "," + count + ")");
                }
            }
            if (sizeLimit > 0L) {
                params.put("sizelimit", Long.toString(sizeLimit));
            }
        } else {
            params.put("downloadid", session.getId());
            params.put("rowrange", "(" + start + "," + count + ")");
        }
        Connection conn = null;
        try {
            conn = restClient.connect(ResourceBuilder.buildInstanceResource(session.getProjectName(), session.getInstanceID()), "GET", params, headers);
            Response resp = conn.getResponse();
            if (!resp.isOK()) {
                TunnelException err = new TunnelException(conn.getInputStream());
                err.setRequestId(resp.getHeader("x-odps-request-id"));
                throw err;
            }
            CompressOption option = null;
            String content_encoding = resp.getHeader("Content-Encoding");
            if (content_encoding != null) {
                if (content_encoding.equals("deflate")) {
                    option = new CompressOption(CompressOption.CompressAlgorithm.ODPS_ZLIB, -1, 0);
                } else if (content_encoding.equals("x-snappy-framed")) {
                    option = new CompressOption(CompressOption.CompressAlgorithm.ODPS_SNAPPY, -1, 0);
                } else if (content_encoding.equals("x-lz4-frame")) {
                    option = new CompressOption(CompressOption.CompressAlgorithm.ODPS_LZ4_FRAME, -1, 0);
                } else {
                    throw new TunnelException("invalid content encoding");
                }
            }
            if (longPolling) {
                long recordCount = 0L;
                if (resp.getHeaders().containsKey("odps-tunnel-record-count")) {
                    recordCount = Long.parseLong(resp.getHeader("odps-tunnel-record-count"));
                }
                session.setRecordCount(recordCount);
                if (resp.getHeaders().containsKey("odps-tunnel-schema")) {
                    String schemaStr = resp.getHeader("odps-tunnel-schema");
                    if (StringUtils.isNullOrEmpty((String)schemaStr)) {
                        throw new TunnelException("Invalid response schema in header:" + schemaStr);
                    }
                    JsonObject tree = new JsonParser().parse(schemaStr).getAsJsonObject();
                    TunnelTableSchema schema = new TunnelTableSchema(tree);
                    session.setSchema(schema);
                    return new RawTunnelRecordReader(session.getSchema(), columns, conn, option);
                }
                RawTunnelRecordReader reader = new RawTunnelRecordReader(columns, conn, option);
                session.setSchema(reader.getTableSchema());
                return reader;
            }
            return new RawTunnelRecordReader(session.getSchema(), columns, conn, option);
        }
        catch (IOException e) {
            if (conn != null) {
                conn.disconnect();
            }
            throw new TunnelException(e.getMessage(), e);
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (OdpsException e) {
            if (conn != null) {
                conn.disconnect();
            }
            throw new TunnelException(e.getMessage(), e);
        }
    }

    public static RawTunnelRecordReader createTableTunnelReader(long start, long count, CompressOption compress, List<Column> columns, RestClient restClient, TableTunnel.DownloadSession session) throws IOException, TunnelException {
        return RawTunnelRecordReader.createTableTunnelReader(start, count, compress, columns, restClient, session, false);
    }

    public static RawTunnelRecordReader createTableTunnelReader(long start, long count, CompressOption compress, List<Column> columns, RestClient restClient, TableTunnel.DownloadSession session, boolean disableModifiedCheck) throws IOException, TunnelException {
        Configuration conf;
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Length", String.valueOf(0));
        headers.put("x-odps-tunnel-version", String.valueOf(5));
        if (compress != null) {
            switch (compress.algorithm) {
                case ODPS_RAW: {
                    break;
                }
                case ODPS_ZLIB: {
                    headers.put("Accept-Encoding", "deflate");
                    break;
                }
                case ODPS_SNAPPY: {
                    headers.put("Accept-Encoding", "x-snappy-framed");
                    break;
                }
                case ODPS_LZ4_FRAME: {
                    headers.put("Accept-Encoding", "x-lz4-frame");
                    break;
                }
                default: {
                    throw new TunnelException("invalid compression option.");
                }
            }
        }
        if (columns != null && columns.size() != 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < columns.size(); ++i) {
                sb.append(columns.get(i).getName());
                if (i == columns.size() - 1) continue;
                sb.append(",");
            }
            params.put("columns", sb.toString());
        }
        params.put("downloadid", session.getId());
        params.put("data", null);
        params.put("rowrange", "(" + start + "," + count + ")");
        String partitionSpec = session.getPartitionSpec();
        if (partitionSpec != null && partitionSpec.length() > 0) {
            params.put("partition", partitionSpec);
        }
        if (!StringUtils.isNullOrEmpty((String)(conf = session.getConfig()).getQuotaName())) {
            params.put("quotaName", conf.getQuotaName());
        }
        if (disableModifiedCheck) {
            params.put("disable_modified_check", "true");
        }
        Connection conn = null;
        try {
            String resource = ResourceBuilder.buildTableResource(session.getProjectName(), session.getSchemaName(), session.getTableName());
            conn = restClient.connect(resource, "GET", params, headers);
            Response resp = conn.getResponse();
            if (!resp.isOK()) {
                TunnelException err = new TunnelException(conn.getInputStream());
                err.setRequestId(resp.getHeader("x-odps-request-id"));
                throw err;
            }
            CompressOption option = null;
            String content_encoding = resp.getHeader("Content-Encoding");
            if (content_encoding != null) {
                if (content_encoding.equals("deflate")) {
                    option = new CompressOption(CompressOption.CompressAlgorithm.ODPS_ZLIB, -1, 0);
                } else if (content_encoding.equals("x-snappy-framed")) {
                    option = new CompressOption(CompressOption.CompressAlgorithm.ODPS_SNAPPY, -1, 0);
                } else if (content_encoding.equals("x-lz4-frame")) {
                    option = new CompressOption(CompressOption.CompressAlgorithm.ODPS_LZ4_FRAME, -1, 0);
                } else {
                    throw new TunnelException("invalid content encoding");
                }
            }
            return new RawTunnelRecordReader(session.getSchema(), columns, conn, option);
        }
        catch (IOException e) {
            if (conn != null) {
                conn.disconnect();
            }
            throw new TunnelException(e.getMessage(), e);
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (OdpsException e) {
            if (conn != null) {
                conn.disconnect();
            }
            throw new TunnelException(e.getMessage(), e);
        }
    }
}

