/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.impl;

import com.aliyun.odps.Column;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class UpsertRecord
extends ArrayRecord {
    private Column[] columns;
    ArrayRecord record;
    private HashMap<String, Integer> nameMap = new HashMap();

    public UpsertRecord(Column[] columns) {
        this(columns, null);
    }

    public UpsertRecord(Column[] columns, Object[] values) {
        super(columns);
        int i;
        if (columns.length < 5) {
            throw new IllegalArgumentException("Incomplete schema");
        }
        if (!columns[columns.length - 5].getName().equalsIgnoreCase("__version")) {
            throw new IllegalArgumentException("Invalid schema");
        }
        if (!columns[columns.length - 4].getName().equalsIgnoreCase("__app_version")) {
            throw new IllegalArgumentException("Invalid schema");
        }
        if (!columns[columns.length - 3].getName().equalsIgnoreCase("__operation")) {
            throw new IllegalArgumentException("Invalid schema");
        }
        if (!columns[columns.length - 2].getName().equalsIgnoreCase("__key_cols")) {
            throw new IllegalArgumentException("Invalid schema");
        }
        if (!columns[columns.length - 1].getName().equalsIgnoreCase("__value_cols")) {
            throw new IllegalArgumentException("Invalid schema");
        }
        this.columns = new Column[columns.length - 5];
        for (i = 0; i < columns.length - 5; ++i) {
            this.columns[i] = columns[i];
        }
        for (i = 0; i < columns.length; ++i) {
            this.nameMap.put(columns[i].getName(), i);
        }
        this.record = values == null ? new ArrayRecord(columns) : new ArrayRecord(columns, values);
    }

    void setOperation(byte operation) {
        this.record.setTinyint("__operation", Byte.valueOf(operation));
    }

    void setValueCols(List<Long> cols) {
        this.record.setArray("__value_cols", cols);
    }

    ArrayRecord getRecord() {
        return this.record;
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public boolean isNull(int idx) {
        this.checkIndex(idx);
        return this.record.isNull(idx);
    }

    public boolean isNull(String columnName) {
        return this.isNull(this.getColumnIndex(columnName));
    }

    public void set(int idx, Object value) {
        this.checkIndex(idx);
        this.record.set(idx, value);
    }

    public Object get(int idx) {
        this.checkIndex(idx);
        return this.record.get(idx);
    }

    public void set(String columnName, Object value) {
        this.set(this.getColumnIndex(columnName), value);
    }

    public Object get(String columnName) {
        return this.get(this.getColumnIndex(columnName));
    }

    public void setBigint(int idx, Long value) {
        this.checkIndex(idx);
        this.record.setBigint(idx, value);
    }

    public void setDate(int idx, java.sql.Date value, Calendar calendar) {
        this.checkIndex(idx);
        this.record.setDate(idx, value, calendar);
    }

    public Long getBigint(int idx) {
        this.checkIndex(idx);
        return this.record.getBigint(idx);
    }

    public void setBigint(String columnName, Long value) {
        this.setBigint(this.getColumnIndex(columnName), value);
    }

    public Long getBigint(String columnName) {
        return this.getBigint(this.getColumnIndex(columnName));
    }

    public void setDouble(int idx, Double value) {
        this.checkIndex(idx);
        this.record.setDouble(idx, value);
    }

    public Double getDouble(int idx) {
        this.checkIndex(idx);
        return this.record.getDouble(idx);
    }

    public void setDouble(String columnName, Double value) {
        this.setDouble(this.getColumnIndex(columnName), value);
    }

    public Double getDouble(String columnName) {
        return this.getDouble(this.getColumnIndex(columnName));
    }

    public void setBoolean(int idx, Boolean value) {
        this.checkIndex(idx);
        this.record.setBoolean(idx, value);
    }

    public Boolean getBoolean(int idx) {
        this.checkIndex(idx);
        return this.record.getBoolean(idx);
    }

    public void setBoolean(String columnName, Boolean value) {
        this.setBoolean(this.getColumnIndex(columnName), value);
    }

    public Boolean getBoolean(String columnName) {
        return this.getBoolean(this.getColumnIndex(columnName));
    }

    public void setDatetime(int idx, Date value) {
        this.checkIndex(idx);
        this.record.setDatetime(idx, value);
    }

    public Date getDatetime(int idx) {
        this.checkIndex(idx);
        return this.record.getDatetime(idx);
    }

    public void setDatetime(String columnName, Date value) {
        this.setDatetime(this.getColumnIndex(columnName), value);
    }

    public Date getDatetime(String columnName) {
        return this.getDatetime(this.getColumnIndex(columnName));
    }

    public void setDecimal(int idx, BigDecimal value) {
        this.checkIndex(idx);
        this.record.setDecimal(idx, value);
    }

    public BigDecimal getDecimal(int idx) {
        this.checkIndex(idx);
        return this.record.getDecimal(idx);
    }

    public void setDecimal(String columnName, BigDecimal value) {
        this.setDecimal(this.getColumnIndex(columnName), value);
    }

    public BigDecimal getDecimal(String columnName) {
        return this.getDecimal(this.getColumnIndex(columnName));
    }

    public void setString(int idx, String value) {
        this.checkIndex(idx);
        this.record.setString(idx, value);
    }

    public String getString(int idx) {
        this.checkIndex(idx);
        return this.record.getString(idx);
    }

    public void setString(String columnName, String value) {
        this.setString(this.getColumnIndex(columnName), value);
    }

    public String getString(String columnName) {
        return this.getString(this.getColumnIndex(columnName));
    }

    public void setString(int idx, byte[] value) {
        this.checkIndex(idx);
        this.record.setString(idx, value);
    }

    public void setString(String columnName, byte[] value) {
        this.setString(this.getColumnIndex(columnName), value);
    }

    public byte[] getBytes(int idx) {
        this.checkIndex(idx);
        return this.record.getBytes(idx);
    }

    public byte[] getBytes(String columnName) {
        return this.getBytes(this.getColumnIndex(columnName));
    }

    public void set(Object[] values) {
        if (values.length > this.columns.length) {
            throw new IllegalArgumentException("not supported");
        }
    }

    public Object[] toArray() {
        Object[] objects = new Object[this.columns.length];
        Object[] allObjects = this.record.toArray();
        for (int i = 0; i < this.columns.length; ++i) {
            objects[i] = allObjects[i];
        }
        return objects;
    }

    public Record clone() {
        return new UpsertRecord(this.record.getColumns(), this.record.toArray());
    }

    private void checkIndex(int idx) {
        if (idx > this.columns.length) {
            throw new IllegalArgumentException("index out of range");
        }
    }

    private int getColumnIndex(String name) {
        Integer idx = this.nameMap.get(name);
        if (idx == null) {
            throw new IllegalArgumentException("No such column:" + name);
        }
        return idx;
    }
}

