/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.impl;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.impl.ConfigurationImpl;
import com.aliyun.odps.tunnel.impl.SessionBase;
import com.aliyun.odps.tunnel.impl.Slot;
import com.aliyun.odps.tunnel.impl.StreamSessionBase;
import com.aliyun.odps.tunnel.impl.Util;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.ProtobufRecordPack;
import com.aliyun.odps.tunnel.io.StreamRecordPackImpl;
import com.aliyun.odps.utils.ConnectionWatcher;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class StreamUploadSessionImpl
extends StreamSessionBase
implements TableTunnel.StreamUploadSession {
    protected Slots slots;
    private boolean p2pMode = false;
    private List<Column> columns;

    public StreamUploadSessionImpl(ConfigurationImpl conf, String projectName, String schemaName, String tableName, String partitionSpec, boolean cretaPartition, long slotNum, List<Column> zorderColumns, String schemaVersion) throws TunnelException {
        this.config = conf;
        this.projectName = projectName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
        this.columns = zorderColumns;
        this.httpClient = Util.newRestClient((Configuration)conf, projectName);
        this.schemaVersion = schemaVersion;
        this.initiate(slotNum, cretaPartition);
    }

    private void initiate(long slotNum, boolean createPartition) throws TunnelException {
        HashMap<String, String> params = this.getCommonParams();
        if (createPartition) {
            params.put("create_partition", "");
        }
        if (this.columns != null && this.columns.size() != 0) {
            params.put("zorder_columns", this.getColumnString());
        }
        if (this.schemaVersion != null && !this.schemaVersion.isEmpty()) {
            params.put("schema_version", this.schemaVersion);
        }
        HashMap<String, String> headers = this.getCommonHeaders();
        if (slotNum > 0L) {
            headers.put("odps-tunnel-slot-num", String.valueOf(slotNum));
        }
        SessionBase.HttpResult result = this.httpRequest(headers, params, "POST", "create stream upload session");
        try {
            JsonObject tree = new JsonParser().parse(result.body).getAsJsonObject();
            this.slots = new Slots(this.loadFromJson(result.requestId, tree, false));
        }
        catch (JsonSyntaxException e) {
            throw new TunnelException(result.requestId, "Invalid json content: '" + result.body + "'", e);
        }
    }

    private void reload() throws TunnelException {
        HashMap<String, String> params = this.getCommonParams();
        params.put("uploadid", this.id);
        params.put("schema_version", this.schemaVersion);
        HashMap<String, String> headers = this.getCommonHeaders();
        SessionBase.HttpResult result = this.httpRequest(headers, params, "GET", "get stream upload session");
        try {
            JsonObject tree = new JsonParser().parse(result.body).getAsJsonObject();
            this.slots = new Slots(this.loadFromJson(result.requestId, tree, true));
        }
        catch (JsonSyntaxException e) {
            throw new TunnelException(result.requestId, "Invalid json content: '" + result.body + "'", e);
        }
    }

    public void reloadSlots(Slot slot, String server, int slotNum) throws TunnelException {
        if (this.slots.getSlotNum() != slotNum) {
            this.reload();
        } else if (!slot.getServer().equals(server)) {
            slot.setServer(server);
        }
    }

    private Connection getConnection(CompressOption compress, Slot slot, long size, long reocrdCount) throws OdpsException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uploadid", this.id);
        params.put("slotid", slot.getSlot());
        params.put("schema_version", this.schemaVersion);
        if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
            params.put("partition", this.partitionSpec);
        }
        if (reocrdCount > 0L) {
            params.put("record_count", String.valueOf(reocrdCount));
        }
        if (this.columns != null && this.columns.size() != 0) {
            params.put("zorder_columns", this.getColumnString());
        }
        HashMap<String, String> headers = this.getCommonHeaders();
        if (size < 0L) {
            headers.put("Transfer-Encoding", "chunked");
        } else {
            headers.put("Content-Length", String.valueOf(size));
        }
        headers.put("Content-Type", "application/octet-stream");
        headers.put("x-odps-tunnel-version", String.valueOf(5));
        headers.put("odps-tunnel-slot-num", String.valueOf(this.slots.getSlotNum()));
        if (!StringUtils.isNullOrEmpty((String)this.config.getQuotaName())) {
            params.put("quotaName", this.config.getQuotaName());
        }
        switch (compress.algorithm) {
            case ODPS_RAW: {
                break;
            }
            case ODPS_ZLIB: {
                headers.put("Content-Encoding", "deflate");
                break;
            }
            case ODPS_SNAPPY: {
                headers.put("Content-Encoding", "x-snappy-framed");
                break;
            }
            case ODPS_LZ4_FRAME: {
                headers.put("Content-Encoding", "x-lz4-frame");
                break;
            }
            default: {
                throw new TunnelException("unsupported compression option.");
            }
        }
        headers.put("odps-tunnel-routed-server", slot.getServer());
        if (this.p2pMode) {
            try {
                URI u = new URI(this.httpClient.getEndpoint());
                return this.httpClient.connect(this.getResource(), "PUT", params, headers, u.getScheme() + "://" + slot.getIp());
            }
            catch (URISyntaxException e) {
                throw new TunnelException("Invalid endpoint: " + this.httpClient.getEndpoint());
            }
        }
        return this.httpClient.connect(this.getResource(), "PUT", params, headers);
    }

    public String writeBlock(ProtobufRecordPack pack) throws IOException {
        return this.writeBlock(pack, 0L);
    }

    public String writeBlock(ProtobufRecordPack pack, long timeout) throws IOException {
        Connection conn = null;
        try {
            Slot slot = this.slots.iterator().next();
            conn = this.getConnection(pack.getCompressOption(), slot, pack.getTotalBytes(), pack.getSize());
            String string = this.sendBlock(pack, conn, slot, timeout);
            return string;
        }
        catch (OdpsException e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
    }

    private String sendBlock(ProtobufRecordPack pack, Connection conn, Slot slot, long timeout) throws IOException, TunnelException {
        if (null == conn) {
            throw new IOException("Invalid connection");
        }
        ByteArrayOutputStream baos = pack.getProtobufStream();
        if (timeout > 0L) {
            ConnectionWatcher.getInstance().mark(conn, timeout);
        }
        Response response = null;
        try {
            baos.writeTo(conn.getOutputStream());
            conn.getOutputStream().close();
            baos.close();
            response = conn.getResponse();
        }
        catch (Throwable tr) {
            if (timeout > 0L && ConnectionWatcher.getInstance().checkTimedOut(conn)) {
                throw new SocketTimeoutException("Flush time exceeded timeout user set: " + timeout + "ms");
            }
            throw tr;
        }
        finally {
            if (timeout > 0L) {
                ConnectionWatcher.getInstance().release(conn);
            }
        }
        if (!response.isOK()) {
            TunnelException exception = new TunnelException(response.getHeader("x-odps-request-id"), conn.getInputStream(), response.getStatus());
            throw new IOException(exception.getMessage(), exception);
        }
        this.reloadSlots(slot, response.getHeader("odps-tunnel-routed-server"), Integer.valueOf(response.getHeader("odps-tunnel-slot-num")));
        return response.getHeader("x-odps-request-id");
    }

    private String getColumnString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.columns.size(); ++i) {
            sb.append(this.columns.get(i).getName());
            if (i == this.columns.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setP2pMode(boolean mode) {
        this.p2pMode = mode;
    }

    @Override
    public TableSchema getSchema() {
        return this.schema;
    }

    @Override
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public String getQuotaName() {
        return this.quotaName;
    }

    @Override
    public TableTunnel.StreamRecordPack newRecordPack() throws IOException {
        return new StreamRecordPackImpl(this, new CompressOption(CompressOption.CompressAlgorithm.ODPS_RAW, 0, 0));
    }

    @Override
    public TableTunnel.StreamRecordPack newRecordPack(CompressOption option) throws IOException {
        return new StreamRecordPackImpl(this, option);
    }

    @Override
    public Record newRecord() {
        return new ArrayRecord(this.schema.getColumns().toArray(new Column[0]));
    }

    public void abort() throws TunnelException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uploadid", this.id);
        if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
            params.put("partition", this.partitionSpec);
        }
        HashMap<String, String> headers = Util.getCommonHeader();
        Slot slot = this.slots.iterator().next();
        headers.put("odps-tunnel-routed-server", slot.getServer());
        Connection conn = null;
        String requestId = null;
        try {
            conn = this.httpClient.connect(this.getResource(), "POST", params, headers);
            Response resp = conn.getResponse();
            requestId = resp.getHeader("x-odps-request-id");
            if (!resp.isOK()) {
                throw new TunnelException(requestId, conn.getInputStream(), resp.getStatus());
            }
        }
        catch (IOException e) {
            throw new TunnelException(requestId, "Failed abort upload session with tunnel endpoint " + this.httpClient.getEndpoint(), e);
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (OdpsException e) {
            throw new TunnelException("not available", e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static class Slots
    implements Iterable<Slot> {
        private Random rand = new Random();
        private final List<Slot> slots;
        private int curSlotIndex;
        private Iterator<Slot> iter;

        public Slots(final List<Slot> slots) throws TunnelException {
            this.slots = slots;
            this.curSlotIndex = -1;
            if (this.slots.size() > 0) {
                this.curSlotIndex = this.rand.nextInt(this.slots.size());
            }
            this.iter = new Iterator<Slot>(){

                @Override
                public boolean hasNext() {
                    return curSlotIndex >= 0;
                }

                @Override
                public synchronized Slot next() {
                    if (this.hasNext()) {
                        if (curSlotIndex >= slots.size()) {
                            curSlotIndex = 0;
                        }
                        return (Slot)slots.get(curSlotIndex++);
                    }
                    return null;
                }
            };
        }

        @Override
        public Iterator<Slot> iterator() {
            return this.iter;
        }

        public int getSlotNum() {
            return this.slots.size();
        }
    }

    public static class Builder
    extends TableTunnel.StreamUploadSession.Builder {
        private String projectName;
        private String tableName;
        private CompressOption compressOption = new CompressOption();
        private boolean p2pMode = false;
        private List<Column> zorderColumns;
        private ConfigurationImpl config;

        public String getProjectName() {
            return this.projectName;
        }

        public Builder setProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public CompressOption getCompressOption() {
            return this.compressOption;
        }

        public Builder setCompressOption(CompressOption compressOption) {
            this.compressOption = compressOption;
            return this;
        }

        public List<Column> getZorderColumns() {
            return this.zorderColumns;
        }

        public Builder setZorderColumns(List<Column> zorderColumns) {
            this.zorderColumns = zorderColumns;
            return this;
        }

        public ConfigurationImpl getConfig() {
            return this.config;
        }

        public Builder setConfig(ConfigurationImpl config) {
            this.config = config;
            return this;
        }

        @Override
        public TableTunnel.StreamUploadSession build() throws TunnelException {
            return new StreamUploadSessionImpl(this.config, this.projectName, this.getSchemaName(), this.tableName, this.getPartitionSpec(), this.isCreatePartition(), this.getSlotNum(), this.zorderColumns, this.getSchemaVersion());
        }
    }
}

