/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.hasher;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.IntervalDayTime;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.tunnel.hasher.HasherFactory;
import com.aliyun.odps.tunnel.hasher.OdpsHasher;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

class LegacyHashFactory
implements HasherFactory {
    private static Map<OdpsType, OdpsHasher> factoryMap = new HashMap<OdpsType, OdpsHasher>();

    LegacyHashFactory() {
    }

    @Override
    public OdpsHasher getHasher(OdpsType type) {
        return factoryMap.get(type);
    }

    public String getName() {
        return "legacy";
    }

    static int basicLongHasher(long val) {
        long l = val;
        l = l >> 32 ^ l;
        return (int)l;
    }

    static {
        factoryMap.put(OdpsType.TINYINT, new TinyIntHasher());
        factoryMap.put(OdpsType.SMALLINT, new SmallIntHasher());
        factoryMap.put(OdpsType.INT, new IntHasher());
        factoryMap.put(OdpsType.BIGINT, new BigintHasher());
        factoryMap.put(OdpsType.DATETIME, new DateTimeHasher());
        factoryMap.put(OdpsType.DATE, new DateHasher());
        factoryMap.put(OdpsType.FLOAT, new FloatHasher());
        factoryMap.put(OdpsType.DOUBLE, new DoubleHasher());
        factoryMap.put(OdpsType.BOOLEAN, new BooleanHasher());
        factoryMap.put(OdpsType.CHAR, new CharHasher());
        factoryMap.put(OdpsType.VARCHAR, new VarcharHasher());
        factoryMap.put(OdpsType.STRING, new StringHasher());
        factoryMap.put(OdpsType.BINARY, new BinaryHasher());
        factoryMap.put(OdpsType.TIMESTAMP, new TimestampHasher());
        factoryMap.put(OdpsType.INTERVAL_DAY_TIME, new IntervalDayTimeHasher());
    }

    private static class IntervalDayTimeHasher
    implements OdpsHasher<IntervalDayTime> {
        private IntervalDayTimeHasher() {
        }

        @Override
        public int hash(IntervalDayTime val) {
            if (val == null) {
                return 0;
            }
            long totalSec = val.getTotalSeconds();
            int nanos = val.getNanos();
            totalSec <<= 30;
            return LegacyHashFactory.basicLongHasher(totalSec |= (long)nanos);
        }
    }

    private static class TimestampHasher
    implements OdpsHasher<Instant> {
        private TimestampHasher() {
        }

        @Override
        public Instant normalizeType(Object value) {
            if (value instanceof Timestamp) {
                return ((Timestamp)value).toInstant();
            }
            return (Instant)OdpsHasher.super.normalizeType(value);
        }

        @Override
        public int hash(Instant val) {
            if (val == null) {
                return 0;
            }
            long seconds = val.getEpochSecond();
            int nanos = val.getNano();
            seconds <<= 30;
            return LegacyHashFactory.basicLongHasher(seconds |= (long)nanos);
        }
    }

    private static class DateTimeHasher
    implements OdpsHasher<ZonedDateTime> {
        private DateTimeHasher() {
        }

        @Override
        public ZonedDateTime normalizeType(Object value) {
            if (value instanceof Date) {
                return ZonedDateTime.ofInstant(Instant.ofEpochMilli(((Date)value).getTime()), ZoneId.of("UTC"));
            }
            return (ZonedDateTime)OdpsHasher.super.normalizeType(value);
        }

        @Override
        public int hash(ZonedDateTime val) {
            if (val == null) {
                return 0;
            }
            return ((OdpsHasher)factoryMap.get(OdpsType.BIGINT)).hash(val.toInstant().toEpochMilli());
        }
    }

    private static class DateHasher
    implements OdpsHasher<LocalDate> {
        private DateHasher() {
        }

        @Override
        public LocalDate normalizeType(Object value) {
            if (value instanceof Date) {
                return ZonedDateTime.ofInstant(Instant.ofEpochMilli(((Date)value).getTime()), ZoneId.of("UTC")).toLocalDate();
            }
            return (LocalDate)OdpsHasher.super.normalizeType(value);
        }

        @Override
        public int hash(LocalDate val) {
            if (val == null) {
                return 0;
            }
            return ((OdpsHasher)factoryMap.get(OdpsType.BIGINT)).hash(val.atStartOfDay(ZoneOffset.UTC).toEpochSecond());
        }
    }

    private static class VarcharHasher
    implements OdpsHasher<Varchar> {
        private VarcharHasher() {
        }

        @Override
        public int hash(Varchar val) {
            if (val == null) {
                return 0;
            }
            return ((OdpsHasher)factoryMap.get(OdpsType.STRING)).hash(val.getValue());
        }
    }

    private static class CharHasher
    implements OdpsHasher<Char> {
        private CharHasher() {
        }

        @Override
        public int hash(Char val) {
            if (val == null) {
                return 0;
            }
            return ((OdpsHasher)factoryMap.get(OdpsType.STRING)).hash(val.getValue());
        }
    }

    private static class BinaryHasher
    implements OdpsHasher<Binary> {
        private BinaryHasher() {
        }

        @Override
        public int hash(Binary val) {
            if (val == null) {
                return 0;
            }
            return ((OdpsHasher)factoryMap.get(OdpsType.STRING)).hash(val.toString());
        }
    }

    private static class StringHasher
    implements OdpsHasher<String> {
        private static final Charset UTF8 = Charset.forName("UTF8");

        private StringHasher() {
        }

        @Override
        public int hash(String val) {
            if (val == null) {
                return 0;
            }
            byte[] chars = val.getBytes(UTF8);
            int hashVal = 0;
            for (int i = 0; i < chars.length; ++i) {
                hashVal = hashVal * 31 + chars[i];
            }
            return hashVal;
        }
    }

    private static class BooleanHasher
    implements OdpsHasher<Boolean> {
        private BooleanHasher() {
        }

        @Override
        public int hash(Boolean val) {
            if (val == null) {
                return 0;
            }
            if (val.booleanValue()) {
                return 388737479;
            }
            return -978963218;
        }
    }

    private static class DoubleHasher
    implements OdpsHasher<Double> {
        private DoubleHasher() {
        }

        @Override
        public int hash(Double val) {
            if (val == null) {
                return 0;
            }
            return LegacyHashFactory.basicLongHasher(Double.doubleToLongBits(val));
        }
    }

    private static class FloatHasher
    implements OdpsHasher<Float> {
        private FloatHasher() {
        }

        @Override
        public int hash(Float val) {
            if (val == null) {
                return 0;
            }
            return LegacyHashFactory.basicLongHasher(Float.floatToIntBits(val.floatValue()));
        }
    }

    private static class BigintHasher
    implements OdpsHasher<Long> {
        private BigintHasher() {
        }

        @Override
        public int hash(Long val) {
            if (val == null) {
                return 0;
            }
            return LegacyHashFactory.basicLongHasher(val);
        }
    }

    private static class IntHasher
    implements OdpsHasher<Integer> {
        private IntHasher() {
        }

        @Override
        public int hash(Integer val) {
            if (val == null) {
                return 0;
            }
            return LegacyHashFactory.basicLongHasher(val.longValue());
        }
    }

    private static class SmallIntHasher
    implements OdpsHasher<Short> {
        private SmallIntHasher() {
        }

        @Override
        public int hash(Short val) {
            if (val == null) {
                return 0;
            }
            return LegacyHashFactory.basicLongHasher(val.longValue());
        }
    }

    private static class TinyIntHasher
    implements OdpsHasher<Byte> {
        private TinyIntHasher() {
        }

        @Override
        public int hash(Byte val) {
            if (val == null) {
                return 0;
            }
            return LegacyHashFactory.basicLongHasher(val.longValue());
        }
    }
}

