/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.utils;

import java.util.List;
import javax.annotation.Nullable;

public final class Preconditions {
    public static <T> T checkNotNull(@Nullable T reference, String argName) {
        if (reference == null) {
            throw new IllegalArgumentException(argName + " == null!");
        }
        return reference;
    }

    public static <T> T checkNotNull(@Nullable T reference, String argName, String errorMessage) {
        if (reference == null) {
            throw new IllegalArgumentException(argName + ":" + errorMessage);
        }
        return reference;
    }

    public static void checkArgument(boolean condition, String errorMessage) {
        if (!condition) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkString(String arg, String name) {
        if (arg == null || arg.isEmpty()) {
            throw new IllegalArgumentException(name + " is empty string!");
        }
    }

    public static void checkList(List<?> arg, String name) {
        Preconditions.checkList(arg, 1, name);
    }

    public static void checkList(List<?> arg, int minSize, String name) {
        Preconditions.checkNotNull(arg, name);
        if (arg.size() < minSize) {
            throw new IllegalArgumentException(name + " must has at least " + minSize + "items");
        }
        for (Object item : arg) {
            Preconditions.checkNotNull(item, name + "[x]");
        }
    }

    public static void checkInteger(Integer arg, int minValue, String name) {
        Preconditions.checkNotNull(arg, name);
        if (arg < minValue) {
            throw new IllegalArgumentException(name + " < " + minValue);
        }
    }

    public static void checkLong(Long arg, long minValue, String name) {
        Preconditions.checkNotNull(arg, name);
        if (arg < minValue) {
            throw new IllegalArgumentException(name + " < " + minValue);
        }
    }

    public static void checkIntList(List<Integer> arg, int minSize, int minValue, String name) {
        Preconditions.checkNotNull(arg, name);
        if (arg.size() < minSize) {
            throw new IllegalArgumentException(name + " must has at least " + minSize + "items");
        }
        for (Integer value : arg) {
            Preconditions.checkInteger(value, minValue, name + "[x]");
        }
    }

    private Preconditions() {
    }
}

